/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.net.InetAddress;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface HttpServerLogger
extends BasicLogger {
    public static final HttpServerLogger ROOT_LOGGER = (HttpServerLogger)Logger.getMessageLogger(HttpServerLogger.class, (String)"org.jboss.as.domain.http.api");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15100, value="Unexpected error executing model request")
    public void modelRequestError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15101, value="Unexpected error executing deployment upload request")
    public void uploadError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15102, value="Unable to load console module for slot %s, disabling console")
    public void consoleModuleNotFound(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15103, value="A secure port has been specified for the HTTP interface but no SSL configuration in the realm.")
    public void sslConfigurationNotFound();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15104, value="Unable to load error contest for slot %s, disabling error context.")
    public void errorContextModuleNotFound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15105, value="Management interface is using different addresses for HTTP (%s) and HTTPS (%s). Redirection of HTTPS requests from HTTP socket to HTTPS socket will not be supported.")
    public void httpsRedirectNotSupported(InetAddress var1, InetAddress var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15106, value="Failed to send request.")
    public void responseFailed(@Cause Throwable var1);
}

