/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpsServer;
import org.jboss.dmr.ModelNode;

class DomainUtil {
    private DomainUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeResponse(HttpExchange http, boolean isGet, boolean pretty, ModelNode response, int status, boolean encode, String contentType) throws IOException {
        Headers responseHeaders = http.getResponseHeaders();
        responseHeaders.add("Content-Type", contentType);
        http.sendResponseHeaders(status, 0L);
        if (isGet && status == 200) {
            response = response.get("result");
        }
        OutputStream out = http.getResponseBody();
        PrintWriter print = new PrintWriter(out);
        try {
            if (encode) {
                response.writeBase64(out);
            } else {
                response.writeJSONString(print, !pretty);
            }
        }
        finally {
            print.flush();
            out.flush();
            DomainUtil.safeClose(print);
            DomainUtil.safeClose(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeResponse(HttpExchange exchange, OperationResponse operationResponse, int streamIndex) throws IOException {
        Headers responseHeaders = exchange.getResponseHeaders();
        OperationResponse.StreamEntry entry = (OperationResponse.StreamEntry)operationResponse.getInputStreams().get(streamIndex);
        String mimeType = DomainUtil.determineMimeType(entry, exchange);
        responseHeaders.add("Content-Type", mimeType + "; charset=" + "utf-8");
        exchange.sendResponseHeaders(200, 0L);
        OutputStream out = exchange.getResponseBody();
        byte[] buffer = new byte[1024];
        try {
            int res;
            InputStream inputStream = entry.getStream();
            while ((res = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, res);
            }
        }
        finally {
            out.flush();
            DomainUtil.safeClose(out);
        }
    }

    private static String determineMimeType(OperationResponse.StreamEntry entry, HttpExchange exchange) {
        String entryType = entry.getMimeType();
        List headerValues = exchange.getRequestHeaders().get((Object)"Accept");
        if (headerValues == null || headerValues.size() == 0) {
            return entryType;
        }
        String wildCard = null;
        int slash = entryType.indexOf(47);
        if (slash > 0) {
            wildCard = entryType.substring(0, slash) + "/*";
        }
        for (String acceptable : headerValues) {
            if (!"*/*".equals(acceptable) && !acceptable.contains(entryType) && (wildCard == null || !acceptable.contains(wildCard))) continue;
            return entryType;
        }
        return "application/octet-stream";
    }

    static void writeResponse(HttpExchange http, boolean isGet, boolean pretty, ModelNode response, int status, boolean encode) throws IOException {
        String contentType = encode ? "application/dmr-encoded" : "application/json";
        DomainUtil.writeResponse(http, isGet, pretty, response, status, encode, contentType);
    }

    static void safeClose(Closeable close) {
        try {
            close.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String constructUrl(HttpExchange exchange, String path) {
        Headers headers = exchange.getRequestHeaders();
        String host = headers.getFirst("Host");
        String protocol = exchange.getHttpContext().getServer() instanceof HttpsServer ? "https" : "http";
        return protocol + "://" + host + path;
    }
}

