/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class Utils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;
    private static long lastGC;
    private static final HashMap<String, byte[]> RESOURCES;
    private static boolean allowAllClasses;
    private static HashSet<String> allowedClassNames;
    private static String[] allowedClassNamePrefixes;

    private Utils() {
    }

    private static int readInt(byte[] buff, int pos) {
        return (buff[pos++] << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos] & 0xFF);
    }

    public static void writeLong(byte[] buff, int pos, long x) {
        Utils.writeInt(buff, pos, (int)(x >> 32));
        Utils.writeInt(buff, pos + 4, (int)x);
    }

    private static void writeInt(byte[] buff, int pos, int x) {
        buff[pos++] = (byte)(x >> 24);
        buff[pos++] = (byte)(x >> 16);
        buff[pos++] = (byte)(x >> 8);
        buff[pos++] = (byte)x;
    }

    public static long readLong(byte[] buff, int pos) {
        return ((long)Utils.readInt(buff, pos) << 32) + ((long)Utils.readInt(buff, pos + 4) & 0xFFFFFFFFL);
    }

    public static int indexOf(byte[] bytes, byte[] pattern, int start) {
        if (pattern.length == 0) {
            return start;
        }
        if (start > bytes.length) {
            return -1;
        }
        int last = bytes.length - pattern.length + 1;
        int patternLen = pattern.length;
        while (start < last) {
            block5: {
                for (int i = 0; i < patternLen; ++i) {
                    if (bytes[start + i] == pattern[i]) {
                        continue;
                    }
                    break block5;
                }
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static int getByteArrayHash(byte[] value) {
        int len;
        int h = len = value.length;
        if (len < 50) {
            for (int i = 0; i < len; ++i) {
                h = 31 * h + value[i];
            }
        } else {
            int i;
            int step = len / 16;
            for (i = 0; i < 4; ++i) {
                h = 31 * h + value[i];
                h = 31 * h + value[--len];
            }
            for (i = 4 + step; i < len; i += step) {
                h = 31 * h + value[i];
            }
        }
        return h;
    }

    public static boolean compareSecure(byte[] test, byte[] good) {
        if (test == null || good == null) {
            return test == null && good == null;
        }
        int len = test.length;
        if (len != good.length) {
            return false;
        }
        if (len == 0) {
            return true;
        }
        int bits = 0;
        for (int i = 0; i < len; ++i) {
            bits |= test[i] ^ good[i];
        }
        return bits == 0;
    }

    public static int compareNotNull(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            byte b = data1[i];
            byte b2 = data2[i];
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return Integer.signum(data1.length - data2.length);
    }

    public static byte[] copy(byte[] source, byte[] target) {
        int len = source.length;
        if (len > target.length) {
            target = new byte[len];
        }
        System.arraycopy(source, 0, target, 0, len);
        return target;
    }

    public static byte[] cloneByteArray(byte[] b) {
        if (b == null) {
            return null;
        }
        int len = b.length;
        if (len == 0) {
            return EMPTY_BYTES;
        }
        byte[] copy = new byte[len];
        System.arraycopy(b, 0, copy, 0, len);
        return copy;
    }

    public static byte[] serialize(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw DbException.get(90026, e, e.toString());
        }
    }

    public static Object deserialize(byte[] data) {
        try {
            ObjectInputStream is;
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            if (SysProperties.USE_THREAD_CONTEXT_CLASS_LOADER) {
                final ClassLoader loader = Thread.currentThread().getContextClassLoader();
                is = new ObjectInputStream(in){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        try {
                            return Class.forName(desc.getName(), true, loader);
                        }
                        catch (ClassNotFoundException e) {
                            return super.resolveClass(desc);
                        }
                    }
                };
            } else {
                is = new ObjectInputStream(in);
            }
            return is.readObject();
        }
        catch (Throwable e) {
            throw DbException.get(90027, e, e.toString());
        }
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int getMemoryUsed() {
        Utils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        long mem = rt.totalMemory() - rt.freeMemory();
        return (int)(mem >> 10);
    }

    public static int getMemoryFree() {
        Utils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        return (int)(mem >> 10);
    }

    public static long getMemoryMax() {
        long max = Runtime.getRuntime().maxMemory();
        return max / 1024L;
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long time = System.currentTimeMillis();
        if (lastGC + 50L < time) {
            for (int i = 0; i < 8; ++i) {
                runtime.gc();
                long now = runtime.totalMemory();
                if (now == total) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                total = now;
            }
        }
    }

    public static byte[] newBytes(int len) {
        try {
            if (len == 0) {
                return EMPTY_BYTES;
            }
            return new byte[len];
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryError e2 = new OutOfMemoryError("Requested memory: " + len);
            e2.initCause(e);
            throw e2;
        }
    }

    public static int[] newIntArray(int len) {
        if (len == 0) {
            return EMPTY_INT_ARRAY;
        }
        return new int[len];
    }

    public static long[] newLongArray(int len) {
        if (len == 0) {
            return EMPTY_LONG_ARRAY;
        }
        return new long[len];
    }

    public static boolean haveCommonComparableSuperclass(Class<?> c1, Class<?> c2) {
        Class<?> top2;
        Class<?> top1;
        if (c1 == c2 || c1.isAssignableFrom(c2) || c2.isAssignableFrom(c1)) {
            return true;
        }
        do {
            top1 = c1;
        } while (Comparable.class.isAssignableFrom(c1 = c1.getSuperclass()));
        do {
            top2 = c2;
        } while (Comparable.class.isAssignableFrom(c2 = c2.getSuperclass()));
        return top1 == top2;
    }

    public static Class<?> loadUserClass(String className) {
        if (allowedClassNames == null) {
            String s = SysProperties.ALLOWED_CLASSES;
            ArrayList<String> prefixes = New.arrayList();
            boolean allowAll = false;
            HashSet classNames = New.hashSet();
            for (String p : StringUtils.arraySplit(s, ',', true)) {
                if (p.equals("*")) {
                    allowAll = true;
                    continue;
                }
                if (p.endsWith("*")) {
                    prefixes.add(p.substring(0, p.length() - 1));
                    continue;
                }
                classNames.add(p);
            }
            allowedClassNamePrefixes = new String[prefixes.size()];
            prefixes.toArray(allowedClassNamePrefixes);
            allowAllClasses = allowAll;
            allowedClassNames = classNames;
        }
        if (!allowAllClasses && !allowedClassNames.contains(className)) {
            boolean allowed = false;
            for (String s : allowedClassNamePrefixes) {
                if (!className.startsWith(s)) continue;
                allowed = true;
            }
            if (!allowed) {
                throw DbException.get(90134, className);
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e2) {
                throw DbException.get(90086, e, className);
            }
        }
        catch (NoClassDefFoundError e) {
            throw DbException.get(90086, e, className);
        }
        catch (Error e) {
            throw DbException.get(50000, e, className);
        }
    }

    public static byte[] getResource(String name) throws IOException {
        byte[] data = RESOURCES.get(name);
        if (data == null) {
            data = Utils.loadResource(name);
            RESOURCES.put(name, data);
        }
        return data == null ? EMPTY_BYTES : data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadResource(String name) throws IOException {
        InputStream in = Utils.class.getResourceAsStream("data.zip");
        if (in == null) {
            in = Utils.class.getResourceAsStream(name);
            if (in == null) {
                return null;
            }
            return IOUtils.readBytesAndClose(in, 0);
        }
        ZipInputStream zipIn = new ZipInputStream(in);
        try {
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (!entryName.startsWith("/")) {
                    entryName = "/" + entryName;
                }
                if (entryName.equals(name)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copy(zipIn, out);
                    zipIn.closeEntry();
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                zipIn.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            zipIn.close();
        }
        return null;
    }

    public static Object callStaticMethod(String classAndMethod, Object ... params) throws Exception {
        int lastDot = classAndMethod.lastIndexOf(46);
        String className = classAndMethod.substring(0, lastDot);
        String methodName = classAndMethod.substring(lastDot + 1);
        return Utils.callMethod(null, Class.forName(className), methodName, params);
    }

    public static Object callMethod(Object instance, String methodName, Object ... params) throws Exception {
        return Utils.callMethod(instance, instance.getClass(), methodName, params);
    }

    private static Object callMethod(Object instance, Class<?> clazz, String methodName, Object ... params) throws Exception {
        Method best = null;
        int bestMatch = 0;
        boolean isStatic = instance == null;
        for (Method m : clazz.getMethods()) {
            int p;
            if (Modifier.isStatic(m.getModifiers()) != isStatic || !m.getName().equals(methodName) || (p = Utils.match(m.getParameterTypes(), params)) <= bestMatch) continue;
            bestMatch = p;
            best = m;
        }
        if (best == null) {
            throw new NoSuchMethodException(methodName);
        }
        return best.invoke(instance, params);
    }

    public static Object newInstance(String className, Object ... params) throws Exception {
        Constructor<?> best = null;
        int bestMatch = 0;
        for (Constructor<?> c : Class.forName(className).getConstructors()) {
            int p = Utils.match(c.getParameterTypes(), params);
            if (p <= bestMatch) continue;
            bestMatch = p;
            best = c;
        }
        if (best == null) {
            throw new NoSuchMethodException(className);
        }
        return best.newInstance(params);
    }

    private static int match(Class<?>[] params, Object[] values) {
        int len = params.length;
        if (len == values.length) {
            int points = 1;
            for (int i = 0; i < len; ++i) {
                Class<?> vc;
                Class<?> pc = Utils.getNonPrimitiveClass(params[i]);
                Object v = values[i];
                Class<?> clazz = vc = v == null ? null : v.getClass();
                if (pc == vc) {
                    ++points;
                    continue;
                }
                if (vc == null || pc.isAssignableFrom(vc)) continue;
                return 0;
            }
            return points;
        }
        return 0;
    }

    public static Object getStaticField(String classAndField) throws Exception {
        int lastDot = classAndField.lastIndexOf(46);
        String className = classAndField.substring(0, lastDot);
        String fieldName = classAndField.substring(lastDot + 1);
        return Class.forName(className).getField(fieldName).get(null);
    }

    public static Object getField(Object instance, String fieldName) throws Exception {
        return instance.getClass().getField(fieldName).get(instance);
    }

    public static boolean isClassPresent(String fullyQualifiedClassName) {
        try {
            Class.forName(fullyQualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static String getProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    public static int getProperty(String key, int defaultValue) {
        String s = Utils.getProperty(key, null);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        String s = Utils.getProperty(key, null);
        if (s != null) {
            try {
                return Boolean.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static {
        RESOURCES = New.hashMap();
    }
}

