/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.h2.message.DbException;

public class ScriptReader {
    private Reader reader;
    private char[] buffer;
    private int bufferPos;
    private int bufferStart = -1;
    private int bufferEnd;
    private boolean endOfFile;
    private boolean insideRemark;
    private boolean blockRemark;
    private boolean skipRemarks;
    private int remarkStart;

    public ScriptReader(Reader reader) {
        this.reader = reader;
        this.buffer = new char[8192];
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    public String readStatement() {
        if (this.endOfFile) {
            return null;
        }
        try {
            return this.readStatementLoop();
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String readStatementLoop() throws IOException {
        this.bufferStart = this.bufferPos;
        c = this.read();
        block7: while (true) {
            if (c < 0) {
                this.endOfFile = true;
                if (this.bufferPos - 1 != this.bufferStart) break;
                return null;
            }
            if (c == 59) break;
            switch (c) {
                case 36: {
                    c = this.read();
                    if (c != 36 || this.bufferPos - this.bufferStart >= 3 && this.buffer[this.bufferPos - 3] > ' ') continue block7;
                    while ((c = this.read()) >= 0 && (c != 36 || (c = this.read()) >= 0 && c != 36)) {
                    }
                    c = this.read();
                    continue block7;
                }
                case 39: {
                    while ((c = this.read()) >= 0 && c != 39) {
                    }
                    c = this.read();
                    continue block7;
                }
                case 34: {
                    while ((c = this.read()) >= 0 && c != 34) {
                    }
                    c = this.read();
                    continue block7;
                }
                case 47: {
                    c = this.read();
                    if (c == 42) {
                        this.startRemark(false);
                        while ((c = this.read()) >= 0) {
                            if (c != 42) continue;
                            c = this.read();
                            if (c < 0) {
                                this.clearRemark();
                                break;
                            }
                            if (c != 47) continue;
                            this.endRemark();
                            break;
                        }
                        c = this.read();
                        continue block7;
                    }
                    if (c != 47) continue block7;
                    this.startRemark(false);
                    do {
                        if ((c = this.read()) >= 0) continue;
                        this.clearRemark();
                        ** GOTO lbl50
                    } while (c != 13 && c != 10);
                    this.endRemark();
lbl50:
                    // 2 sources

                    c = this.read();
                    continue block7;
                }
                case 45: {
                    c = this.read();
                    if (c != 45) continue block7;
                    this.startRemark(false);
                    do {
                        if ((c = this.read()) >= 0) continue;
                        this.clearRemark();
                        ** GOTO lbl62
                    } while (c != 13 && c != 10);
                    this.endRemark();
lbl62:
                    // 2 sources

                    c = this.read();
                    continue block7;
                }
            }
            c = this.read();
        }
        return new String(this.buffer, this.bufferStart, this.bufferPos - 1 - this.bufferStart);
    }

    private void startRemark(boolean block) {
        this.blockRemark = block;
        this.remarkStart = this.bufferPos - 2;
        this.insideRemark = true;
    }

    private void endRemark() {
        this.clearRemark();
        this.insideRemark = false;
    }

    private void clearRemark() {
        if (this.skipRemarks) {
            Arrays.fill(this.buffer, this.remarkStart, this.bufferPos, ' ');
        }
    }

    private int read() throws IOException {
        if (this.bufferPos >= this.bufferEnd) {
            return this.readBuffer();
        }
        return this.buffer[this.bufferPos++];
    }

    private int readBuffer() throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        int keep = this.bufferPos - this.bufferStart;
        if (keep > 0) {
            char[] src = this.buffer;
            if (keep + 4096 > src.length) {
                this.buffer = new char[src.length * 2];
            }
            System.arraycopy(src, this.bufferStart, this.buffer, 0, keep);
        }
        this.remarkStart -= this.bufferStart;
        this.bufferStart = 0;
        this.bufferPos = keep;
        int len = this.reader.read(this.buffer, keep, 4096);
        if (len == -1) {
            this.bufferEnd = -1024;
            this.endOfFile = true;
            ++this.bufferPos;
            return -1;
        }
        this.bufferEnd = keep + len;
        return this.buffer[this.bufferPos++];
    }

    public boolean isInsideRemark() {
        return this.insideRemark;
    }

    public boolean isBlockRemark() {
        return this.blockRemark;
    }

    public void setSkipRemarks(boolean skipRemarks) {
        this.skipRemarks = skipRemarks;
    }
}

