/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.store.fs.FileUtils;

public class FileChannelInputStream
extends InputStream {
    private FileChannel channel;
    private byte[] buffer = new byte[]{0};

    public FileChannelInputStream(FileChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        if (this.channel.position() >= this.channel.size()) {
            return -1;
        }
        FileUtils.readFully(this.channel, ByteBuffer.wrap(this.buffer));
        return this.buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.channel.position() + (long)len < this.channel.size()) {
            FileUtils.readFully(this.channel, ByteBuffer.wrap(b, off, len));
            return len;
        }
        return super.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

