/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.h2.bnf.Bnf;
import org.h2.message.TraceSystem;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbContextRule;
import org.h2.server.web.WebServer;
import org.h2.util.New;

class WebSession {
    private static final int MAX_HISTORY = 1000;
    long lastAccess;
    HashMap<String, Object> map = New.hashMap();
    Locale locale;
    Statement executingStatement;
    ResultSet result;
    private WebServer server;
    private ArrayList<String> commandHistory = New.arrayList();
    private Connection conn;
    private DatabaseMetaData meta;
    private DbContents contents = new DbContents();
    private DbContextRule columnRule;
    private DbContextRule newAliasRule;
    private DbContextRule schemaRule;
    private DbContextRule tableRule;
    private DbContextRule aliasRule;
    private DbContextRule columnAliasRule;
    private Bnf bnf;
    private boolean shutdownServerOnDisconnect;

    WebSession(WebServer server) {
        this.server = server;
    }

    void put(String key, Object value) {
        this.map.put(key, value);
    }

    Object get(String key) {
        if ("sessions".equals(key)) {
            return this.server.getSessions();
        }
        return this.map.get(key);
    }

    void remove(String key) {
        this.map.remove(key);
    }

    Bnf getBnf() {
        return this.bnf;
    }

    void loadBnf() {
        try {
            Bnf newBnf = Bnf.getInstance(null);
            this.columnRule = new DbContextRule(this.contents, 0);
            this.newAliasRule = new DbContextRule(this.contents, 3);
            this.aliasRule = new DbContextRule(this.contents, 2);
            this.tableRule = new DbContextRule(this.contents, 1);
            this.schemaRule = new DbContextRule(this.contents, 5);
            this.columnAliasRule = new DbContextRule(this.contents, 4);
            newBnf.updateTopic("column_name", this.columnRule);
            newBnf.updateTopic("new_table_alias", this.newAliasRule);
            newBnf.updateTopic("table_alias", this.aliasRule);
            newBnf.updateTopic("column_alias", this.columnAliasRule);
            newBnf.updateTopic("table_name", this.tableRule);
            newBnf.updateTopic("schema_name", this.schemaRule);
            newBnf.linkStatements();
            this.bnf = newBnf;
        }
        catch (Exception e) {
            this.server.traceError(e);
        }
    }

    String getCommand(int id) {
        return this.commandHistory.get(id);
    }

    void addCommand(String sql) {
        int idx;
        if (sql == null) {
            return;
        }
        if ((sql = sql.trim()).length() == 0) {
            return;
        }
        if (this.commandHistory.size() > 1000) {
            this.commandHistory.remove(0);
        }
        if ((idx = this.commandHistory.indexOf(sql)) >= 0) {
            this.commandHistory.remove(idx);
        }
        this.commandHistory.add(sql);
    }

    ArrayList<String> getCommands() {
        return this.commandHistory;
    }

    HashMap<String, Object> getInfo() {
        HashMap<String, Object> m = New.hashMap();
        m.putAll(this.map);
        m.put("lastAccess", new Timestamp(this.lastAccess).toString());
        try {
            m.put("url", this.conn == null ? "${text.admin.notConnected}" : this.conn.getMetaData().getURL());
            m.put("user", this.conn == null ? "-" : this.conn.getMetaData().getUserName());
            m.put("lastQuery", this.commandHistory.size() == 0 ? "" : this.commandHistory.get(0));
            m.put("executing", this.executingStatement == null ? "${text.admin.no}" : "${text.admin.yes}");
        }
        catch (SQLException e) {
            TraceSystem.traceThrowable(e);
        }
        return m;
    }

    void setConnection(Connection conn) throws SQLException {
        this.conn = conn;
        this.meta = conn == null ? null : conn.getMetaData();
        this.contents = new DbContents();
    }

    DatabaseMetaData getMetaData() {
        return this.meta;
    }

    Connection getConnection() {
        return this.conn;
    }

    DbContents getContents() {
        return this.contents;
    }

    void setShutdownServerOnDisconnect() {
        this.shutdownServerOnDisconnect = true;
    }

    boolean getShutdownServerOnDisconnect() {
        return this.shutdownServerOnDisconnect;
    }

    void close() {
        if (this.executingStatement != null) {
            try {
                this.executingStatement.cancel();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

