/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbTableOrView;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class DbSchema {
    static final int MAX_TABLES_LIST_INDEXES = 100;
    static final int MAX_TABLES_LIST_COLUMNS = 500;
    final DbContents contents;
    final String name;
    final boolean isDefault;
    final boolean isSystem;
    final String quotedName;
    DbTableOrView[] tables;

    DbSchema(DbContents contents, String name, boolean isDefault) {
        this.contents = contents;
        this.name = name;
        this.quotedName = contents.quoteIdentifier(name);
        this.isDefault = isDefault;
        this.isSystem = StringUtils.toUpperEnglish(name).startsWith("INFO") ? true : (contents.isPostgreSQL && StringUtils.toUpperEnglish(name).startsWith("PG_") ? true : contents.isDerby && name.startsWith("SYS"));
    }

    void readTables(DatabaseMetaData meta, String[] tableTypes) throws SQLException {
        ResultSet rs = meta.getTables(null, this.name, null, tableTypes);
        ArrayList<DbTableOrView> list = New.arrayList();
        while (rs.next()) {
            DbTableOrView table = new DbTableOrView(this, rs);
            if (this.contents.isOracle && table.name.indexOf(36) > 0) continue;
            list.add(table);
        }
        rs.close();
        this.tables = new DbTableOrView[list.size()];
        list.toArray(this.tables);
        if (this.tables.length < 500) {
            for (DbTableOrView tab : this.tables) {
                tab.readColumns(meta);
            }
        }
    }
}

