/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.New;

public class JdbcStatement
extends TraceObject
implements Statement {
    protected JdbcConnection conn;
    protected SessionInterface session;
    protected JdbcResultSet resultSet;
    protected int maxRows;
    protected int fetchSize = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
    protected int updateCount;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    protected boolean closedByResultSet;
    private CommandInterface executingCommand;
    private int lastExecutedCommandType;
    private ArrayList<String> batchCommands;
    private boolean escapeProcessing = true;

    JdbcStatement(JdbcConnection conn, int id, int resultSetType, int resultSetConcurrency, boolean closeWithResultSet) {
        this.conn = conn;
        this.session = conn.getSession();
        this.setTrace(this.session.getTrace(), 8, id);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.closedByResultSet = closeWithResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            int id = JdbcStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, id, "executeQuery(" + JdbcStatement.quote(sql) + ")");
            }
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface result;
                this.checkClosed();
                this.closeOldResultSet();
                sql = JdbcConnection.translateSQL(sql, this.escapeProcessing);
                CommandInterface command = this.conn.prepareCommand(sql, this.fetchSize);
                boolean scrollable = this.resultSetType != 1003;
                boolean updatable = this.resultSetConcurrency == 1008;
                this.setExecutingStatement(command);
                try {
                    result = command.executeQuery(this.maxRows, scrollable);
                }
                finally {
                    this.setExecutingStatement(null);
                }
                command.close();
                this.resultSet = new JdbcResultSet(this.conn, this, result, id, this.closedByResultSet, scrollable, updatable);
            }
            return this.resultSet;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", sql);
            return this.executeUpdateInternal(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal(String sql) throws SQLException {
        this.checkClosedForWrite();
        try {
            this.closeOldResultSet();
            sql = JdbcConnection.translateSQL(sql, this.escapeProcessing);
            CommandInterface command = this.conn.prepareCommand(sql, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(command);
                try {
                    this.updateCount = command.executeUpdate();
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            command.close();
            int n = this.updateCount;
            return n;
        }
        finally {
            this.afterWriting();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.debugCodeCall("execute", sql);
            return this.executeInternal(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(String sql) throws SQLException {
        int id = JdbcStatement.getNextId(4);
        this.checkClosedForWrite();
        try {
            boolean returnsResultSet;
            this.closeOldResultSet();
            sql = JdbcConnection.translateSQL(sql, this.escapeProcessing);
            CommandInterface command = this.conn.prepareCommand(sql, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(command);
                try {
                    if (command.isQuery()) {
                        returnsResultSet = true;
                        boolean scrollable = this.resultSetType != 1003;
                        boolean updatable = this.resultSetConcurrency == 1008;
                        ResultInterface result = command.executeQuery(this.maxRows, scrollable);
                        this.resultSet = new JdbcResultSet(this.conn, this, result, id, this.closedByResultSet, scrollable, updatable);
                    } else {
                        returnsResultSet = false;
                        this.updateCount = command.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            command.close();
            boolean bl = returnsResultSet;
            return bl;
        }
        finally {
            this.afterWriting();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet != null) {
                int id = this.resultSet.getTraceId();
                this.debugCodeAssign("ResultSet", 4, id, "getResultSet()");
            } else {
                this.debugCodeCall("getResultSet");
            }
            return this.resultSet;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getUpdateCount");
            this.checkClosed();
            return this.updateCount;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.closeOldResultSet();
                if (this.conn != null) {
                    this.conn = null;
                }
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Connection getConnection() {
        this.debugCodeCall("getConnection");
        return this.conn;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.debugCodeCall("setCursorName", name);
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.debugCodeCall("setFetchDirection", direction);
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getMaxRows");
            this.checkClosed();
            return this.maxRows;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        try {
            this.debugCodeCall("setMaxRows", maxRows);
            this.checkClosed();
            if (maxRows < 0) {
                throw DbException.getInvalidValueException("maxRows", maxRows);
            }
            this.maxRows = maxRows;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", rows);
            this.checkClosed();
            if (rows < 0 || rows > 0 && this.maxRows > 0 && rows > this.maxRows) {
                throw DbException.getInvalidValueException("rows", rows);
            }
            if (rows == 0) {
                rows = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.fetchSize = rows;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.fetchSize;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getResultSetConcurrency");
            this.checkClosed();
            return this.resultSetConcurrency;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            this.debugCodeCall("getResultSetType");
            this.checkClosed();
            return this.resultSetType;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            this.debugCodeCall("getMaxFieldSize");
            this.checkClosed();
            return 0;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.debugCodeCall("setMaxFieldSize", max);
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setEscapeProcessing(" + enable + ");");
            }
            this.checkClosed();
            this.escapeProcessing = enable;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        try {
            this.debugCodeCall("cancel");
            this.checkClosed();
            CommandInterface c = this.executingCommand;
            try {
                if (c != null) {
                    c.cancel();
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            return this.conn.getQueryTimeout();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", seconds);
            this.checkClosed();
            if (seconds < 0) {
                throw DbException.getInvalidValueException("seconds", seconds);
            }
            this.conn.setQueryTimeout(seconds);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.debugCodeCall("addBatch", sql);
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql, this.escapeProcessing);
            if (this.batchCommands == null) {
                this.batchCommands = New.arrayList();
            }
            this.batchCommands.add(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchCommands = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.debugCodeCall("executeBatch");
        this.checkClosedForWrite();
        try {
            if (this.batchCommands == null) {
                this.batchCommands = New.arrayList();
            }
            int size = this.batchCommands.size();
            int[] result = new int[size];
            boolean error = false;
            SQLException next = null;
            for (int i = 0; i < size; ++i) {
                String sql = this.batchCommands.get(i);
                try {
                    result[i] = this.executeUpdateInternal(sql);
                    continue;
                }
                catch (Exception re) {
                    SQLException e = this.logAndConvert(re);
                    if (next == null) {
                        next = e;
                    } else {
                        e.setNextException(next);
                        next = e;
                    }
                    result[i] = -3;
                    error = true;
                }
            }
            this.batchCommands = null;
            if (error) {
                throw new JdbcBatchUpdateException(next, result);
            }
            int[] nArray = result;
            this.afterWriting();
            return nArray;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception e) {
                throw this.logAndConvert(e);
            }
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            int id = JdbcStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, id, "getGeneratedKeys()");
            }
            this.checkClosed();
            return this.conn.getGeneratedKeys(this, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            this.checkClosed();
            this.closeOldResultSet();
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            this.debugCodeCall("getMoreResults", current);
            switch (current) {
                case 1: 
                case 3: {
                    this.checkClosed();
                    this.closeOldResultSet();
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("current", current);
                }
            }
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            return this.executeUpdateInternal(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteIntArray(columnIndexes) + ");");
            }
            return this.executeUpdateInternal(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteArray(columnNames) + ");");
            }
            return this.executeUpdateInternal(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            return this.executeInternal(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteIntArray(columnIndexes) + ");");
            }
            return this.executeInternal(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(sql) + ", " + JdbcStatement.quoteArray(columnNames) + ");");
            }
            return this.executeInternal(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            this.debugCodeCall("getResultSetHoldability");
            this.checkClosed();
            return 1;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    boolean checkClosed() {
        return this.checkClosed(false);
    }

    boolean checkClosedForWrite() {
        return this.checkClosed(true);
    }

    protected boolean checkClosed(boolean write) {
        if (this.conn == null) {
            throw DbException.get(90007);
        }
        this.conn.checkClosed(write);
        SessionInterface s = this.conn.getSession();
        if (s != this.session) {
            this.session = s;
            this.trace = this.session.getTrace();
            return true;
        }
        return false;
    }

    void afterWriting() {
        if (this.conn != null) {
            this.conn.afterWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOldResultSet() throws SQLException {
        try {
            if (!this.closedByResultSet && this.resultSet != null) {
                this.resultSet.closeInternal();
            }
        }
        finally {
            this.resultSet = null;
            this.updateCount = -1;
        }
    }

    protected void setExecutingStatement(CommandInterface c) {
        if (c == null) {
            this.conn.setExecutingStatement(null);
        } else {
            this.conn.setExecutingStatement(this);
            this.lastExecutedCommandType = c.getCommandType();
        }
        this.executingCommand = c;
    }

    public int getLastExecutedCommandType() {
        return this.lastExecutedCommandType;
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.conn == null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw this.unsupported("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw this.unsupported("isWrapperFor");
    }

    @Override
    public boolean isPoolable() {
        this.debugCodeCall("isPoolable");
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) {
        if (this.isDebugEnabled()) {
            this.debugCode("setPoolable(" + poolable + ");");
        }
    }

    public String toString() {
        return this.getTraceObjectName();
    }
}

