/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectUnion;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.ViewCursor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.SynchronizedVerifier;
import org.h2.util.Utils;
import org.h2.value.Value;

public class ViewIndex
extends BaseIndex {
    private final TableView view;
    private final String querySQL;
    private final ArrayList<Parameter> originalParameters;
    private final SmallLRUCache<IntArray, CostElement> costCache = SmallLRUCache.newInstance(64);
    private boolean recursive;
    private int[] indexMasks;
    private String planSQL;
    private Query query;
    private Session createSession;

    public ViewIndex(TableView view, String querySQL, ArrayList<Parameter> originalParameters, boolean recursive) {
        this.initBaseIndex(view, 0, null, null, IndexType.createNonUnique(false));
        this.view = view;
        this.querySQL = querySQL;
        this.originalParameters = originalParameters;
        this.recursive = recursive;
        this.columns = new Column[0];
    }

    public ViewIndex(TableView view, ViewIndex index, Session session, int[] masks) {
        this.initBaseIndex(view, 0, null, null, IndexType.createNonUnique(false));
        this.view = view;
        this.querySQL = index.querySQL;
        this.originalParameters = index.originalParameters;
        this.recursive = index.recursive;
        this.indexMasks = masks;
        this.createSession = session;
        this.columns = new Column[0];
        if (!this.recursive) {
            this.query = this.getQuery(session, masks);
            this.planSQL = this.query.getPlanSQL();
        }
    }

    public Session getSession() {
        return this.createSession;
    }

    @Override
    public String getPlanSQL() {
        return this.planSQL;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public synchronized double getCost(Session session, int[] masks) {
        long time;
        if (this.recursive) {
            return 1000.0;
        }
        IntArray masksArray = new IntArray(masks == null ? Utils.EMPTY_INT_ARRAY : masks);
        SynchronizedVerifier.check(this.costCache);
        CostElement cachedCost = (CostElement)this.costCache.get(masksArray);
        if (cachedCost != null && (time = System.currentTimeMillis()) < cachedCost.evaluatedAt + 10000L) {
            return cachedCost.cost;
        }
        Query q = (Query)session.prepare(this.querySQL, true);
        if (masks != null) {
            IntArray paramIndex = new IntArray();
            for (int i = 0; i < masks.length; ++i) {
                int mask = masks[i];
                if (mask == 0) continue;
                paramIndex.add(i);
            }
            int len = paramIndex.size();
            for (int i = 0; i < len; ++i) {
                Parameter param;
                int idx = paramIndex.get(i);
                int mask = masks[idx];
                int nextParamIndex = q.getParameters().size() + this.view.getParameterOffset();
                if ((mask & 1) != 0) {
                    param = new Parameter(nextParamIndex);
                    q.addGlobalCondition(param, idx, 16);
                    continue;
                }
                if ((mask & 2) != 0) {
                    param = new Parameter(nextParamIndex);
                    q.addGlobalCondition(param, idx, 1);
                }
                if ((mask & 4) == 0) continue;
                param = new Parameter(nextParamIndex);
                q.addGlobalCondition(param, idx, 3);
            }
            String sql = q.getPlanSQL();
            q = (Query)session.prepare(sql, true);
        }
        double cost = q.getCost();
        cachedCost = new CostElement();
        cachedCost.evaluatedAt = System.currentTimeMillis();
        cachedCost.cost = cost;
        this.costCache.put(masksArray, cachedCost);
        return cost;
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (this.recursive) {
            ResultInterface recResult = this.view.getRecursiveResult();
            if (recResult != null) {
                recResult.reset();
                return new ViewCursor(this, recResult, first, last);
            }
            if (this.query == null) {
                this.query = (Query)this.createSession.prepare(this.querySQL, true);
                this.planSQL = this.query.getPlanSQL();
            }
            if (!(this.query instanceof SelectUnion)) {
                throw DbException.get(42001, "recursive queries without UNION ALL");
            }
            SelectUnion union = (SelectUnion)this.query;
            if (union.getUnionType() != 1) {
                throw DbException.get(42001, "recursive queries without UNION ALL");
            }
            Query left = union.getLeft();
            left.disableCache();
            LocalResult r = left.query(0);
            LocalResult result = union.getEmptyResult();
            while (r.next()) {
                result.addRow(r.currentRow());
            }
            Query right = union.getRight();
            r.reset();
            this.view.setRecursiveResult(r);
            right.disableCache();
            while ((r = right.query(0)).getRowCount() != 0) {
                while (r.next()) {
                    result.addRow(r.currentRow());
                }
                r.reset();
                this.view.setRecursiveResult(r);
            }
            this.view.setRecursiveResult(null);
            result.done();
            return new ViewCursor(this, result, first, last);
        }
        ArrayList<Parameter> paramList = this.query.getParameters();
        if (this.originalParameters != null) {
            int size = this.originalParameters.size();
            for (int i = 0; i < size; ++i) {
                Parameter orig = this.originalParameters.get(i);
                int idx = orig.getIndex();
                Value value = orig.getValue(session);
                ViewIndex.setParameter(paramList, idx, value);
            }
        }
        int len = first != null ? first.getColumnCount() : (last != null ? last.getColumnCount() : 0);
        int idx = this.originalParameters == null ? 0 : this.originalParameters.size();
        idx += this.view.getParameterOffset();
        for (int i = 0; i < len; ++i) {
            int x;
            Value v;
            if (first != null && (v = first.getValue(i)) != null) {
                x = idx++;
                ViewIndex.setParameter(paramList, x, v);
            }
            if (last == null || this.indexMasks[i] == 1 || (v = last.getValue(i)) == null) continue;
            x = idx++;
            ViewIndex.setParameter(paramList, x, v);
        }
        LocalResult result = this.query.query(0);
        return new ViewCursor(this, result, first, last);
    }

    private static void setParameter(ArrayList<Parameter> paramList, int x, Value v) {
        if (x >= paramList.size()) {
            return;
        }
        Parameter param = paramList.get(x);
        param.setValue(v);
    }

    private Query getQuery(Session session, int[] masks) {
        Query q = (Query)session.prepare(this.querySQL, true);
        if (masks == null) {
            return q;
        }
        if (!q.allowGlobalConditions()) {
            return q;
        }
        int firstIndexParam = this.originalParameters == null ? 0 : this.originalParameters.size();
        firstIndexParam += this.view.getParameterOffset();
        IntArray paramIndex = new IntArray();
        int indexColumnCount = 0;
        for (int i = 0; i < masks.length; ++i) {
            int mask = masks[i];
            if (mask == 0) continue;
            ++indexColumnCount;
            paramIndex.add(i);
            if (Integer.bitCount(mask) <= 1) continue;
            paramIndex.add(i);
        }
        int len = paramIndex.size();
        ArrayList<Column> columnList = New.arrayList();
        int i = 0;
        while (i < len) {
            Parameter param;
            int idx = paramIndex.get(i);
            columnList.add(this.table.getColumn(idx));
            int mask = masks[idx];
            if ((mask & 1) == 1) {
                param = new Parameter(firstIndexParam + i);
                q.addGlobalCondition(param, idx, 16);
                ++i;
            }
            if ((mask & 2) == 2) {
                param = new Parameter(firstIndexParam + i);
                q.addGlobalCondition(param, idx, 1);
                ++i;
            }
            if ((mask & 4) != 4) continue;
            param = new Parameter(firstIndexParam + i);
            q.addGlobalCondition(param, idx, 3);
            ++i;
        }
        this.columns = new Column[columnList.size()];
        columnList.toArray(this.columns);
        this.indexColumns = new IndexColumn[indexColumnCount];
        this.columnIds = new int[indexColumnCount];
        int indexColumnId = 0;
        for (int type = 0; type < 2; ++type) {
            for (int i2 = 0; i2 < masks.length; ++i2) {
                int mask = masks[i2];
                if (mask == 0 || (type == 0 ? (mask & 1) != 1 : (mask & 1) == 1)) continue;
                IndexColumn c = new IndexColumn();
                c.column = this.table.getColumn(i2);
                this.indexColumns[indexColumnId] = c;
                this.columnIds[indexColumnId] = c.column.getColumnId();
                ++indexColumnId;
            }
        }
        String sql = q.getPlanSQL();
        q = (Query)session.prepare(sql, true);
        return q;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("VIEW");
    }

    public void setRecursive(boolean value) {
        this.recursive = value;
    }

    @Override
    public long getRowCount(Session session) {
        return 0L;
    }

    @Override
    public long getRowCountApproximation() {
        return 0L;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    static class CostElement {
        long evaluatedAt;
        double cost;

        CostElement() {
        }
    }
}

