/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.as.domain.management.security.UserPropertiesFileLoader;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.DisplaySecret;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.adduser.UpdatePropertiesHandler;
import org.jboss.msc.service.StartException;

public class AddUserState
extends UpdatePropertiesHandler
implements State {
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public AddUserState(ConsoleWrapper theConsole, StateValues stateValues) {
        super(theConsole);
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    public State execute() {
        State nextState = this.update(this.stateValues);
        if (nextState == null && this.stateValues.isInteractive()) {
            nextState = new ConfirmationChoice(this.theConsole, DomainManagementMessages.MESSAGES.serverUser(), DomainManagementMessages.MESSAGES.yesNo(), (State)new DisplaySecret(this.theConsole, this.stateValues), null);
        }
        return nextState;
    }

    @Override
    void persist(String[] entry, File file) throws IOException {
        this.persist(entry, file, null);
    }

    @Override
    void persist(String[] entry, File file, String realm) throws IOException {
        PropertiesFileLoader propertiesHandler = realm == null ? new PropertiesFileLoader(file.getAbsolutePath()) : new UserPropertiesFileLoader(file.getAbsolutePath());
        try {
            propertiesHandler.start(null);
            if (realm != null) {
                ((UserPropertiesFileLoader)propertiesHandler).setRealmName(realm);
            }
            Properties prob = propertiesHandler.getProperties();
            prob.setProperty(entry[0], entry[1]);
            propertiesHandler.persistProperties();
        }
        catch (StartException e) {
            throw new IllegalStateException(DomainManagementMessages.MESSAGES.unableToAddUser(file.getAbsolutePath(), e.getMessage()));
        }
        finally {
            propertiesHandler.stop(null);
        }
    }

    @Override
    String consoleUserMessage(String filePath) {
        return DomainManagementMessages.MESSAGES.addedUser(this.stateValues.getUserName(), filePath);
    }

    @Override
    String consoleGroupsMessage(String filePath) {
        return DomainManagementMessages.MESSAGES.addedGroups(this.stateValues.getUserName(), this.stateValues.getGroups(), filePath);
    }

    @Override
    String errorMessage(String filePath, Throwable e) {
        return DomainManagementMessages.MESSAGES.unableToAddUser(filePath, e.getMessage());
    }
}

