/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.NativeLoggers;
import org.jboss.ws.NativeMessages;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.common.utils.JBossWSEntityResolver;
import org.jboss.ws.common.utils.ResourceURL;
import org.jboss.ws.core.soap.utils.Style;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLDocumentation;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLMIMEPart;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.XSModelTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.JavaToXSD;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDL11Reader {
    private static final Logger log = Logger.getLogger(WSDL11Reader.class);
    private WSDLDefinitions destWsdl;
    private JBossWSEntityResolver entityResolver = new JBossWSEntityResolver();
    private Map<String, QName> messagePartToElementMap = new HashMap<String, QName>();
    private Map<String, URL> schemaLocationsMap = new HashMap<String, URL>();
    private LinkedHashMap<QName, Binding> allBindings;
    private LinkedHashMap<QName, Binding> portTypeBindings;
    private List<File> tempFiles = new ArrayList<File>();
    private Map<QName, List<String>> skippedSWAParts = new HashMap<QName, List<String>>();
    private Map<String, List<Service>> servicesByNamespace = new HashMap<String, List<Service>>();
    private Map<String, List<Binding>> bindingsByNamespace = new HashMap<String, List<Binding>>();
    private Map<String, List<PortType>> portTypesByNamespace = new HashMap<String, List<PortType>>();
    private Map<String, List<Message>> messagesByNamespace = new HashMap<String, List<Message>>();
    private Set<Definition> importedDefinitions = new HashSet<Definition>();

    public WSDLDefinitions processDefinition(Definition srcWsdl, URL wsdlLoc) throws IOException, WSDLException {
        log.trace((Object)("processDefinition: " + wsdlLoc));
        this.destWsdl = new WSDLDefinitions();
        this.destWsdl.setWsdlTypes(new XSModelTypes());
        this.destWsdl.setWsdlOneOneDefinition(srcWsdl);
        this.destWsdl.setWsdlNamespace("http://schemas.xmlsoap.org/wsdl/");
        this.processNamespaces(srcWsdl);
        this.processTopLevelElements(srcWsdl);
        this.processTypes(srcWsdl, wsdlLoc);
        this.processUnknownExtensibilityElements((ElementExtensible)srcWsdl, this.destWsdl);
        this.processServices(srcWsdl);
        if (this.getAllDefinedBindings(srcWsdl).size() != this.destWsdl.getBindings().length) {
            this.processUnreachableBindings(srcWsdl);
        }
        this.cleanupTemporaryFiles();
        return this.destWsdl;
    }

    private void processTopLevelElements(Definition srcWsdl) {
        String targetNS = srcWsdl.getTargetNamespace();
        this.importedDefinitions.add(srcWsdl);
        Collection messages = srcWsdl.getMessages().values();
        for (Message message : messages) {
            List<Message> list = this.messagesByNamespace.get(targetNS);
            if (list == null) {
                list = new ArrayList<Message>();
                this.messagesByNamespace.put(targetNS, list);
            }
            if (message.isUndefined()) continue;
            list.add(message);
        }
        Collection portTypes = srcWsdl.getPortTypes().values();
        for (PortType portType : portTypes) {
            List<PortType> list = this.portTypesByNamespace.get(targetNS);
            if (list == null) {
                list = new ArrayList<PortType>();
                this.portTypesByNamespace.put(targetNS, list);
            }
            if (portType.isUndefined()) continue;
            list.add(portType);
        }
        Collection bindings = srcWsdl.getBindings().values();
        for (Binding binding : bindings) {
            List<Binding> list = this.bindingsByNamespace.get(targetNS);
            if (list == null) {
                list = new ArrayList<Binding>();
                this.bindingsByNamespace.put(targetNS, list);
            }
            if (binding.isUndefined()) continue;
            list.add(binding);
        }
        Collection services = srcWsdl.getServices().values();
        for (Service service : services) {
            List<Service> list = this.servicesByNamespace.get(targetNS);
            if (list == null) {
                list = new ArrayList<Service>();
                this.servicesByNamespace.put(targetNS, list);
            }
            list.add(service);
        }
        Collection importLists = srcWsdl.getImports().values();
        for (List imports : importLists) {
            for (Import imp : imports) {
                Definition impWsdl = imp.getDefinition();
                if (this.importedDefinitions.contains(impWsdl)) continue;
                this.processTopLevelElements(impWsdl);
            }
        }
    }

    private void cleanupTemporaryFiles() {
        for (File current : this.tempFiles) {
            current.delete();
        }
    }

    private void processUnreachableBindings(Definition srcWsdl) throws WSDLException {
        log.trace((Object)"processUnreachableBindings");
        for (Binding srcBinding : this.getAllDefinedBindings(srcWsdl).values()) {
            QName srcQName = srcBinding.getQName();
            WSDLBinding destBinding = this.destWsdl.getBinding(srcQName);
            if (destBinding != null) continue;
            this.processBinding(srcWsdl, srcBinding);
        }
    }

    private void processNamespaces(Definition srcWsdl) {
        String targetNS = srcWsdl.getTargetNamespace();
        this.destWsdl.setTargetNamespace(targetNS);
        Map nsMap = srcWsdl.getNamespaces();
        for (Map.Entry entry : nsMap.entrySet()) {
            String prefix = (String)entry.getKey();
            String nsURI = (String)entry.getValue();
            this.destWsdl.registerNamespaceURI(nsURI, prefix);
        }
    }

    private void processUnknownExtensibilityElements(ElementExtensible src, Extendable dest) throws WSDLException {
        List extElements = src.getExtensibilityElements();
        for (int i = 0; i < extElements.size(); ++i) {
            ExtensibilityElement extElement = (ExtensibilityElement)extElements.get(i);
            if (!(extElement instanceof UnknownExtensibilityElement)) continue;
            UnknownExtensibilityElement uee = (UnknownExtensibilityElement)extElement;
            this.processNotUnderstoodExtesibilityElement(uee, dest);
        }
    }

    private void processNotUnderstoodExtesibilityElement(UnknownExtensibilityElement extElement, Extendable dest) {
        Element element = (Element)extElement.getElement().cloneNode(true);
        WSDLExtensibilityElement notUnderstoodElement = new WSDLExtensibilityElement("notUnderstoodExtensibilityElement", element);
        notUnderstoodElement.setRequired("true".equalsIgnoreCase(element.getAttributeNS("http://schemas.xmlsoap.org/wsdl/", "required")));
        dest.addNotUnderstoodExtElement(notUnderstoodElement);
    }

    private void processTypes(Definition srcWsdl, URL wsdlLoc) throws IOException, WSDLException {
        log.trace((Object)("BEGIN processTypes: " + wsdlLoc));
        WSDLTypes destTypes = this.destWsdl.getWsdlTypes();
        Types srcTypes = srcWsdl.getTypes();
        if (srcTypes != null && srcTypes.getExtensibilityElements().size() > 0) {
            List extElements = srcTypes.getExtensibilityElements();
            int len = extElements.size();
            for (int i = 0; i < len; ++i) {
                Element domElement;
                ExtensibilityElement extElement = (ExtensibilityElement)extElements.get(i);
                if (extElement instanceof Schema) {
                    domElement = ((Schema)extElement).getElement();
                } else if (extElement instanceof UnknownExtensibilityElement) {
                    domElement = ((UnknownExtensibilityElement)extElement).getElement();
                } else {
                    throw new WSDLException("OTHER_ERROR", "Unsupported extensibility element: " + extElement);
                }
                Element domElementClone = (Element)domElement.cloneNode(true);
                this.copyParentNamespaceDeclarations(domElementClone, domElement);
                String localname = domElementClone.getLocalName();
                try {
                    HashMap<URL, URL> publishedMapping = new HashMap<URL, URL>();
                    if ("import".equals(localname)) {
                        this.processSchemaImport(destTypes, wsdlLoc, domElementClone, publishedMapping);
                        continue;
                    }
                    if ("schema".equals(localname)) {
                        this.processSchemaInclude(destTypes, wsdlLoc, domElementClone, publishedMapping);
                        continue;
                    }
                    throw NativeMessages.MESSAGES.unsupportedSchemaElement(wsdlLoc, localname);
                }
                catch (IOException e) {
                    throw new WSDLException("OTHER_ERROR", "Cannot extract schema definition", (Throwable)e);
                }
            }
            if (len > 0) {
                JavaToXSD jxsd = new JavaToXSD();
                JBossXSModel xsmodel = jxsd.parseSchema(this.schemaLocationsMap);
                WSDLUtils.addSchemaModel(destTypes, this.destWsdl.getTargetNamespace(), xsmodel);
            }
        } else {
            log.trace((Object)"Empty wsdl types element, processing imports");
            for (List srcImports : srcWsdl.getImports().values()) {
                for (Import srcImport : srcImports) {
                    Definition impDefinition = srcImport.getDefinition();
                    String impLoc = impDefinition.getDocumentBaseURI();
                    this.processTypes(impDefinition, new URL(impLoc));
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("END processTypes: " + wsdlLoc + "\n" + destTypes));
        }
    }

    private void copyParentNamespaceDeclarations(Element destElement, Element srcElement) {
        for (Node parent = srcElement.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!parent.hasAttributes()) continue;
            NamedNodeMap attributes = parent.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (!name.startsWith("xmlns:") || destElement.hasAttribute(name)) continue;
                destElement.setAttribute(name, value);
            }
        }
    }

    private void copyMissingNamespaceDeclarations(Element destElement, Element srcElement) {
        String nsUri;
        String prefix = destElement.getPrefix();
        try {
            nsUri = DOMUtils.getElementQName((Element)destElement).getNamespaceURI();
        }
        catch (IllegalArgumentException e) {
            nsUri = null;
        }
        if (prefix != null && nsUri == null) {
            destElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, srcElement.lookupNamespaceURI(prefix));
        }
        NamedNodeMap attributes = destElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String attrPrefix = attr.getPrefix();
            if (attrPrefix == null || attr.getName().startsWith("xmlns") || destElement.lookupNamespaceURI(attrPrefix) != null) continue;
            destElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attrPrefix, srcElement.lookupNamespaceURI(attrPrefix));
        }
        NodeList childrenList = destElement.getChildNodes();
        for (int i = 0; i < childrenList.getLength(); ++i) {
            Node node = childrenList.item(i);
            if (!(node instanceof Element)) continue;
            this.copyMissingNamespaceDeclarations((Element)node, srcElement);
        }
    }

    private void processSchemaImport(WSDLTypes types, URL wsdlLoc, Element importEl, Map<URL, URL> publishedLocations) throws IOException, WSDLException {
        URL newLoc;
        if (wsdlLoc == null) {
            throw NativeMessages.MESSAGES.cannotProcessImportParentLocationSetToNull();
        }
        log.trace((Object)("processSchemaImport: " + wsdlLoc));
        String location = this.getOptionalAttribute(importEl, "schemaLocation");
        if (location == null) {
            throw NativeMessages.MESSAGES.xsdImportNullSchemaLocation();
        }
        URL locationURL = this.getLocationURL(wsdlLoc, location);
        if (!publishedLocations.containsKey(locationURL)) {
            Element rootElement = DOMUtils.parse((InputStream)new ResourceURL(locationURL).openStream());
            this.processSchemaInclude(types, locationURL, rootElement, publishedLocations);
        }
        if ((newLoc = publishedLocations.get(locationURL)) != null) {
            importEl.setAttribute("schemaLocation", newLoc.toExternalForm());
        }
    }

    private void processSchemaInclude(WSDLTypes types, URL wsdlLoc, Element schemaEl, Map<URL, URL> publishedLocations) throws IOException, WSDLException {
        if (wsdlLoc == null) {
            throw NativeMessages.MESSAGES.cannotProcessIncludeParentLocationSetToNull();
        }
        log.trace((Object)("processSchemaInclude: " + wsdlLoc));
        String schemaPrefix = schemaEl.getPrefix();
        String importTag = schemaPrefix == null ? "import" : schemaPrefix + ":import";
        Element importElement = schemaEl.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", importTag);
        importElement.setAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
        schemaEl.insertBefore(importElement, DOMUtils.getFirstChildElement((Node)schemaEl));
        String targetNS = this.getOptionalAttribute(schemaEl, "targetNamespace");
        File tmpFile = null;
        if (targetNS != null) {
            log.trace((Object)("processSchemaInclude: [targetNS=" + targetNS + ",parentURL=" + wsdlLoc + "]"));
            tmpFile = SchemaUtils.getSchemaTempFile(targetNS);
            this.tempFiles.add(tmpFile);
            publishedLocations.put(wsdlLoc, tmpFile.toURL());
        } else {
            tmpFile = SchemaUtils.getSchemaTempFile("no_namespace");
            this.tempFiles.add(tmpFile);
            publishedLocations.put(wsdlLoc, tmpFile.toURL());
        }
        Iterator it = DOMUtils.getChildElements((Node)schemaEl, (QName)new QName("http://www.w3.org/2001/XMLSchema", "include"));
        while (it.hasNext()) {
            URL newLoc;
            Element includeEl = (Element)it.next();
            String location = this.getOptionalAttribute(includeEl, "schemaLocation");
            if (location == null) {
                throw NativeMessages.MESSAGES.xsdIncludeNullSchemaLocation();
            }
            URL locationURL = this.getLocationURL(wsdlLoc, location);
            Element rootElement = DOMUtils.parse((InputStream)new ResourceURL(locationURL).openStream());
            if (!publishedLocations.containsKey(locationURL)) {
                this.processSchemaInclude(types, locationURL, rootElement, publishedLocations);
            }
            if ((newLoc = publishedLocations.get(locationURL)) == null) continue;
            includeEl.setAttribute("schemaLocation", newLoc.toExternalForm());
        }
        if (tmpFile != null) {
            FileWriter fwrite = new FileWriter(tmpFile);
            new DOMWriter((Writer)fwrite).setPrettyprint(true).print((Node)schemaEl);
            fwrite.close();
        }
        if (targetNS != null) {
            this.schemaLocationsMap.put(targetNS, tmpFile.toURL());
        } else {
            log.trace((Object)("Schema element without target namespace in: " + wsdlLoc));
        }
        this.handleSchemaImports(schemaEl, wsdlLoc);
    }

    private void handleSchemaImports(Element schemaEl, URL parentURL) throws WSDLException, IOException {
        if (parentURL == null) {
            throw NativeMessages.MESSAGES.cannotProcessImportParentLocationSetToNull();
        }
        Iterator it = DOMUtils.getChildElements((Node)schemaEl, (QName)new QName("http://www.w3.org/2001/XMLSchema", "import"));
        while (it.hasNext()) {
            Element includeEl = (Element)it.next();
            String schemaLocation = this.getOptionalAttribute(includeEl, "schemaLocation");
            String namespace = this.getOptionalAttribute(includeEl, "namespace");
            log.trace((Object)("handleSchemaImport: [namespace=" + namespace + ",schemaLocation=" + schemaLocation + "]"));
            if (namespace != null && schemaLocation != null) {
                URL currLoc = this.getLocationURL(parentURL, schemaLocation);
                if (this.schemaLocationsMap.get(namespace) != null) continue;
                this.schemaLocationsMap.put(namespace, currLoc);
                Element importedSchema = null;
                WSDL11Reader wSDL11Reader = this;
                if (wSDL11Reader.entityResolver.getEntityMap().containsKey(namespace)) {
                    try {
                        importedSchema = DOMUtils.parse((InputStream)this.entityResolver.resolveEntity(namespace, namespace).getByteStream());
                    }
                    catch (SAXException se) {
                        log.error((Object)"", (Throwable)se);
                    }
                }
                if (importedSchema == null) {
                    importedSchema = DOMUtils.parse((InputStream)currLoc.openStream());
                }
                this.handleSchemaImports(importedSchema, currLoc);
                continue;
            }
            log.trace((Object)("Skip schema import: [namespace=" + namespace + ",schemaLocation=" + schemaLocation + "]"));
        }
    }

    private URL getLocationURL(URL parentURL, String location) throws MalformedURLException, WSDLException {
        log.trace((Object)("getLocationURL: [location=" + location + ",parent=" + parentURL + "]"));
        URL locationURL = null;
        try {
            locationURL = new URL(location);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (locationURL == null) {
            if (location.startsWith("/")) {
                location = location.substring(1);
            }
            String path = parentURL.toExternalForm();
            path = path.substring(0, path.lastIndexOf("/"));
            while (location.startsWith("../")) {
                path = path.substring(0, path.lastIndexOf("/"));
                location = location.substring(3);
            }
            locationURL = new URL(path + "/" + location);
        }
        log.trace((Object)("Modified schemaLocation: " + locationURL));
        return locationURL;
    }

    private void processPortType(Definition srcWsdl, PortType srcPortType, WSDLBinding destBinding) throws WSDLException {
        log.trace((Object)("processPortType: " + srcPortType.getQName()));
        QName qname = srcPortType.getQName();
        if (this.destWsdl.getInterface(qname) == null) {
            WSDLInterface destInterface = new WSDLInterface(this.destWsdl, qname);
            this.destWsdl.addInterface(destInterface);
            this.processPortTypeOperations(srcWsdl, destInterface, srcPortType, destBinding);
        }
    }

    private void processPortTypeOperations(Definition srcWsdl, WSDLInterface destInterface, PortType srcPortType, WSDLBinding destBinding) throws WSDLException {
        for (Operation srcOperation : srcPortType.getOperations()) {
            WSDLInterfaceOperation destOperation = new WSDLInterfaceOperation(destInterface, srcOperation.getName());
            this.processUnknownExtensibilityElements((ElementExtensible)srcOperation, destOperation);
            destOperation.setStyle(this.getOperationStyle(srcWsdl, srcPortType, srcOperation));
            if (srcOperation.getStyle() != null && !OperationType.NOTIFICATION.equals(srcOperation.getStyle())) {
                this.processPortTypeOperationInput(srcWsdl, srcOperation, destOperation, srcPortType, destBinding);
            }
            this.processPortTypeOperationOutput(srcWsdl, srcOperation, destOperation, srcPortType, destBinding);
            this.processPortTypeOperationFaults(srcOperation, destOperation, destInterface, destBinding);
            Element documentationElement = srcOperation.getDocumentationElement();
            if (documentationElement != null && documentationElement.getTextContent() != null) {
                destOperation.setDocumentationElement(new WSDLDocumentation(documentationElement.getTextContent()));
            }
            destInterface.addOperation(destOperation);
        }
    }

    private void processPortTypeOperationInput(Definition srcWsdl, Operation wsdlOperation, WSDLInterfaceOperation umdmOperation, PortType wsdlPortType, WSDLBinding umdmBinding) throws WSDLException {
        Input wsdlOperationInput = wsdlOperation.getInput();
        if (wsdlOperationInput != null) {
            Message srcMessage = wsdlOperationInput.getMessage();
            if (srcMessage == null) {
                throw new WSDLException("INVALID_WSDL", "Cannot find input message on operation " + wsdlOperation.getName() + " on port type: " + wsdlPortType.getQName());
            }
            log.trace((Object)("processOperationInput: " + srcMessage.getQName()));
            List paramOrder = wsdlOperation.getParameterOrdering();
            if (paramOrder != null) {
                for (String name : paramOrder) {
                    if (srcMessage.getPart(name) == null) continue;
                    umdmOperation.addRpcSignatureItem(new WSDLRPCSignatureItem(name));
                }
            }
            WSDLInterfaceOperationInput rpcInput = new WSDLInterfaceOperationInput(umdmOperation);
            for (Part srcPart : srcMessage.getOrderedParts(paramOrder)) {
                if (this.ignorePart(wsdlPortType, srcPart)) continue;
                if ("http://www.w3.org/2004/03/wsdl/style/iri" == umdmOperation.getStyle()) {
                    WSDLInterfaceOperationInput destInput = new WSDLInterfaceOperationInput(umdmOperation);
                    QName elementName = this.messagePartToElementName(srcMessage, srcPart, umdmOperation, umdmBinding);
                    destInput.setElement(elementName);
                    destInput.setMessageName(srcMessage.getQName());
                    umdmOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/in", wsdlOperationInput.getName()));
                    destInput.setPartName(srcPart.getName());
                    this.processUnknownExtensibilityElements((ElementExtensible)srcMessage, destInput);
                    umdmOperation.addInput(destInput);
                    continue;
                }
                QName xmlType = srcPart.getTypeName();
                if (xmlType != null) {
                    rpcInput.addChildPart(new WSDLRPCPart(srcPart.getName(), this.destWsdl.registerQName(xmlType)));
                    continue;
                }
                this.messagePartToElementName(srcMessage, srcPart, umdmOperation, umdmBinding);
            }
            if ("http://www.w3.org/2004/03/wsdl/style/rpc" == umdmOperation.getStyle()) {
                rpcInput.setElement(umdmOperation.getName());
                rpcInput.setMessageName(srcMessage.getQName());
                this.processUnknownExtensibilityElements((ElementExtensible)srcMessage, rpcInput);
                umdmOperation.addInput(rpcInput);
            }
        }
    }

    private boolean ignorePart(PortType srcPortType, Part srcPart) {
        boolean canBeSkipped = false;
        QName parentName = srcPortType.getQName();
        if (this.skippedSWAParts.containsKey(parentName) && this.skippedSWAParts.get(parentName).contains(srcPart.getName())) {
            log.trace((Object)("Skip attachment part: " + parentName + "->" + srcPart.getName()));
            canBeSkipped = true;
        }
        return canBeSkipped;
    }

    private void processPortTypeOperationOutput(Definition srcWsdl, Operation wsdlOperation, WSDLInterfaceOperation umdmOperation, PortType wsdlPortType, WSDLBinding umdmBinding) throws WSDLException {
        Output wsdlOperationOutput = wsdlOperation.getOutput();
        if (wsdlOperationOutput == null) {
            umdmOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-only");
            return;
        }
        Message wsdlMessage = wsdlOperationOutput.getMessage();
        if (wsdlMessage == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot find output message on operation " + wsdlOperation.getName() + " on port type: " + wsdlPortType.getQName());
        }
        log.trace((Object)("processOperationOutput: " + wsdlMessage.getQName()));
        umdmOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-out");
        List paramOrder = wsdlOperation.getParameterOrdering();
        if (paramOrder != null) {
            for (Object name : paramOrder) {
                if (wsdlMessage.getPart((String)name) == null) continue;
                WSDLRPCSignatureItem item = umdmOperation.getRpcSignatureitem((String)name);
                if (item != null) {
                    item.setDirection(WSDLRPCSignatureItem.Direction.INOUT);
                    continue;
                }
                umdmOperation.addRpcSignatureItem(new WSDLRPCSignatureItem((String)name, WSDLRPCSignatureItem.Direction.OUT));
            }
        }
        WSDLInterfaceOperationOutput umdmOperationOutput = new WSDLInterfaceOperationOutput(umdmOperation);
        for (Part srcPart : wsdlMessage.getOrderedParts(null)) {
            if (this.ignorePart(wsdlPortType, srcPart)) continue;
            if ("http://www.w3.org/2004/03/wsdl/style/iri" == umdmOperation.getStyle()) {
                WSDLInterfaceOperationOutput destOutput = new WSDLInterfaceOperationOutput(umdmOperation);
                QName elementName = this.messagePartToElementName(wsdlMessage, srcPart, umdmOperation, umdmBinding);
                destOutput.setElement(elementName);
                destOutput.setMessageName(wsdlMessage.getQName());
                umdmOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/out", wsdlOperationOutput.getName()));
                destOutput.setPartName(srcPart.getName());
                umdmOperation.addOutput(destOutput);
                continue;
            }
            QName xmlType = srcPart.getTypeName();
            if (xmlType != null) {
                umdmOperationOutput.addChildPart(new WSDLRPCPart(srcPart.getName(), this.destWsdl.registerQName(xmlType)));
                continue;
            }
            this.messagePartToElementName(wsdlMessage, srcPart, umdmOperation, umdmBinding);
        }
        if ("http://www.w3.org/2004/03/wsdl/style/rpc" == umdmOperation.getStyle()) {
            Object name;
            name = umdmOperation.getName();
            umdmOperationOutput.setElement(new QName(((QName)name).getNamespaceURI(), ((QName)name).getLocalPart() + "Response"));
            umdmOperationOutput.setMessageName(wsdlMessage.getQName());
            umdmOperation.addOutput(umdmOperationOutput);
        }
    }

    private void processPortTypeOperationFaults(Operation srcOperation, WSDLInterfaceOperation destOperation, WSDLInterface destInterface, WSDLBinding destBinding) throws WSDLException {
        Map faults = srcOperation.getFaults();
        for (Fault srcFault : faults.values()) {
            this.processOperationFault(destOperation, destInterface, srcFault);
        }
    }

    private void processOperationFault(WSDLInterfaceOperation umdmOperation, WSDLInterface umdmInterface, Fault wsdlFault) throws WSDLException {
        String faultName = wsdlFault.getName();
        log.trace((Object)("processOperationFault: " + faultName));
        WSDLInterfaceFault umdmFault = new WSDLInterfaceFault(umdmInterface, faultName);
        Message wsdlMessage = wsdlFault.getMessage();
        QName messageName = wsdlMessage.getQName();
        WSDLInterfaceOperationOutfault opOutFault = new WSDLInterfaceOperationOutfault(umdmOperation);
        opOutFault.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/fault", faultName));
        Map partsMap = wsdlMessage.getParts();
        if (partsMap.size() != 1) {
            throw new WSDLException("INVALID_WSDL", "Unsupported number of fault parts in message " + messageName);
        }
        Part part = (Part)partsMap.values().iterator().next();
        QName xmlName = part.getElementName();
        if (xmlName != null) {
            umdmFault.setElement(xmlName);
        } else {
            umdmFault.setElement(messageName);
            NativeLoggers.ROOT_LOGGER.unsupportedFaultMessagePartInMessage(messageName);
        }
        umdmInterface.addFault(umdmFault);
        opOutFault.setRef(umdmFault.getName());
        umdmOperation.addOutfault(opOutFault);
    }

    private QName messagePartToElementName(Message srcMessage, Part srcPart, WSDLInterfaceOperation destOperation, WSDLBinding destBinding) throws WSDLException {
        QName xmlName = null;
        if (srcPart.getTypeName() != null && srcPart.getElementName() != null) {
            throw new WSDLException("INVALID_WSDL", "Message parts must not define an element name and type name: " + srcMessage.getQName());
        }
        String bindingType = destBinding.getType();
        if ("http://schemas.xmlsoap.org/wsdl/http/".equals(bindingType)) {
            xmlName = new QName(srcPart.getName());
        }
        String style = destOperation.getStyle();
        if (xmlName == null && "http://www.w3.org/2004/03/wsdl/style/rpc".equals(style)) {
            if (srcPart.getName() == null) {
                throw new WSDLException("INVALID_WSDL", "RPC style message parts must define a typy name: " + srcMessage.getQName());
            }
            xmlName = srcPart.getElementName();
            if (xmlName == null) {
                xmlName = new QName(srcPart.getName());
            }
        }
        if (xmlName == null && "http://www.w3.org/2004/03/wsdl/style/iri".equals(style)) {
            if (srcPart.getElementName() == null) {
                throw new WSDLException("INVALID_WSDL", "Document style message parts must define an element name: " + srcMessage.getQName());
            }
            xmlName = srcPart.getElementName();
        }
        if (xmlName == null) {
            throw NativeMessages.MESSAGES.cannotFindNameForWSDLPart(srcPart);
        }
        xmlName = this.destWsdl.registerQName(xmlName);
        String key = srcMessage.getQName() + "->" + srcPart.getName();
        this.messagePartToElementMap.put(key, xmlName);
        return xmlName;
    }

    private BindingOperation getBindingOperation(Definition srcWsdl, PortType srcPortType, Operation srcOperation) throws WSDLException {
        Binding srcBinding = this.getPortTypeBindings(srcWsdl).get(srcPortType.getQName());
        if (srcBinding == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot find binding for: " + srcPortType.getQName());
        }
        String srcOperationName = srcOperation.getName();
        BindingOperation srcBindingOperation = srcBinding.getBindingOperation(srcOperationName, null, null);
        if (srcBindingOperation == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot find binding operation for: " + srcOperationName);
        }
        return srcBindingOperation;
    }

    private String getOperationStyle(Definition srcWsdl, PortType srcPortType, Operation srcOperation) throws WSDLException {
        QName elementType;
        Binding srcBinding = this.getPortTypeBindings(srcWsdl).get(srcPortType.getQName());
        BindingOperation srcBindingOperation = this.getBindingOperation(srcWsdl, srcPortType, srcOperation);
        String operationStyle = null;
        List extList = srcBindingOperation.getExtensibilityElements();
        for (ExtensibilityElement extElement : extList) {
            SOAPOperation soapOp;
            elementType = extElement.getElementType();
            if (extElement instanceof SOAPOperation) {
                soapOp = (SOAPOperation)extElement;
                operationStyle = soapOp.getStyle();
                continue;
            }
            if (!(extElement instanceof SOAP12Operation)) continue;
            soapOp = (SOAP12Operation)extElement;
            operationStyle = soapOp.getStyle();
        }
        if (operationStyle == null) {
            for (ExtensibilityElement extElement : srcBinding.getExtensibilityElements()) {
                SOAPBinding soapBinding;
                elementType = extElement.getElementType();
                if (extElement instanceof SOAPBinding) {
                    soapBinding = (SOAPBinding)extElement;
                    operationStyle = soapBinding.getStyle();
                    continue;
                }
                if (!(extElement instanceof SOAP12Binding)) continue;
                soapBinding = (SOAP12Binding)extElement;
                operationStyle = soapBinding.getStyle();
            }
        }
        return "rpc".equals(operationStyle) ? "http://www.w3.org/2004/03/wsdl/style/rpc" : "http://www.w3.org/2004/03/wsdl/style/iri";
    }

    private WSDLBinding processBinding(Definition srcWsdl, Binding srcBinding) throws WSDLException {
        QName srcBindingQName = srcBinding.getQName();
        log.trace((Object)("processBinding: " + srcBindingQName));
        WSDLBinding destBinding = this.destWsdl.getBinding(srcBindingQName);
        if (destBinding == null) {
            PortType srcPortType = this.getDefinedPortType(srcBinding);
            String bindingType = null;
            List extList = srcBinding.getExtensibilityElements();
            for (ExtensibilityElement extElement : extList) {
                QName elementType = extElement.getElementType();
                if (extElement instanceof SOAPBinding) {
                    bindingType = "http://schemas.xmlsoap.org/wsdl/soap/";
                    continue;
                }
                if (extElement instanceof SOAP12Binding) {
                    bindingType = "http://schemas.xmlsoap.org/wsdl/soap12/";
                    continue;
                }
                if (extElement instanceof HTTPBinding) {
                    bindingType = "http://schemas.xmlsoap.org/wsdl/http/";
                    continue;
                }
                if (!"binding".equals(elementType.getLocalPart())) continue;
                NativeLoggers.ROOT_LOGGER.unsupportedBinding(elementType);
                bindingType = elementType.getNamespaceURI();
            }
            if (bindingType == null) {
                throw new WSDLException("INVALID_WSDL", "Cannot obtain binding type for: " + srcBindingQName);
            }
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType) || "http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType) || "http://schemas.xmlsoap.org/wsdl/http/".equals(bindingType)) {
                destBinding = new WSDLBinding(this.destWsdl, srcBindingQName);
                destBinding.setInterfaceName(srcPortType.getQName());
                destBinding.setType(bindingType);
                this.processUnknownExtensibilityElements((ElementExtensible)srcBinding, destBinding);
                this.destWsdl.addBinding(destBinding);
                this.preProcessSWAParts(srcBinding, srcWsdl);
                this.processPortType(srcWsdl, srcPortType, destBinding);
                String bindingStyle = Style.getDefaultStyle().toString();
                for (ExtensibilityElement extElement : extList) {
                    SOAPBinding soapBinding;
                    if (extElement instanceof SOAPBinding) {
                        soapBinding = (SOAPBinding)extElement;
                        bindingStyle = soapBinding.getStyle();
                        continue;
                    }
                    if (!(extElement instanceof SOAP12Binding)) continue;
                    soapBinding = (SOAP12Binding)extElement;
                    bindingStyle = soapBinding.getStyle();
                }
                this.processBindingOperations(srcWsdl, destBinding, srcBinding, bindingStyle);
            }
        }
        return destBinding;
    }

    private Binding getDefinedBinding(Port srcPort) throws WSDLException {
        Binding srcBinding = srcPort.getBinding();
        if (srcBinding == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot find binding for port: " + srcPort.getName());
        }
        QName srcBindingName = srcBinding.getQName();
        if (srcBinding.isUndefined()) {
            String nsURI = srcBindingName.getNamespaceURI();
            List<Binding> bindings = this.bindingsByNamespace.get(nsURI);
            if (bindings == null) {
                throw new WSDLException("INVALID_WSDL", "Cannot find bindings for namespace: " + nsURI);
            }
            for (Binding auxBinding : bindings) {
                if (!srcBindingName.equals(auxBinding.getQName())) continue;
                srcBinding = auxBinding;
                break;
            }
        }
        return srcBinding;
    }

    private PortType getDefinedPortType(Binding srcBinding) throws WSDLException {
        QName srcBindingQName = srcBinding.getQName();
        PortType srcPortType = srcBinding.getPortType();
        if (srcPortType == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot find port type for binding: " + srcBindingQName);
        }
        QName srcPortTypeName = srcPortType.getQName();
        if (srcPortType.isUndefined()) {
            String nsURI = srcPortTypeName.getNamespaceURI();
            List<PortType> portTypes = this.portTypesByNamespace.get(nsURI);
            if (portTypes == null) {
                throw new WSDLException("INVALID_WSDL", "Cannot find port types for namespace: " + nsURI);
            }
            for (PortType auxPortType : portTypes) {
                if (!srcPortTypeName.equals(auxPortType.getQName())) continue;
                srcPortType = auxPortType;
                break;
            }
        }
        return srcPortType;
    }

    private void preProcessSWAParts(Binding srcBinding, Definition srcWsdl) throws WSDLException {
        for (BindingOperation bindingOperation : srcBinding.getBindingOperations()) {
            if (bindingOperation.getBindingInput() != null) {
                this.markSWAParts(bindingOperation.getBindingInput().getExtensibilityElements(), srcBinding, srcWsdl);
            }
            if (bindingOperation.getBindingOutput() == null) continue;
            this.markSWAParts(bindingOperation.getBindingOutput().getExtensibilityElements(), srcBinding, srcWsdl);
        }
    }

    private void markSWAParts(List extensions, Binding srcBinding, Definition srcWsdl) throws WSDLException {
        for (Object o : extensions) {
            if (!(o instanceof MIMEMultipartRelated)) continue;
            QName portTypeName = this.getDefinedPortType(srcBinding).getQName();
            if (log.isTraceEnabled()) {
                log.trace((Object)("SWA found on portType" + portTypeName));
            }
            MIMEMultipartRelated mrel = (MIMEMultipartRelated)o;
            for (MIMEPart mimePartDesc : mrel.getMIMEParts()) {
                List mimePartExt = mimePartDesc.getExtensibilityElements();
                if (mimePartExt.isEmpty() || !(mimePartExt.get(0) instanceof MIMEContent)) continue;
                MIMEContent mimeContent = (MIMEContent)mimePartExt.get(0);
                if (this.skippedSWAParts.get(portTypeName) == null) {
                    this.skippedSWAParts.put(portTypeName, new ArrayList());
                }
                this.skippedSWAParts.get(portTypeName).add(mimeContent.getPart());
            }
        }
    }

    private Map<QName, Binding> getPortTypeBindings(Definition srcWsdl) throws WSDLException {
        this.getAllDefinedBindings(srcWsdl);
        return this.portTypeBindings;
    }

    private Map<QName, Binding> getAllDefinedBindings(Definition srcWsdl) throws WSDLException {
        if (this.allBindings != null) {
            return this.allBindings;
        }
        this.allBindings = new LinkedHashMap();
        this.portTypeBindings = new LinkedHashMap();
        Map srcBindings = srcWsdl.getBindings();
        for (Binding srcBinding : srcBindings.values()) {
            this.allBindings.put(srcBinding.getQName(), srcBinding);
            this.portTypeBindings.put(this.getDefinedPortType(srcBinding).getQName(), srcBinding);
        }
        for (Service srcService : srcWsdl.getServices().values()) {
            for (Port srcPort : srcService.getPorts().values()) {
                Binding srcBinding = srcPort.getBinding();
                this.allBindings.put(srcBinding.getQName(), srcBinding);
                this.portTypeBindings.put(this.getDefinedPortType(srcBinding).getQName(), srcBinding);
            }
        }
        return this.allBindings;
    }

    private void processBindingOperations(Definition srcWsdl, WSDLBinding destBinding, Binding srcBinding, String bindingStyle) throws WSDLException {
        for (BindingOperation srcBindingOperation : srcBinding.getBindingOperations()) {
            this.processBindingOperation(srcWsdl, destBinding, bindingStyle, srcBindingOperation);
        }
    }

    private void processBindingOperation(Definition srcWsdl, WSDLBinding destBinding, String bindingStyle, BindingOperation srcBindingOperation) throws WSDLException {
        BindingOutput srcBindingOutput;
        String srcOperationName = srcBindingOperation.getName();
        log.trace((Object)("processBindingOperation: " + srcOperationName));
        WSDLInterface destInterface = destBinding.getInterface();
        String namespaceURI = destInterface.getName().getNamespaceURI();
        WSDLBindingOperation destBindingOperation = new WSDLBindingOperation(destBinding);
        QName refQName = new QName(namespaceURI, srcOperationName);
        destBindingOperation.setRef(refQName);
        this.processUnknownExtensibilityElements((ElementExtensible)srcBindingOperation, destBindingOperation);
        destBinding.addOperation(destBindingOperation);
        String opName = srcOperationName;
        WSDLInterfaceOperation destIntfOperation = destInterface.getOperation(opName);
        List extList = srcBindingOperation.getExtensibilityElements();
        for (ExtensibilityElement extElement : extList) {
            SOAPOperation soapOp;
            if (extElement instanceof SOAPOperation) {
                soapOp = (SOAPOperation)extElement;
                destBindingOperation.setSOAPAction(soapOp.getSoapActionURI());
                continue;
            }
            if (!(extElement instanceof SOAP12Operation)) continue;
            soapOp = (SOAP12Operation)extElement;
            destBindingOperation.setSOAPAction(soapOp.getSoapActionURI());
        }
        BindingInput srcBindingInput = srcBindingOperation.getBindingInput();
        if (srcBindingInput != null) {
            this.processBindingInput(srcWsdl, destBindingOperation, destIntfOperation, srcBindingOperation, srcBindingInput);
        }
        if ((srcBindingOutput = srcBindingOperation.getBindingOutput()) != null) {
            this.processBindingOutput(srcWsdl, destBindingOperation, destIntfOperation, srcBindingOperation, srcBindingOutput);
        }
    }

    private void processBindingInput(Definition srcWsdl, WSDLBindingOperation destBindingOperation, final WSDLInterfaceOperation destIntfOperation, final BindingOperation srcBindingOperation, BindingInput srcBindingInput) throws WSDLException {
        log.trace((Object)"processBindingInput");
        List extList = srcBindingInput.getExtensibilityElements();
        WSDLBindingOperationInput input = new WSDLBindingOperationInput(destBindingOperation);
        this.processUnknownExtensibilityElements((ElementExtensible)srcBindingInput, input);
        destBindingOperation.addInput(input);
        ReferenceCallback cb = new ReferenceCallback(){

            @Override
            public QName getXmlType(String partName) {
                return srcBindingOperation.getOperation().getInput().getMessage().getPart(partName).getTypeName();
            }

            @Override
            public void removeReference(QName element) {
                WSDLInterfaceOperationInput destIntfInput = destIntfOperation.getInput(element);
                if (destIntfInput != null) {
                    destIntfOperation.removeInput(element);
                }
            }

            @Override
            public void removeRPCPart(String partName) {
                WSDLInterfaceOperationInput operationInput = destIntfOperation.getInput(destIntfOperation.getName());
                operationInput.removeChildPart(partName);
            }
        };
        this.processBindingReference(srcWsdl, destBindingOperation, destIntfOperation, extList, input, srcBindingOperation, cb);
    }

    private void processBindingOutput(Definition srcWsdl, WSDLBindingOperation destBindingOperation, final WSDLInterfaceOperation destIntfOperation, final BindingOperation srcBindingOperation, BindingOutput srcBindingOutput) throws WSDLException {
        log.trace((Object)"processBindingInput");
        List extList = srcBindingOutput.getExtensibilityElements();
        WSDLBindingOperationOutput output = new WSDLBindingOperationOutput(destBindingOperation);
        destBindingOperation.addOutput(output);
        ReferenceCallback cb = new ReferenceCallback(){

            @Override
            public QName getXmlType(String partName) {
                return srcBindingOperation.getOperation().getOutput().getMessage().getPart(partName).getTypeName();
            }

            @Override
            public void removeReference(QName element) {
                WSDLInterfaceOperationOutput destIntfOutput = destIntfOperation.getOutput(element);
                if (destIntfOutput != null) {
                    destIntfOperation.removeOutput(element);
                }
            }

            @Override
            public void removeRPCPart(String partName) {
                QName name = destIntfOperation.getName();
                WSDLInterfaceOperationOutput operationOutput = destIntfOperation.getOutput(new QName(name.getNamespaceURI(), name.getLocalPart() + "Response"));
                operationOutput.removeChildPart(partName);
            }
        };
        this.processBindingReference(srcWsdl, destBindingOperation, destIntfOperation, extList, output, srcBindingOperation, cb);
    }

    private void processBindingReference(Definition srcWsdl, WSDLBindingOperation destBindingOperation, WSDLInterfaceOperation destIntfOperation, List<ExtensibilityElement> extList, WSDLBindingMessageReference reference, BindingOperation srcBindingOperation, ReferenceCallback callback) throws WSDLException {
        for (ExtensibilityElement extElement : extList) {
            String namespaceURI;
            SOAPBody body;
            if (extElement instanceof SOAPBody) {
                body = (SOAPBody)extElement;
                this.processEncodingStyle((ExtensibilityElement)body, destBindingOperation);
                namespaceURI = body.getNamespaceURI();
                destBindingOperation.setNamespaceURI(namespaceURI);
                continue;
            }
            if (extElement instanceof SOAP12Body) {
                body = (SOAP12Body)extElement;
                this.processEncodingStyle((ExtensibilityElement)body, destBindingOperation);
                namespaceURI = body.getNamespaceURI();
                destBindingOperation.setNamespaceURI(namespaceURI);
                continue;
            }
            if (extElement instanceof SOAPHeader) {
                SOAPHeader header = (SOAPHeader)extElement;
                QName headerMessageName = header.getMessage();
                String headerPartName = header.getPart();
                String key = headerMessageName + "->" + headerPartName;
                QName elementName = this.messagePartToElementMap.get(key);
                boolean isImplicitHeader = false;
                Message srcMessage = srcWsdl.getMessage(headerMessageName);
                if (elementName == null && srcMessage != null) {
                    for (Part srcPart : srcMessage.getParts().values()) {
                        String partName = srcPart.getName();
                        if (!partName.equals(headerPartName)) continue;
                        isImplicitHeader = true;
                        elementName = srcPart.getElementName();
                    }
                }
                if (elementName == null) {
                    throw new WSDLException("INVALID_WSDL", "Could not determine element name from header: " + key);
                }
                WSDLSOAPHeader soapHeader = new WSDLSOAPHeader(elementName, headerPartName);
                soapHeader.setIncludeInSignature(!isImplicitHeader);
                reference.addSoapHeader(soapHeader);
                if ("http://www.w3.org/2004/03/wsdl/style/iri" == destIntfOperation.getStyle()) {
                    callback.removeReference(elementName);
                    continue;
                }
                callback.removeRPCPart(headerPartName);
                continue;
            }
            if (!(extElement instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated related = (MIMEMultipartRelated)extElement;
            for (MIMEPart part : related.getMIMEParts()) {
                Iterator j = part.getExtensibilityElements().iterator();
                String name = null;
                String types = null;
                while (j.hasNext()) {
                    ExtensibilityElement inner = (ExtensibilityElement)j.next();
                    if (!(inner instanceof MIMEContent)) continue;
                    MIMEContent content = (MIMEContent)inner;
                    name = content.getPart();
                    if (types == null) {
                        types = content.getType();
                        continue;
                    }
                    types = types + "," + content.getType();
                }
                if (name == null) continue;
                QName xmlType = callback.getXmlType(name);
                reference.addMimePart(new WSDLMIMEPart(name, xmlType, types));
                if ("http://www.w3.org/2004/03/wsdl/style/iri" == destIntfOperation.getStyle()) {
                    callback.removeReference(new QName(name));
                    continue;
                }
                callback.removeRPCPart(name);
            }
        }
    }

    private void processEncodingStyle(ExtensibilityElement extElement, WSDLBindingOperation destBindingOperation) {
        SOAPBody body;
        log.trace((Object)"processEncodingStyle");
        String encStyle = null;
        if (extElement instanceof SOAPBody) {
            body = (SOAPBody)extElement;
            List encStyleList = body.getEncodingStyles();
            if (encStyleList != null) {
                if (encStyleList.size() > 1) {
                    NativeLoggers.ROOT_LOGGER.multipleEncodingStyleNotSupported(encStyleList);
                }
                if (encStyleList.size() > 0) {
                    encStyle = (String)encStyleList.get(0);
                }
            }
        } else if (extElement instanceof SOAP12Body) {
            body = (SOAP12Body)extElement;
            encStyle = body.getEncodingStyle();
        }
        if (encStyle != null) {
            String setStyle = destBindingOperation.getEncodingStyle();
            if (!encStyle.equals(setStyle)) {
                NativeLoggers.ROOT_LOGGER.encodingStyleNotSupported(encStyle, destBindingOperation.getRef());
            }
            destBindingOperation.setEncodingStyle(encStyle);
        }
    }

    private void processServices(Definition srcWsdl) throws WSDLException {
        log.trace((Object)("BEGIN processServices: " + srcWsdl.getDocumentBaseURI()));
        this.allBindings = null;
        if (srcWsdl.getServices().size() > 0) {
            for (Service srcService : srcWsdl.getServices().values()) {
                QName qname = srcService.getQName();
                WSDLService destService = new WSDLService(this.destWsdl, qname);
                this.processUnknownExtensibilityElements((ElementExtensible)srcService, destService);
                this.destWsdl.addService(destService);
                this.processPorts(srcWsdl, destService, srcService);
            }
        } else {
            log.trace((Object)"Empty wsdl services, processing imports");
            for (List srcImports : srcWsdl.getImports().values()) {
                for (Import srcImport : srcImports) {
                    Definition importDefinition = srcImport.getDefinition();
                    this.processServices(importDefinition);
                }
            }
            this.allBindings = null;
        }
        log.trace((Object)("END processServices: " + srcWsdl.getDocumentBaseURI()));
    }

    private void processPorts(Definition srcWsdl, WSDLService destService, Service srcService) throws WSDLException {
        for (Port srcPort : srcService.getPorts().values()) {
            this.processPort(srcWsdl, destService, srcPort);
        }
    }

    private void processPort(Definition srcWsdl, WSDLService destService, Port srcPort) throws WSDLException {
        log.trace((Object)("processPort: " + srcPort.getName()));
        Binding srcBinding = this.getDefinedBinding(srcPort);
        QName endpointName = new QName(srcWsdl.getTargetNamespace(), srcPort.getName());
        WSDLEndpoint destEndpoint = new WSDLEndpoint(destService, endpointName);
        destEndpoint.setBinding(srcBinding.getQName());
        destEndpoint.setAddress(this.getSOAPAddress(srcPort));
        this.processUnknownExtensibilityElements((ElementExtensible)srcPort, destEndpoint);
        WSDLBinding destBinding = this.processBinding(srcWsdl, srcBinding);
        if (destBinding != null) {
            destService.addEndpoint(destEndpoint);
        }
    }

    private String getSOAPAddress(Port srcPort) throws WSDLException {
        String soapAddress = "dummy";
        for (ExtensibilityElement extElement : srcPort.getExtensibilityElements()) {
            QName elementType = extElement.getElementType();
            if (extElement instanceof SOAPAddress) {
                SOAPAddress addr = (SOAPAddress)extElement;
                soapAddress = addr.getLocationURI();
                break;
            }
            if (extElement instanceof SOAP12Address) {
                SOAP12Address addr = (SOAP12Address)extElement;
                soapAddress = addr.getLocationURI();
                break;
            }
            if (!"address".equals(elementType.getLocalPart())) continue;
            NativeLoggers.ROOT_LOGGER.unprocessedWSDLExtensionElement(elementType);
        }
        if (soapAddress == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot obtain SOAP address");
        }
        return soapAddress;
    }

    private String getOptionalAttribute(Element domElement, String attrName) {
        String attrValue = domElement.getAttribute(attrName);
        return attrValue.length() > 0 ? attrValue : null;
    }

    static interface ReferenceCallback {
        public void removeReference(QName var1);

        public void removeRPCPart(String var1);

        public QName getXmlType(String var1);
    }
}

