/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.VInt8IntDecoder;

public class EightFlagsIntDecoder
extends IntDecoder {
    private static final byte[][] decodeTable = new byte[256][8];
    private final IntDecoder decoder = new VInt8IntDecoder();
    private int indicator;
    private int ordinal = 0;

    @Override
    public long decode() throws IOException {
        if ((this.ordinal & 7) == 0) {
            this.indicator = this.in.read();
            if (this.indicator < 0) {
                return 0x100000000L;
            }
            this.ordinal = 0;
        }
        if (decodeTable[this.indicator][this.ordinal++] == 0) {
            long decode = this.decoder.decode();
            return decode == 0x100000000L ? 0x100000000L : decode + 2L;
        }
        return 1L;
    }

    @Override
    public void reInit(InputStream in) {
        super.reInit(in);
        this.decoder.reInit(in);
        this.ordinal = 0;
        this.indicator = 0;
    }

    public String toString() {
        return "EightFlags (VInt8)";
    }

    static {
        int i = 256;
        while (i != 0) {
            --i;
            int j = 8;
            while (j != 0) {
                EightFlagsIntDecoder.decodeTable[i][--j] = (byte)(i >>> j & 1);
            }
        }
    }
}

