/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.ScoredDocIDsIterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.FixedBitSet;

public abstract class ScoredDocIdCollector
extends Collector {
    protected int numDocIds = 0;
    protected int docBase;
    protected final FixedBitSet docIds;

    public static ScoredDocIdCollector create(int maxDoc, boolean enableScoring) {
        return enableScoring ? new ScoringDocIdCollector(maxDoc) : new NonScoringDocIdCollector(maxDoc);
    }

    private ScoredDocIdCollector(int maxDoc) {
        this.docIds = new FixedBitSet(maxDoc);
    }

    public abstract float getDefaultScore();

    public abstract void setDefaultScore(float var1);

    public abstract ScoredDocIDsIterator scoredDocIdsIterator() throws IOException;

    public ScoredDocIDs getScoredDocIDs() {
        return new ScoredDocIDs(){

            @Override
            public ScoredDocIDsIterator iterator() throws IOException {
                return ScoredDocIdCollector.this.scoredDocIdsIterator();
            }

            @Override
            public DocIdSet getDocIDs() {
                return ScoredDocIdCollector.this.docIds;
            }

            @Override
            public int size() {
                return ScoredDocIdCollector.this.numDocIds;
            }
        };
    }

    public void setNextReader(IndexReader reader, int base) throws IOException {
        this.docBase = base;
    }

    private static final class ScoringDocIdCollector
    extends ScoredDocIdCollector {
        float[] scores = new float[64];
        private Scorer scorer;

        public ScoringDocIdCollector(int maxDoc) {
            super(maxDoc);
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void collect(int doc) throws IOException {
            this.docIds.set(this.docBase + doc);
            float score = this.scorer.score();
            if (this.numDocIds >= this.scores.length) {
                float[] newScores = new float[ArrayUtil.oversize((int)(this.numDocIds + 1), (int)4)];
                System.arraycopy(this.scores, 0, newScores, 0, this.numDocIds);
                this.scores = newScores;
            }
            this.scores[this.numDocIds] = score;
            ++this.numDocIds;
        }

        @Override
        public ScoredDocIDsIterator scoredDocIdsIterator() throws IOException {
            return new ScoredDocIDsIterator(){
                private DocIdSetIterator docIdsIter;
                private int nextDoc;
                private int scoresIdx;
                {
                    this.docIdsIter = ScoringDocIdCollector.this.docIds.iterator();
                    this.scoresIdx = -1;
                }

                @Override
                public int getDocID() {
                    return this.nextDoc;
                }

                @Override
                public float getScore() {
                    return ScoringDocIdCollector.this.scores[this.scoresIdx];
                }

                @Override
                public boolean next() {
                    try {
                        this.nextDoc = this.docIdsIter.nextDoc();
                        if (this.nextDoc == Integer.MAX_VALUE) {
                            return false;
                        }
                        ++this.scoresIdx;
                        return true;
                    }
                    catch (IOException e) {
                        this.nextDoc = Integer.MAX_VALUE;
                        return false;
                    }
                }
            };
        }

        @Override
        public float getDefaultScore() {
            return 1.0f;
        }

        @Override
        public void setDefaultScore(float defaultScore) {
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }
    }

    private static final class NonScoringDocIdCollector
    extends ScoredDocIdCollector {
        float defaultScore = 1.0f;

        public NonScoringDocIdCollector(int maxDoc) {
            super(maxDoc);
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public void collect(int doc) throws IOException {
            this.docIds.set(this.docBase + doc);
            ++this.numDocIds;
        }

        @Override
        public float getDefaultScore() {
            return this.defaultScore;
        }

        @Override
        public ScoredDocIDsIterator scoredDocIdsIterator() throws IOException {
            return new ScoredDocIDsIterator(){
                private DocIdSetIterator docIdsIter;
                private int nextDoc;
                {
                    this.docIdsIter = NonScoringDocIdCollector.this.docIds.iterator();
                }

                @Override
                public int getDocID() {
                    return this.nextDoc;
                }

                @Override
                public float getScore() {
                    return NonScoringDocIdCollector.this.defaultScore;
                }

                @Override
                public boolean next() {
                    try {
                        this.nextDoc = this.docIdsIter.nextDoc();
                        return this.nextDoc != Integer.MAX_VALUE;
                    }
                    catch (IOException e) {
                        this.nextDoc = Integer.MAX_VALUE;
                        return false;
                    }
                }
            };
        }

        @Override
        public void setDefaultScore(float defaultScore) {
            this.defaultScore = defaultScore;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }
    }
}

