/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.merge;

import java.io.IOException;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.index.FacetsPayloadProcessorProvider;
import org.apache.lucene.facet.index.params.DefaultFacetIndexingParams;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.PayloadProcessorProvider;
import org.apache.lucene.store.Directory;

public class TaxonomyMergeUtils {
    public static void merge(Directory srcIndexDir, Directory srcTaxDir, Directory destIndexDir, Directory destTaxDir) throws IOException {
        IndexWriter destIndexWriter = new IndexWriter(destIndexDir, new IndexWriterConfig(ExampleUtils.EXAMPLE_VER, null));
        DirectoryTaxonomyWriter destTaxWriter = new DirectoryTaxonomyWriter(destTaxDir);
        TaxonomyMergeUtils.merge(srcIndexDir, srcTaxDir, new DirectoryTaxonomyWriter.MemoryOrdinalMap(), destIndexWriter, destTaxWriter);
        destTaxWriter.close();
        destIndexWriter.close();
    }

    public static void merge(Directory srcIndexDir, Directory srcTaxDir, IndexWriter destIndexWriter, DirectoryTaxonomyWriter destTaxWriter) throws IOException {
        TaxonomyMergeUtils.merge(srcIndexDir, srcTaxDir, new DirectoryTaxonomyWriter.MemoryOrdinalMap(), destIndexWriter, destTaxWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(Directory srcIndexDir, Directory srcTaxDir, DirectoryTaxonomyWriter.OrdinalMap map, IndexWriter destIndexWriter, DirectoryTaxonomyWriter destTaxWriter) throws IOException {
        destTaxWriter.addTaxonomy(srcTaxDir, map);
        FacetsPayloadProcessorProvider payloadProcessor = new FacetsPayloadProcessorProvider(srcIndexDir, map.getMap(), new DefaultFacetIndexingParams());
        destIndexWriter.setPayloadProcessorProvider((PayloadProcessorProvider)payloadProcessor);
        IndexReader reader = IndexReader.open((Directory)srcIndexDir);
        try {
            destIndexWriter.addIndexes(new IndexReader[]{reader});
            destTaxWriter.commit();
            destIndexWriter.commit();
        }
        finally {
            reader.close();
        }
    }
}

