/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.example.association;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.facet.enhancements.EnhancementsDocumentBuilder;
import org.apache.lucene.facet.enhancements.association.AssociationProperty;
import org.apache.lucene.facet.example.ExampleUtils;
import org.apache.lucene.facet.example.association.AssociationUtils;
import org.apache.lucene.facet.example.simple.SimpleUtils;
import org.apache.lucene.facet.index.CategoryContainer;
import org.apache.lucene.facet.index.attributes.CategoryProperty;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;

public class AssociationIndexer {
    public static void index(Directory indexDir, Directory taxoDir) throws Exception {
        IndexWriter iw = new IndexWriter(indexDir, new IndexWriterConfig(ExampleUtils.EXAMPLE_VER, SimpleUtils.analyzer));
        DirectoryTaxonomyWriter taxo = new DirectoryTaxonomyWriter(taxoDir, IndexWriterConfig.OpenMode.CREATE);
        int nDocsAdded = 0;
        int nFacetsAdded = 0;
        for (int docNum = 0; docNum < SimpleUtils.docTexts.length; ++docNum) {
            ExampleUtils.log(" ++++ DOC ID: " + docNum);
            CategoryContainer categoryContainer = new CategoryContainer();
            for (CategoryPath path : SimpleUtils.categories[docNum]) {
                categoryContainer.addCategory(path);
                ExampleUtils.log("\t ++++ PATH: " + path);
            }
            CategoryPath[] associationsPaths = AssociationUtils.categories[docNum];
            AssociationProperty[] associationProps = AssociationUtils.associations[docNum];
            for (int i = 0; i < associationsPaths.length; ++i) {
                categoryContainer.addCategory(associationsPaths[i], (CategoryProperty)associationProps[i]);
                ExampleUtils.log("\t $$$$ Association: (" + associationsPaths[i] + "," + associationProps[i] + ")");
            }
            EnhancementsDocumentBuilder categoryDocBuilder = new EnhancementsDocumentBuilder((TaxonomyWriter)taxo, AssociationUtils.assocIndexingParams);
            categoryDocBuilder.setCategories(categoryContainer);
            Document doc = new Document();
            doc.add((Fieldable)new Field("title", SimpleUtils.docTitles[docNum], Field.Store.YES, Field.Index.ANALYZED));
            doc.add((Fieldable)new Field("text", SimpleUtils.docTexts[docNum], Field.Store.NO, Field.Index.ANALYZED));
            categoryDocBuilder.build(doc);
            iw.addDocument(doc);
            ++nDocsAdded;
            nFacetsAdded += categoryContainer.size();
        }
        taxo.commit();
        iw.commit();
        taxo.close();
        iw.close();
        ExampleUtils.log("Indexed " + nDocsAdded + " documents with overall " + nFacetsAdded + " facets.");
    }
}

