/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;

public class ResponseAttachmentInputStreamSupport {
    private static final int STREAM_TIMEOUT = 30000;
    private static final int CLEANUP_INTERVAL = 10000;
    private final Map<InputStreamKey, TimedStreamEntry> streamMap = new ConcurrentHashMap<InputStreamKey, TimedStreamEntry>();
    private final ScheduledFuture<?> cleanupTaskFuture;
    private final int timeout;
    private volatile boolean stopped;

    public static void handleDomainOperationResponseStreams(OperationContext context, ModelNode responseNode, List<OperationResponse.StreamEntry> streams) {
        if (responseNode.hasDefined("response-headers")) {
            ModelNode responseHeaders = responseNode.get("response-headers");
            responseHeaders.remove("attached-streams");
            if (responseHeaders.asInt() == 0) {
                responseNode.remove("response-headers");
            }
        }
        for (OperationResponse.StreamEntry streamEntry : streams) {
            context.attachResultStream(streamEntry.getUUID(), streamEntry.getMimeType(), streamEntry.getStream());
        }
    }

    public ResponseAttachmentInputStreamSupport() {
        this(30000);
    }

    ResponseAttachmentInputStreamSupport(int streamTimeout) {
        this.timeout = streamTimeout;
        this.cleanupTaskFuture = null;
    }

    public ResponseAttachmentInputStreamSupport(ScheduledExecutorService scheduledExecutorService) {
        this(scheduledExecutorService, 30000, 10000);
    }

    ResponseAttachmentInputStreamSupport(ScheduledExecutorService scheduledExecutorService, int streamTimeout, int cleanupInterval) {
        this.timeout = streamTimeout;
        this.cleanupTaskFuture = scheduledExecutorService.scheduleWithFixedDelay(new CleanupTask(), cleanupInterval, cleanupInterval, TimeUnit.MILLISECONDS);
    }

    synchronized void registerStreams(int operationId, List<OperationResponse.StreamEntry> streams) {
        if (!this.stopped) {
            AtomicLong timestamp = new AtomicLong(System.currentTimeMillis());
            for (int i = 0; i < streams.size(); ++i) {
                OperationResponse.StreamEntry stream = streams.get(i);
                InputStreamKey key = new InputStreamKey(operationId, i);
                this.streamMap.put(key, new TimedStreamEntry(stream, timestamp));
            }
        } else {
            for (int i = 0; i < streams.size(); ++i) {
                ResponseAttachmentInputStreamSupport.closeStreamEntry((Closeable)streams.get(i), operationId, i);
            }
        }
    }

    ManagementRequestHandler<Void, Void> getReadHandler() {
        return new ReadHandler();
    }

    ManagementRequestHandler<Void, Void> getCloseHandler() {
        return new AbstractAttachmentHandler(){

            @Override
            void handleRequest(TimedStreamEntry entry, FlushableDataOutput output) throws IOException {
            }

            @Override
            void handleMissingStream(int requestId, int index, FlushableDataOutput output) throws IOException {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void shutdown() {
        this.stopped = true;
        if (this.cleanupTaskFuture != null) {
            this.cleanupTaskFuture.cancel(false);
        }
        for (Map.Entry<InputStreamKey, TimedStreamEntry> entry : this.streamMap.entrySet()) {
            TimedStreamEntry timedStreamEntry;
            InputStreamKey key = entry.getKey();
            TimedStreamEntry timedStreamEntry2 = timedStreamEntry = entry.getValue();
            synchronized (timedStreamEntry2) {
                ResponseAttachmentInputStreamSupport.closeStreamEntry(timedStreamEntry, key.requestId, key.index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gc() {
        if (this.stopped) {
            return;
        }
        long expirationTime = System.currentTimeMillis() - (long)this.timeout;
        Iterator<Map.Entry<InputStreamKey, TimedStreamEntry>> iter = this.streamMap.entrySet().iterator();
        while (iter.hasNext()) {
            if (this.stopped) {
                return;
            }
            Map.Entry<InputStreamKey, TimedStreamEntry> entry = iter.next();
            TimedStreamEntry timedStreamEntry = entry.getValue();
            if (timedStreamEntry.timestamp.get() > expirationTime) continue;
            iter.remove();
            InputStreamKey key = entry.getKey();
            TimedStreamEntry timedStreamEntry2 = timedStreamEntry;
            synchronized (timedStreamEntry2) {
                ResponseAttachmentInputStreamSupport.closeStreamEntry(timedStreamEntry, key.requestId, key.index);
            }
        }
    }

    private static void closeStreamEntry(Closeable closeable, int requestId, int streamIndex) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            ControllerLogger.ROOT_LOGGER.debugf(e, "Caught exception closing attached response stream at index %d for operation %d", streamIndex, requestId);
        }
    }

    private class CleanupTask
    implements Runnable {
        private CleanupTask() {
        }

        @Override
        public void run() {
            ResponseAttachmentInputStreamSupport.this.gc();
        }
    }

    private static class TimedStreamEntry
    implements Closeable {
        private final OperationResponse.StreamEntry streamEntry;
        private final AtomicLong timestamp;
        private boolean closed;

        private TimedStreamEntry(OperationResponse.StreamEntry streamEntry, AtomicLong timestamp) {
            this.streamEntry = streamEntry;
            this.timestamp = timestamp;
        }

        @Override
        public void close() throws IOException {
            this.streamEntry.close();
            this.closed = true;
        }
    }

    private class ReadHandler
    extends AbstractAttachmentHandler {
        private static final int BUFFER_SIZE = 8192;

        private ReadHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleRequest(TimedStreamEntry entry, FlushableDataOutput output) throws IOException {
            TimedStreamEntry timedStreamEntry = entry;
            synchronized (timedStreamEntry) {
                InputStream input = entry.streamEntry.getStream();
                int read = 0;
                byte[] buffer = new byte[8192];
                do {
                    entry.timestamp.set(System.currentTimeMillis());
                    int totalRead = 0;
                    for (int remaining = 8192; remaining > 0 && (read = input.read(buffer, totalRead, remaining)) != -1; remaining -= read) {
                        totalRead += read;
                    }
                    if (totalRead <= 0) continue;
                    output.writeByte(103);
                    output.writeInt(totalRead);
                    output.writeByte(104);
                    output.write(buffer, 0, totalRead);
                } while (read > -1);
                output.writeByte(96);
            }
        }

        @Override
        void handleMissingStream(int requestId, int index, FlushableDataOutput output) throws IOException {
            ControllerLogger.MGMT_OP_LOGGER.debugf("Received request for unavailable stream at index %d for request id %d; responding with EOF", index, requestId);
            output.write(96);
        }
    }

    private abstract class AbstractAttachmentHandler
    implements ManagementRequestHandler<Void, Void> {
        private AbstractAttachmentHandler() {
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            final int requestId = input.readInt();
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            final int index = input.readInt();
            final InputStreamKey key = new InputStreamKey(requestId, index);
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    TimedStreamEntry entry = (TimedStreamEntry)ResponseAttachmentInputStreamSupport.this.streamMap.remove(key);
                    FlushableDataOutput output = null;
                    try {
                        output = context.writeMessage((ManagementProtocolHeader)response);
                        if (entry == null) {
                            AbstractAttachmentHandler.this.handleMissingStream(requestId, index, output);
                        } else {
                            TimedStreamEntry timedStreamEntry = entry;
                            synchronized (timedStreamEntry) {
                                if (entry.closed) {
                                    AbstractAttachmentHandler.this.handleMissingStream(requestId, index, output);
                                } else {
                                    AbstractAttachmentHandler.this.handleRequest(entry, output);
                                    entry.timestamp.set(System.currentTimeMillis());
                                }
                            }
                        }
                        output.writeByte(36);
                        output.close();
                        resultHandler.done(null);
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                        StreamUtils.safeClose((Closeable)entry);
                    }
                }
            });
        }

        abstract void handleRequest(TimedStreamEntry var1, FlushableDataOutput var2) throws IOException;

        abstract void handleMissingStream(int var1, int var2, FlushableDataOutput var3) throws IOException;
    }

    private static class InputStreamKey {
        private final int requestId;
        private final int index;

        InputStreamKey(int requestId, int index) {
            this.requestId = requestId;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InputStreamKey that = (InputStreamKey)o;
            return this.index == that.index && this.requestId == that.requestId;
        }

        public int hashCode() {
            int result = this.requestId;
            result = 31 * result + this.index;
            return result;
        }
    }
}

