/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.EnumSet;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadOperationDescriptionHandler
implements OperationStepHandler {
    static final SimpleAttributeDefinition ACCESS_CONTROL = new SimpleAttributeDefinitionBuilder("access-control", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(false)).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-operation-description", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.NAME, GlobalOperationAttributes.LOCALE).setReplyType(ModelType.OBJECT).setReadOnly().setRuntimeOnly().build();
    static final OperationStepHandler INSTANCE = new ReadOperationDescriptionHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = GlobalOperationAttributes.NAME.resolveModelAttribute(context, operation).asString();
        boolean accessControl = ACCESS_CONTROL.resolveModelAttribute(context, operation).asBoolean();
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        OperationEntry operationEntry = registry.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
        if (operationEntry == null || context.getProcessType() == ProcessType.DOMAIN_SERVER && !operationEntry.getFlags().contains((Object)OperationEntry.Flag.RUNTIME_ONLY)) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.operationNotRegistered(operationName, PathAddress.pathAddress(operation.require("address")))));
        }
        ModelNode result = operationEntry.getDescriptionProvider().getModelDescription(GlobalOperationHandlers.getLocale(context, operation));
        EnumSet<OperationEntry.Flag> flags = operationEntry.getFlags();
        boolean readOnly = flags.contains((Object)OperationEntry.Flag.READ_ONLY);
        result.get("read-only").set(readOnly);
        if (!readOnly) {
            if (flags.contains((Object)OperationEntry.Flag.RESTART_ALL_SERVICES)) {
                result.get("restart-required").set("all-services");
            } else if (flags.contains((Object)OperationEntry.Flag.RESTART_RESOURCE_SERVICES)) {
                result.get("restart-required").set("resource-services");
            } else if (flags.contains((Object)OperationEntry.Flag.RESTART_JVM)) {
                result.get("restart-required").set("jvm");
            }
        }
        if (accessControl) {
            PathAddress address = PathAddress.pathAddress(operation.require("address"));
            ModelNode operationToCheck = Util.createOperation(operationName, address);
            operationToCheck.get("operation-headers").set(operation.get("operation-headers"));
            AuthorizationResult authorizationResult = context.authorizeOperation(operationToCheck);
            result.get(new String[]{ACCESS_CONTROL.getName(), "execute"}).set(authorizationResult.getDecision() == AuthorizationResult.Decision.PERMIT);
        }
        context.getResult().set(result);
        context.stepCompleted();
    }
}

