/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ValidateModelStepHandler
implements OperationStepHandler {
    public static final ValidateModelStepHandler INSTANCE = new ValidateModelStepHandler();

    private ValidateModelStepHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        ModelNode model = resource.getModel();
        ImmutableManagementResourceRegistration resourceRegistration = context.getResourceRegistration();
        Set<String> attributeNames = resourceRegistration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        for (String attributeName : attributeNames) {
            boolean has = model.hasDefined(attributeName);
            AttributeAccess access = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            if (access.getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
            AttributeDefinition attr = access.getAttributeDefinition();
            if (!has && this.isRequired(attr, model)) {
                throw new OperationFailedException(ControllerMessages.MESSAGES.required(attributeName));
            }
            if (!has) continue;
            if (attr.getRequires() != null) {
                for (String required : attr.getRequires()) {
                    if (model.hasDefined(required)) continue;
                    throw ControllerMessages.MESSAGES.requiredAttributeNotSet(required, attr.getName());
                }
            }
            if (this.isAllowed(attr, model)) continue;
            String[] alts = attr.getAlternatives();
            StringBuilder sb = null;
            if (alts != null) {
                for (String alt : alts) {
                    if (!model.hasDefined(alt)) continue;
                    if (sb == null) {
                        sb = new StringBuilder();
                    } else {
                        sb.append(", ");
                    }
                    sb.append(alt);
                }
            }
            throw new OperationFailedException(ControllerMessages.MESSAGES.invalidAttributeCombo(attributeName, sb));
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    boolean isRequired(AttributeDefinition def, ModelNode model) {
        boolean required;
        boolean bl = required = !def.isAllowNull() && !def.isResourceOnly();
        return required ? !this.hasAlternative(def.getAlternatives(), model) : required;
    }

    boolean isAllowed(AttributeDefinition def, ModelNode model) {
        String[] alternatives = def.getAlternatives();
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!model.hasDefined(alternative)) continue;
                return false;
            }
        }
        return true;
    }

    boolean hasAlternative(String[] alternatives, ModelNode operationObject) {
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!operationObject.hasDefined(alternative)) continue;
                return true;
            }
        }
        return false;
    }
}

