/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import com.oracle.common.internal.net.ipclw.mql.LocalQueue;
import com.oracle.common.io.BufferManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import oracle.net.ns.NetException;

public class NTMQProtocolHandler {
    private ByteBuffer remoteQueueNameBuffer;
    private byte ntmqVersion;
    private byte msgqltProtocolType;
    private byte packetType;
    private byte packetFlag;
    private byte[] sessionIdentifier;
    private int tduMDUSize;
    private int headerPacketSize = 2;
    private short connectFlag;
    private short endianess;
    private short messageQueueLength;
    private boolean requireSessionIdentifier;
    protected static final byte NTMQHTCN = 1;
    protected static final byte NTMQHTDC = 2;
    protected static final byte NTMQHTRF = 3;
    protected static final byte NTMQHTDA = 4;
    protected static final byte NTMQHTEO = 5;
    protected static final byte NTMQHTIR = 6;
    protected static final byte NTMQHFARQ = 1;
    protected static final byte NTMQHFARS = 2;
    protected static final byte NTMQHFSID = 4;
    private static final short NTMQCFSI = 1;
    private static final short NTMQ_BIG_ENDIAN = 1;
    private static final short NTMQ_LITTLE_ENDIAN = 256;
    private static final byte NTMQ_PROTOCOL_VERSION = 1;
    private static final int SESSION_IDENTIFIER_SIZE = 16;
    private static final byte HEADER_PACKET_SIZE_WITH_SESSION_ID = 18;
    private static final byte HEADER_PACKET_SIZE_WITHOUT_SESSION_ID = 2;
    protected static final int CONNECT_PACKET_SIZE = 256;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    NTMQProtocolHandler(byte by, boolean bl) {
        this.msgqltProtocolType = by;
        this.requireSessionIdentifier = bl;
    }

    protected void processNTMQPacket(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, BufferManager bufferManager) throws NetException {
        this.parseHeaderPacket(byteBuffer);
        switch (this.packetType) {
            case 1: {
                this.parseConnectPacket(byteBuffer2, bufferManager);
                break;
            }
            case 2: {
                throw new NetException(26, "Expecting Connect or Data packet. Received Disconnect Packet");
            }
            case 4: {
                break;
            }
            case 5: {
                throw new NetException(26, "Expecting Connect or Data packet. Received Echo Packet");
            }
            case 6: {
                throw new NetException(26, "Expecting Connect or Data packet. Received Interrupt Packet");
            }
            default: {
                throw new NetException(26);
            }
        }
    }

    protected void parseHeaderPacket(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.packetType = byteBuffer.get();
        this.packetFlag = byteBuffer.get();
        if ((this.packetFlag & 4) != 0) {
            if (this.sessionIdentifier == null || this.sessionIdentifier.length < 16) {
                this.sessionIdentifier = new byte[16];
            }
            byteBuffer.get(this.sessionIdentifier, 0, 16);
        }
        byteBuffer.clear();
    }

    protected void parseConnectPacket(ByteBuffer byteBuffer, BufferManager bufferManager) {
        this.ntmqVersion = byteBuffer.get();
        this.msgqltProtocolType = byteBuffer.get();
        this.connectFlag = byteBuffer.getShort();
        if ((this.connectFlag & 1) != 0) {
            this.requireSessionIdentifier = true;
        }
        this.sessionIdentifier = new byte[16];
        byteBuffer.get(this.sessionIdentifier, 0, 16);
        this.tduMDUSize = byteBuffer.getInt();
        this.endianess = byteBuffer.getShort();
        this.messageQueueLength = byteBuffer.getShort();
        this.remoteQueueNameBuffer = bufferManager.acquire((int)this.messageQueueLength);
        byte[] byArray = new byte[this.messageQueueLength];
        this.remoteQueueNameBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.get(byArray, 0, this.messageQueueLength);
        this.remoteQueueNameBuffer.put(byArray);
        int n2 = 256 - byteBuffer.position();
        byte[] byArray2 = new byte[n2];
        byteBuffer.get(byArray2, 0, n2);
        this.remoteQueueNameBuffer.flip();
    }

    private void appendFlowControlPacket(ByteBuffer byteBuffer) {
        int n2 = 256 - byteBuffer.position();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = 0;
        }
        byteBuffer.put(byArray);
    }

    protected void prepareConnectPacket(ByteBuffer byteBuffer, byte[] byArray, int n2, ByteOrder byteOrder, LocalQueue localQueue) {
        ByteBuffer byteBuffer2 = localQueue.getName().getBuffer();
        byteBuffer2.rewind();
        byteBuffer2.position(0);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put((byte)1);
        byteBuffer.put(this.msgqltProtocolType);
        if (this.requireSessionIdentifier) {
            byteBuffer.putShort((short)1);
        } else {
            byteBuffer.putShort((short)0);
        }
        if (byArray == null || byArray.length != 16) {
            if (this.requireSessionIdentifier) {
                // empty if block
            }
            byArray = new byte[16];
            for (int i2 = 0; i2 < 16; ++i2) {
                byArray[i2] = 0;
            }
        }
        byteBuffer.put(byArray);
        byteBuffer.putInt(n2);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)byteBuffer2.limit());
        byteBuffer.put(byteBuffer2);
        this.appendFlowControlPacket(byteBuffer);
        byteBuffer.flip();
    }

    protected int prepareHeaderPacket(ByteBuffer byteBuffer, byte by, byte by2, byte[] byArray) {
        byteBuffer.position(0);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(by);
        if (this.requireSessionIdentifier) {
            by2 = (byte)(by2 | 4);
        }
        byteBuffer.put(by2);
        if (this.requireSessionIdentifier && byArray != null && byArray.length == 16) {
            byteBuffer.put(byArray);
        }
        byteBuffer.flip();
        return byteBuffer.limit();
    }

    protected int getHeaderPacketSize() {
        return this.headerPacketSize;
    }

    protected boolean isConnectPacket() {
        return this.packetType == 1;
    }

    protected ByteBuffer getRemoteQueueNameBuffer() {
        return this.remoteQueueNameBuffer;
    }
}

