/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.model.host.AdminOnlyDomainConfigPolicy;

public class LocalHostControllerInfoImpl
implements LocalHostControllerInfo {
    private final ControlledProcessState processState;
    private final HostControllerEnvironment hostEnvironment;
    private final String localHostName;
    private String remoteDcHost;
    private int remoteDcPort;
    private volatile boolean master;
    private volatile String nativeManagementInterface;
    private volatile int nativeManagementPort;
    private volatile String remoteDCUser;
    private volatile String remoteSecurityRealm;
    private volatile boolean remoteIgnoreUnaffectedConfiguration;
    private List<DiscoveryOption> remoteDiscoveryOptions = new ArrayList<DiscoveryOption>();
    private volatile String httpManagementInterface;
    private volatile int httpManagementPort;
    private volatile String httpManagementSecureInterface;
    private volatile int httpManagementSecurePort;
    private volatile String nativeManagementSecurityRealm;
    private volatile String httpManagementSecurityRealm;
    private volatile AdminOnlyDomainConfigPolicy adminOnlyDomainConfigPolicy = AdminOnlyDomainConfigPolicy.ALLOW_NO_CONFIG;

    public LocalHostControllerInfoImpl(ControlledProcessState processState, String localHostName) {
        this.processState = processState;
        this.hostEnvironment = null;
        this.localHostName = localHostName;
    }

    public LocalHostControllerInfoImpl(ControlledProcessState processState, HostControllerEnvironment hostEnvironment) {
        this.processState = processState;
        this.hostEnvironment = hostEnvironment;
        this.localHostName = null;
    }

    @Override
    public String getLocalHostName() {
        return this.hostEnvironment == null ? this.localHostName : this.hostEnvironment.getHostControllerName();
    }

    @Override
    public ControlledProcessState.State getProcessState() {
        return this.processState.getState();
    }

    @Override
    public boolean isMasterDomainController() {
        return this.master;
    }

    @Override
    public String getNativeManagementInterface() {
        return this.nativeManagementInterface;
    }

    @Override
    public int getNativeManagementPort() {
        return this.nativeManagementPort;
    }

    @Override
    public String getNativeManagementSecurityRealm() {
        return this.nativeManagementSecurityRealm;
    }

    @Override
    public String getHttpManagementInterface() {
        return this.httpManagementInterface;
    }

    @Override
    public int getHttpManagementPort() {
        return this.httpManagementPort;
    }

    @Override
    public String getHttpManagementSecureInterface() {
        return this.httpManagementSecureInterface == null ? this.httpManagementInterface : this.httpManagementSecureInterface;
    }

    @Override
    public int getHttpManagementSecurePort() {
        return this.httpManagementSecurePort;
    }

    @Override
    public String getHttpManagementSecurityRealm() {
        return this.httpManagementSecurityRealm;
    }

    public String getRemoteDomainControllerHost() {
        return this.remoteDcHost;
    }

    public int getRemoteDomainControllerPort() {
        return this.remoteDcPort;
    }

    @Override
    public String getRemoteDomainControllerUsername() {
        return this.remoteDCUser;
    }

    public String getRemoteDomainControllerSecurityRealm() {
        return this.remoteSecurityRealm;
    }

    @Override
    public List<DiscoveryOption> getRemoteDomainControllerDiscoveryOptions() {
        return this.remoteDiscoveryOptions;
    }

    public AdminOnlyDomainConfigPolicy getAdminOnlyDomainConfigPolicy() {
        return this.adminOnlyDomainConfigPolicy;
    }

    void setAdminOnlyDomainConfigPolicy(AdminOnlyDomainConfigPolicy adminOnlyDomainConfigPolicy) {
        this.adminOnlyDomainConfigPolicy = adminOnlyDomainConfigPolicy;
    }

    void setMasterDomainController(boolean master) {
        this.master = master;
    }

    void setNativeManagementInterface(String nativeManagementInterface) {
        this.nativeManagementInterface = nativeManagementInterface;
    }

    void setNativeManagementPort(int nativeManagementPort) {
        this.nativeManagementPort = nativeManagementPort;
    }

    void setNativeManagementSecurityRealm(String nativeManagementSecurityRealm) {
        this.nativeManagementSecurityRealm = nativeManagementSecurityRealm;
    }

    void setHttpManagementInterface(String httpManagementInterface) {
        this.httpManagementInterface = httpManagementInterface;
    }

    void setHttpManagementPort(int httpManagementPort) {
        this.httpManagementPort = httpManagementPort;
    }

    void setHttpManagementSecureInterface(String httpManagementSecureInterface) {
        this.httpManagementSecureInterface = httpManagementSecureInterface;
    }

    void setHttpManagementSecurePort(int httpManagementSecurePort) {
        this.httpManagementSecurePort = httpManagementSecurePort;
    }

    void setHttpManagementSecurityRealm(String httpManagementSecurityRealm) {
        this.httpManagementSecurityRealm = httpManagementSecurityRealm;
    }

    void setRemoteDomainControllerHost(String host) {
        this.remoteDcHost = host;
    }

    void setRemoteDomainControllerPort(int port) {
        this.remoteDcPort = port;
    }

    void setRemoteDomainControllerUsername(String userName) {
        this.remoteDCUser = userName;
    }

    void setRemoteDomainControllerSecurityRealm(String remoteSecurityRealm) {
        this.remoteSecurityRealm = remoteSecurityRealm;
    }

    void addRemoteDomainControllerDiscoveryOption(DiscoveryOption discoveryOption) {
        this.remoteDiscoveryOptions.add(discoveryOption);
    }
}

