/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSolrServer
extends SolrServer {
    private static final String UTF_8 = "UTF-8";
    private static final String DEFAULT_PATH = "/select";
    private static final long serialVersionUID = 1L;
    public static final String AGENT = "Solr[" + HttpSolrServer.class.getName() + "] 1.0";
    private static Logger log = LoggerFactory.getLogger(HttpSolrServer.class);
    protected String baseUrl;
    protected ModifiableSolrParams invariantParams;
    protected ResponseParser parser;
    protected RequestWriter requestWriter = new RequestWriter();
    private final HttpClient httpClient;
    private boolean followRedirects = false;
    private int maxRetries = 0;
    private ThreadSafeClientConnManager ccm;
    private boolean useMultiPartPost;

    public HttpSolrServer(String baseURL) {
        this(baseURL, null, new BinaryResponseParser());
    }

    public HttpSolrServer(String baseURL, HttpClient client) {
        this(baseURL, client, new BinaryResponseParser());
    }

    public HttpSolrServer(String baseURL, HttpClient client, ResponseParser parser) {
        this.baseUrl = baseURL;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.baseUrl.indexOf(63) >= 0) {
            throw new RuntimeException("Invalid base url for solrj.  The base URL must not contain parameters: " + this.baseUrl);
        }
        this.httpClient = client != null ? client : this.createClient();
        this.parser = parser;
    }

    private DefaultHttpClient createClient() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        this.ccm = new ThreadSafeClientConnManager(schemeRegistry);
        this.ccm.setDefaultMaxPerRoute(32);
        this.ccm.setMaxTotal(128);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)this.ccm);
        httpClient.getParams().setParameter("http.protocol.handle-redirects", (Object)this.followRedirects);
        return httpClient;
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.request(request, responseParser);
    }

    /*
     * Exception decompiling
     */
    public NamedList<Object> request(SolrRequest request, ResponseParser processor) throws SolrServerException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 23[WHILELOOP]], but top level block is 47[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ModifiableSolrParams getInvariantParams() {
        return this.invariantParams;
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(String baseURL) {
        this.baseUrl = baseURL;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public void setParser(ResponseParser processor) {
        this.parser = processor;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectionTimeout(int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpClient.getParams(), (int)timeout);
    }

    public void setSoTimeout(int timeout) {
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpClient.getParams(), (int)timeout);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        new ClientParamBean(this.httpClient.getParams()).setHandleRedirects(followRedirects);
    }

    public void setAllowCompression(boolean allowCompression) {
        if (this.httpClient instanceof DefaultHttpClient) {
            DefaultHttpClient client = (DefaultHttpClient)this.httpClient;
            client.removeRequestInterceptorByClass(UseCompressionRequestInterceptor.class);
            client.removeResponseInterceptorByClass(UseCompressionResponseInterceptor.class);
            if (allowCompression) {
                client.addRequestInterceptor((HttpRequestInterceptor)new UseCompressionRequestInterceptor());
                client.addResponseInterceptor((HttpResponseInterceptor)new UseCompressionResponseInterceptor());
            }
        } else {
            throw new UnsupportedOperationException("HttpClient instance was not of type DefaultHttpClient");
        }
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries > 1) {
            log.warn("CommonsHttpSolrServer: maximum Retries " + maxRetries + " > 1. Maximum recommended retries is 1.");
        }
        this.maxRetries = maxRetries;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public UpdateResponse add(Iterator<SolrInputDocument> docIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(docIterator);
        return req.process(this);
    }

    public UpdateResponse addBeans(final Iterator<?> beanIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(new Iterator<SolrInputDocument>(){

            @Override
            public boolean hasNext() {
                return beanIterator.hasNext();
            }

            @Override
            public SolrInputDocument next() {
                Object o = beanIterator.next();
                if (o == null) {
                    return null;
                }
                return HttpSolrServer.this.getBinder().toSolrInputDocument(o);
            }

            @Override
            public void remove() {
                beanIterator.remove();
            }
        });
        return req.process(this);
    }

    public void shutdown() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public void setDefaultMaxConnectionsPerHost(int max) {
        if (this.ccm == null) {
            throw new UnsupportedOperationException("Client was created outside of HttpSolrServer");
        }
        this.ccm.setDefaultMaxPerRoute(max);
    }

    public void setMaxTotalConnections(int max) {
        if (this.ccm == null) {
            throw new UnsupportedOperationException("Client was created outside of HttpSolrServer");
        }
        this.ccm.setMaxTotal(max);
    }

    private static class DeflateDecompressingEntity
    extends GzipDecompressingEntity {
        public DeflateDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return new InflaterInputStream(this.wrappedEntity.getContent());
        }
    }

    private static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }

    private static class UseCompressionResponseInterceptor
    implements HttpResponseInterceptor {
        private UseCompressionResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpEntity entity = response.getEntity();
            Header ceheader = entity.getContentEncoding();
            if (ceheader != null) {
                HeaderElement[] codecs = ceheader.getElements();
                for (int i = 0; i < codecs.length; ++i) {
                    if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                    if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    private static class UseCompressionRequestInterceptor
    implements HttpRequestInterceptor {
        private UseCompressionRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (!request.containsHeader("Accept-Encoding")) {
                request.addHeader("Accept-Encoding", "gzip, deflate");
            }
        }
    }
}

