/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.deployers.SecurityActions;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;

public class EEModuleConfigurationProcessor
implements DeploymentUnitProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CLASS_INDEX);
        if (module == null || moduleDescription == null) {
            return;
        }
        HashSet<ServiceName> failed = new HashSet<ServiceName>();
        EEModuleConfiguration moduleConfiguration = new EEModuleConfiguration(moduleDescription);
        deploymentUnit.putAttachment(Attachments.EE_MODULE_CONFIGURATION, (Object)moduleConfiguration);
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)module.getClassLoader());
            Iterator<ComponentDescription> iterator = moduleDescription.getComponentDescriptions().iterator();
            while (iterator.hasNext()) {
                ComponentDescription componentDescription = iterator.next();
                EeLogger.ROOT_LOGGER.debugf("Configuring component class: %s named %s", componentDescription.getComponentClassName(), componentDescription.getComponentName());
                try {
                    ComponentConfiguration componentConfiguration = componentDescription.createConfiguration(classIndex.classIndex(componentDescription.getComponentClassName()), (ClassLoader)module.getClassLoader(), module.getModuleLoader());
                    for (ComponentConfigurator componentConfigurator : componentDescription.getConfigurators()) {
                        componentConfigurator.configure(phaseContext, componentDescription, componentConfiguration);
                    }
                    moduleConfiguration.addComponentConfiguration(componentConfiguration);
                }
                catch (Exception e) {
                    if (componentDescription.isOptional()) {
                        EeLogger.ROOT_LOGGER.componentInstallationFailure(componentDescription.getComponentName());
                        EeLogger.ROOT_LOGGER.debugf(e, "Not installing optional component %s due to an exception", componentDescription.getComponentName());
                        failed.add(componentDescription.getStartServiceName());
                        failed.add(componentDescription.getCreateServiceName());
                        failed.add(componentDescription.getServiceName());
                        iterator.remove();
                        continue;
                    }
                    throw EeMessages.MESSAGES.cannotConfigureComponent(e, componentDescription.getComponentName());
                }
            }
            deploymentUnit.putAttachment(Attachments.FAILED_COMPONENTS, Collections.synchronizedSet(failed));
        }
        finally {
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

