/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.ProcessingException;
import org.jboss.security.xacml.sunxacml.cond.Evaluatable;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.Expression;
import org.jboss.security.xacml.sunxacml.cond.VariableDefinition;
import org.jboss.security.xacml.sunxacml.cond.VariableManager;
import org.w3c.dom.Node;

public class VariableReference
implements Evaluatable {
    private String variableId;
    private VariableDefinition definition = null;
    private VariableManager manager = null;

    public VariableReference(String variableId) {
        this.variableId = variableId;
    }

    public VariableReference(VariableDefinition definition) {
        this.variableId = definition.getVariableId();
        this.definition = definition;
    }

    public VariableReference(String variableId, VariableManager manager) {
        this.variableId = variableId;
        this.manager = manager;
    }

    public static VariableReference getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        String variableId = root.getAttributes().getNamedItem("VariableId").getNodeValue();
        return new VariableReference(variableId, manager);
    }

    public String getVariableId() {
        return this.variableId;
    }

    public VariableDefinition getReferencedDefinition() {
        if (this.definition != null) {
            return this.definition;
        }
        if (this.manager != null) {
            return this.manager.getDefinition(this.variableId);
        }
        return null;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        Expression xpr = this.getReferencedDefinition().getExpression();
        return ((Evaluatable)xpr).evaluate(context);
    }

    @Override
    public URI getType() {
        if (this.definition != null) {
            return this.definition.getExpression().getType();
        }
        if (this.manager != null) {
            return this.manager.getVariableType(this.variableId);
        }
        throw new ProcessingException("couldn't resolve the type");
    }

    @Override
    public boolean returnsBag() {
        if (this.definition != null) {
            return this.getReferencedDefinition().getExpression().returnsBag();
        }
        if (this.manager != null) {
            return this.manager.returnsBag(this.variableId);
        }
        throw new ProcessingException("couldn't resolve the return type");
    }

    @Override
    public boolean evaluatesToBag() {
        return this.returnsBag();
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<VariableReference VariableId=\"" + this.variableId + "\"/>");
    }
}

