/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DateAttribute;
import org.jboss.security.xacml.sunxacml.attr.DateTimeAttribute;
import org.jboss.security.xacml.sunxacml.attr.DayTimeDurationAttribute;
import org.jboss.security.xacml.sunxacml.attr.YearMonthDurationAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.FunctionBase;

public class DateMathFunction
extends FunctionBase {
    public static final String NAME_DATETIME_ADD_DAYTIMEDURATION = "urn:oasis:names:tc:xacml:1.0:function:dateTime-add-dayTimeDuration";
    public static final String NAME_DATETIME_SUBTRACT_DAYTIMEDURATION = "urn:oasis:names:tc:xacml:1.0:function:dateTime-subtract-dayTimeDuration";
    public static final String NAME_DATETIME_ADD_YEARMONTHDURATION = "urn:oasis:names:tc:xacml:1.0:function:dateTime-add-yearMonthDuration";
    public static final String NAME_DATETIME_SUBTRACT_YEARMONTHDURATION = "urn:oasis:names:tc:xacml:1.0:function:dateTime-subtract-yearMonthDuration";
    public static final String NAME_DATE_ADD_YEARMONTHDURATION = "urn:oasis:names:tc:xacml:1.0:function:date-add-yearMonthDuration";
    public static final String NAME_DATE_SUBTRACT_YEARMONTHDURATION = "urn:oasis:names:tc:xacml:1.0:function:date-subtract-yearMonthDuration";
    private static final int ID_DATETIME_ADD_DAYTIMEDURATION = 0;
    private static final int ID_DATETIME_SUBTRACT_DAYTIMEDURATION = 1;
    private static final int ID_DATETIME_ADD_YEARMONTHDURATION = 2;
    private static final int ID_DATETIME_SUBTRACT_YEARMONTHDURATION = 3;
    private static final int ID_DATE_ADD_YEARMONTHDURATION = 4;
    private static final int ID_DATE_SUBTRACT_YEARMONTHDURATION = 5;
    private static final String[] dateTimeDayTimeDurationArgTypes = new String[]{"http://www.w3.org/2001/XMLSchema#dateTime", "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration"};
    private static final String[] dateTimeYearMonthDurationArgTypes = new String[]{"http://www.w3.org/2001/XMLSchema#dateTime", "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration"};
    private static final String[] dateYearMonthDurationArgTypes = new String[]{"http://www.w3.org/2001/XMLSchema#date", "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration"};
    private static final boolean[] bagParams = new boolean[]{false, false};
    private static HashMap idMap = new HashMap();
    private static HashMap typeMap;

    public DateMathFunction(String functionName) {
        super(functionName, DateMathFunction.getId(functionName), DateMathFunction.getArgumentTypes(functionName), bagParams, DateMathFunction.getReturnType(functionName), false);
    }

    private static int getId(String functionName) {
        Integer i = (Integer)idMap.get(functionName);
        if (i == null) {
            throw new IllegalArgumentException("unknown datemath function " + functionName);
        }
        return i;
    }

    private static String[] getArgumentTypes(String functionName) {
        return (String[])typeMap.get(functionName);
    }

    private static String getReturnType(String functionName) {
        if (functionName.equals(NAME_DATE_ADD_YEARMONTHDURATION) || functionName.equals(NAME_DATE_SUBTRACT_YEARMONTHDURATION)) {
            return "http://www.w3.org/2001/XMLSchema#date";
        }
        return "http://www.w3.org/2001/XMLSchema#dateTime";
    }

    public static Set getSupportedIdentifiers() {
        return Collections.unmodifiableSet(idMap.keySet());
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        AttributeValue attrResult = null;
        switch (this.getFunctionId()) {
            case 0: 
            case 1: {
                DateTimeAttribute dateTime = (DateTimeAttribute)argValues[0];
                DayTimeDurationAttribute duration = (DayTimeDurationAttribute)argValues[1];
                int sign = 1;
                if (this.getFunctionId() == 1) {
                    sign = -sign;
                }
                if (duration.isNegative()) {
                    sign = -sign;
                }
                long millis = (long)sign * duration.getTotalSeconds();
                long nanoseconds = dateTime.getNanoseconds();
                if ((nanoseconds += (long)(sign * duration.getNanoseconds())) >= 1000000000L) {
                    nanoseconds -= 1000000000L;
                    millis += 1000L;
                }
                if (nanoseconds < 0L) {
                    nanoseconds += 1000000000L;
                    millis -= 1000L;
                }
                attrResult = new DateTimeAttribute(new Date(millis += dateTime.getValue().getTime()), (int)nanoseconds, dateTime.getTimeZone(), dateTime.getDefaultedTimeZone());
                break;
            }
            case 2: 
            case 3: {
                DateTimeAttribute dateTime = (DateTimeAttribute)argValues[0];
                YearMonthDurationAttribute duration = (YearMonthDurationAttribute)argValues[1];
                int sign = 1;
                if (this.getFunctionId() == 3) {
                    sign = -sign;
                }
                if (duration.isNegative()) {
                    sign = -sign;
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(dateTime.getValue());
                long years = (long)sign * duration.getYears();
                long months = (long)sign * duration.getMonths();
                if (years > Integer.MAX_VALUE || years < Integer.MIN_VALUE) {
                    return DateMathFunction.makeProcessingError("years too large");
                }
                if (months > Integer.MAX_VALUE || months < Integer.MIN_VALUE) {
                    return DateMathFunction.makeProcessingError("months too large");
                }
                ((Calendar)cal).add(1, (int)years);
                ((Calendar)cal).add(2, (int)months);
                attrResult = new DateTimeAttribute(cal.getTime(), dateTime.getNanoseconds(), dateTime.getTimeZone(), dateTime.getDefaultedTimeZone());
                break;
            }
            case 4: 
            case 5: {
                DateAttribute date = (DateAttribute)argValues[0];
                YearMonthDurationAttribute duration = (YearMonthDurationAttribute)argValues[1];
                int sign = 1;
                if (this.getFunctionId() == 5) {
                    sign = -sign;
                }
                if (duration.isNegative()) {
                    sign = -sign;
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(date.getValue());
                long years = (long)sign * duration.getYears();
                long months = (long)sign * duration.getMonths();
                if (years > Integer.MAX_VALUE || years < Integer.MIN_VALUE) {
                    return DateMathFunction.makeProcessingError("years too large");
                }
                if (months > Integer.MAX_VALUE || months < Integer.MIN_VALUE) {
                    return DateMathFunction.makeProcessingError("months too large");
                }
                ((Calendar)cal).add(1, (int)years);
                ((Calendar)cal).add(2, (int)months);
                attrResult = new DateAttribute(cal.getTime(), date.getTimeZone(), date.getDefaultedTimeZone());
                break;
            }
        }
        return new EvaluationResult(attrResult);
    }

    static {
        idMap.put(NAME_DATETIME_ADD_DAYTIMEDURATION, new Integer(0));
        idMap.put(NAME_DATETIME_SUBTRACT_DAYTIMEDURATION, new Integer(1));
        idMap.put(NAME_DATETIME_ADD_YEARMONTHDURATION, new Integer(2));
        idMap.put(NAME_DATETIME_SUBTRACT_YEARMONTHDURATION, new Integer(3));
        idMap.put(NAME_DATE_ADD_YEARMONTHDURATION, new Integer(4));
        idMap.put(NAME_DATE_SUBTRACT_YEARMONTHDURATION, new Integer(5));
        typeMap = new HashMap();
        typeMap.put(NAME_DATETIME_ADD_DAYTIMEDURATION, dateTimeDayTimeDurationArgTypes);
        typeMap.put(NAME_DATETIME_SUBTRACT_DAYTIMEDURATION, dateTimeDayTimeDurationArgTypes);
        typeMap.put(NAME_DATETIME_ADD_YEARMONTHDURATION, dateTimeYearMonthDurationArgTypes);
        typeMap.put(NAME_DATETIME_SUBTRACT_YEARMONTHDURATION, dateTimeYearMonthDurationArgTypes);
        typeMap.put(NAME_DATE_ADD_YEARMONTHDURATION, dateYearMonthDurationArgTypes);
        typeMap.put(NAME_DATE_SUBTRACT_YEARMONTHDURATION, dateYearMonthDurationArgTypes);
    }
}

