/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.CustomFormatterResourceDefinition;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingResourceDefinition;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PatternFormatterResourceDefinition;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.SyslogHandlerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class LoggingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final LoggingSubsystemParser INSTANCE = new LoggingSubsystemParser();

    private LoggingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"logging")});
        ModelNode subsystemAddOp = Util.createAddOperation((PathAddress)address);
        list.add(subsystemAddOp);
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> formatterOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        HashSet<String> formatterNames = new HashSet<String>();
        boolean gotRoot = false;
        block18: while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
            switch (namespace) {
                case LOGGING_1_0: 
                case LOGGING_1_1: 
                case LOGGING_1_2: 
                case LOGGING_1_3: 
                case LOGGING_1_4: 
                case LOGGING_1_5: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case ADD_LOGGING_API_DEPENDENCIES: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
                            LoggingResourceDefinition.ADD_LOGGING_API_DEPENDENCIES.parseAndSetParameter(value, subsystemAddOp, (XMLStreamReader)reader);
                            continue block18;
                        }
                        case LOGGER: {
                            LoggingSubsystemParser.parseLoggerElement(reader, address, loggerOperations, loggerNames);
                            continue block18;
                        }
                        case ROOT_LOGGER: {
                            if (gotRoot) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            gotRoot = true;
                            LoggingSubsystemParser.parseRootLoggerElement(reader, address, loggerOperations);
                            continue block18;
                        }
                        case CONSOLE_HANDLER: {
                            LoggingSubsystemParser.parseConsoleHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block18;
                        }
                        case FILE_HANDLER: {
                            LoggingSubsystemParser.parseFileHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block18;
                        }
                        case CUSTOM_HANDLER: {
                            if (namespace == Namespace.LOGGING_1_0) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parseCustomHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block18;
                        }
                        case PERIODIC_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parsePeriodicRotatingFileHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block18;
                        }
                        case PERIODIC_SIZE_ROTATING_FILE_HANDLER: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3 || namespace == Namespace.LOGGING_1_4) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parsePeriodicSizeRotatingHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block18;
                        }
                        case SIZE_ROTATING_FILE_HANDLER: {
                            LoggingSubsystemParser.parseSizeRotatingHandlerElement(reader, address, handlerOperations, handlerNames);
                            continue block18;
                        }
                        case ASYNC_HANDLER: {
                            LoggingSubsystemParser.parseAsyncHandlerElement(reader, address, asyncHandlerOperations, handlerNames);
                            continue block18;
                        }
                        case SYSLOG_HANDLER: {
                            LoggingSubsystemParser.parseSyslogHandler(reader, address, handlerOperations, handlerNames);
                            continue block18;
                        }
                        case LOGGING_PROFILES: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parseLoggingProfilesElement(reader, address, list);
                            continue block18;
                        }
                        case FORMATTER: {
                            if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            LoggingSubsystemParser.parseFormatter(reader, address, formatterOperations, formatterNames);
                            continue block18;
                        }
                    }
                    reader.handleAny(list);
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.addAll(formatterOperations);
        list.addAll(handlerOperations);
        list.addAll(asyncHandlerOperations);
        list.addAll(loggerOperations);
    }

    static void parseLoggerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode op = new ModelNode();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CATEGORY);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CATEGORY: {
                    name = value;
                    continue block9;
                }
                case USE_PARENT_HANDLERS: {
                    LoggerResourceDefinition.USE_PARENT_HANDLERS.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        op.get("operation").set("add");
        op.get("address").set(address.toModelNode()).add("logger", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), op, (XMLStreamReader)reader);
                    continue block10;
                }
                case HANDLERS: {
                    LoggingSubsystemParser.parseHandlersElement(op.get(CommonAttributes.HANDLERS.getName()), reader);
                    continue block10;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(namespace, op, reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(op);
    }

    static void parseAsyncHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode()).add("async-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case SUBHANDLERS: {
                    LoggingSubsystemParser.parseHandlersElement(node.get(AsyncHandlerResourceDefinition.SUBHANDLERS.getName()), reader);
                    continue block13;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(namespace, node, reader);
                    continue block13;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, node);
                    continue block13;
                }
                case QUEUE_LENGTH: {
                    AsyncHandlerResourceDefinition.QUEUE_LENGTH.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case OVERFLOW_ACTION: {
                    AsyncHandlerResourceDefinition.OVERFLOW_ACTION.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value").toUpperCase(Locale.US), node, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parseRootLoggerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode()).add("root-logger", "ROOT");
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (encountered.contains((Object)element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
            }
            encountered.add(element);
            switch (element) {
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(namespace, node, reader);
                    continue block5;
                }
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block5;
                }
                case HANDLERS: {
                    LoggingSubsystemParser.parseHandlersElement(node.get(CommonAttributes.HANDLERS.getName()), reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parseConsoleHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block12;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode()).add("console-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block13;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(namespace, node, reader);
                    continue block13;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, node);
                    continue block13;
                }
                case TARGET: {
                    String target = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    ConsoleHandlerResourceDefinition.TARGET.parseAndSetParameter(target, node, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parseFileHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode()).add("file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(namespace, node, reader);
                    continue block14;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, node);
                    continue block14;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(node.get(CommonAttributes.FILE.getName()), reader);
                    continue block14;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        list.add(node);
    }

    static void parseCustomHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CLASS, Attribute.MODULE);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case CLASS: {
                    CommonAttributes.CLASS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block13;
                }
                case MODULE: {
                    CommonAttributes.MODULE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode()).add("custom-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(namespace, node, reader);
                    continue block14;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, node);
                    continue block14;
                }
                case PROPERTIES: {
                    LoggingSubsystemParser.parsePropertyElement(node, reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    static void parsePeriodicRotatingFileHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block14;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode()).add("periodic-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE, Element.SUFFIX);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block15: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block15;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block15;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(namespace, node, reader);
                    continue block15;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, node);
                    continue block15;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(node.get(CommonAttributes.FILE.getName()), reader);
                    continue block15;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block15;
                }
                case SUFFIX: {
                    PeriodicHandlerResourceDefinition.SUFFIX.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        list.add(node);
    }

    private static void parsePeriodicSizeRotatingHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block17;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                case ROTATE_ON_BOOT: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser.addOperationAddress(operation, address, "periodic-size-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block18: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case FILTER_SPEC: {
                    LoggingSubsystemParser.parseFilter(namespace, operation, reader);
                    continue block18;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, operation);
                    continue block18;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block18;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case ROTATE_SIZE: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case MAX_BACKUP_INDEX: {
                    SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
                case SUFFIX: {
                    PeriodicHandlerResourceDefinition.SUFFIX.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    static void parseSizeRotatingHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode node = new ModelNode();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block17;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block17;
                }
                case ENABLED: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    CommonAttributes.ENABLED.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block17;
                }
                case ROTATE_ON_BOOT: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode()).add("size-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block18: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), node, (XMLStreamReader)reader);
                    continue block18;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block18;
                }
                case FILTER_SPEC: 
                case FILTER: {
                    LoggingSubsystemParser.parseFilter(namespace, node, reader);
                    continue block18;
                }
                case FORMATTER: {
                    LoggingSubsystemParser.parseHandlerFormatterElement(reader, node);
                    continue block18;
                }
                case FILE: {
                    LoggingSubsystemParser.parseFileElement(node.get(CommonAttributes.FILE.getName()), reader);
                    continue block18;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block18;
                }
                case ROTATE_SIZE: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block18;
                }
                case MAX_BACKUP_INDEX: {
                    SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), node, (XMLStreamReader)reader);
                    continue block18;
                }
                case SUFFIX: {
                    if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1 || namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3 || namespace == Namespace.LOGGING_1_4) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    SizeRotatingHandlerResourceDefinition.SUFFIX.parseAndSetParameter(LoggingSubsystemParser.readValueAttribute(reader), node, (XMLStreamReader)reader);
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(node);
    }

    private static void parseSyslogHandler(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> names) throws XMLStreamException {
        ModelNode model = new ModelNode();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block16;
                }
                case ENABLED: {
                    CommonAttributes.ENABLED.parseAndSetParameter(value, model, (XMLStreamReader)reader);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        model.get("operation").set("add");
        model.get("address").set(address.toModelNode()).add("syslog-handler", name);
        EnumSet<Element> requiredElem = EnumSet.noneOf(Element.class);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block17: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case APP_NAME: {
                    SyslogHandlerResourceDefinition.APP_NAME.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), model, (XMLStreamReader)reader);
                    continue block17;
                }
                case FACILITY: {
                    SyslogHandlerResourceDefinition.FACILITY.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), model, (XMLStreamReader)reader);
                    continue block17;
                }
                case HOSTNAME: {
                    SyslogHandlerResourceDefinition.HOSTNAME.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), model, (XMLStreamReader)reader);
                    continue block17;
                }
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"), model, (XMLStreamReader)reader);
                    continue block17;
                }
                case FORMATTER: {
                    if (reader.nextTag() != 1) {
                        throw new XMLStreamException(LoggingMessages.MESSAGES.missingRequiredNestedFilterElement(), reader.getLocation());
                    }
                    switch (Element.forName(reader.getLocalName())) {
                        case SYSLOG_FORMATTER: {
                            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.SYSLOG_TYPE.getLocalName());
                            model.get(SyslogHandlerResourceDefinition.SYSLOG_FORMATTER.getName()).set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.SYSLOG_TYPE.getLocalName()));
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            continue block17;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case PORT: {
                    SyslogHandlerResourceDefinition.PORT.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), model, (XMLStreamReader)reader);
                    continue block17;
                }
                case SERVER_ADDRESS: {
                    SyslogHandlerResourceDefinition.SERVER_ADDRESS.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value"), model, (XMLStreamReader)reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(model);
    }

    private static void parseFileElement(ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    PathResourceDefinition.PATH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PathResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseFormatter(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PATTERN_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser.addOperationAddress(operation, address, PatternFormatterResourceDefinition.PATTERN_FORMATTER.getName(), name);
                    LoggingSubsystemParser.parsePatternFormatterElement(reader, operation);
                    operations.add(operation);
                    continue block8;
                }
                case CUSTOM_FORMATTER: {
                    ModelNode operation = Util.createAddOperation();
                    LoggingSubsystemParser.addOperationAddress(operation, address, CustomFormatterResourceDefinition.CUSTOM_FORMATTER.getName(), name);
                    LoggingSubsystemParser.parseCustomFormatterElement(reader, operation);
                    operations.add(operation);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseHandlerFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        boolean formatterDefined = false;
        block4: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATTERN_FORMATTER: {
                    if (formatterDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName());
                    formatterDefined = true;
                    AbstractHandlerDefinition.FORMATTER.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName()), operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case NAMED_FORMATTER: {
                    if (formatterDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    formatterDefined = true;
                    AbstractHandlerDefinition.NAMED_FORMATTER.parseAndSetParameter(LoggingSubsystemParser.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parsePatternFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    PatternFormatterResourceDefinition.PATTERN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case COLOR_MAP: {
                    PatternFormatterResourceDefinition.COLOR_MAP.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseCustomFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CLASS, Attribute.MODULE);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLASS: {
                    CommonAttributes.CLASS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case MODULE: {
                    CommonAttributes.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block8: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    LoggingSubsystemParser.parsePropertyElement(operation, reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parsePropertyElement(ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            int cnt = reader.getAttributeCount();
            String name = null;
            String value = null;
            block5: for (int i = 0; i < cnt; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block5;
                    }
                    case VALUE: {
                        value = attrValue;
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
            }
            node.get(CommonAttributes.PROPERTIES.getName()).add(name, new ModelNode(value));
            if (reader.nextTag() == 2) continue;
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseHandlersElement(ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HANDLER: {
                    node.add(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseLoggingProfilesElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list) throws XMLStreamException {
        HashSet<String> profileNames = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGING_PROFILE: {
                    LoggingSubsystemParser.parseLoggingProfileElement(reader, address, list, profileNames);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseLoggingProfileElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> list, Set<String> profileNames) throws XMLStreamException {
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!profileNames.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        PathAddress profileAddress = address.append("logging-profile", name);
        list.add(Util.createAddOperation((PathAddress)profileAddress));
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> formatterOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        HashSet<String> formatterNames = new HashSet<String>();
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        boolean gotRoot = false;
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGER: {
                    LoggingSubsystemParser.parseLoggerElement(reader, profileAddress, loggerOperations, loggerNames);
                    continue block16;
                }
                case ROOT_LOGGER: {
                    if (gotRoot) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    gotRoot = true;
                    LoggingSubsystemParser.parseRootLoggerElement(reader, profileAddress, loggerOperations);
                    continue block16;
                }
                case CONSOLE_HANDLER: {
                    LoggingSubsystemParser.parseConsoleHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case FILE_HANDLER: {
                    LoggingSubsystemParser.parseFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case CUSTOM_HANDLER: {
                    LoggingSubsystemParser.parseCustomHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    LoggingSubsystemParser.parsePeriodicRotatingFileHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    LoggingSubsystemParser.parseSizeRotatingHandlerElement(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case ASYNC_HANDLER: {
                    LoggingSubsystemParser.parseAsyncHandlerElement(reader, profileAddress, asyncHandlerOperations, handlerNames);
                    continue block16;
                }
                case SYSLOG_HANDLER: {
                    LoggingSubsystemParser.parseSyslogHandler(reader, profileAddress, handlerOperations, handlerNames);
                    continue block16;
                }
                case FORMATTER: {
                    if (namespace == Namespace.LOGGING_1_2 || namespace == Namespace.LOGGING_1_3) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    LoggingSubsystemParser.parseFormatter(reader, profileAddress, formatterOperations, formatterNames);
                    continue block16;
                }
            }
            reader.handleAny(list);
        }
        list.addAll(formatterOperations);
        list.addAll(handlerOperations);
        list.addAll(asyncHandlerOperations);
        list.addAll(loggerOperations);
    }

    private static void parseFilter(Namespace namespace, ModelNode node, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (namespace == Namespace.LOGGING_1_0 || namespace == Namespace.LOGGING_1_1) {
            if (reader.getAttributeCount() > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            StringBuilder filter = new StringBuilder();
            LoggingSubsystemParser.parseFilterChildren(filter, false, reader);
            node.get(CommonAttributes.FILTER_SPEC.getName()).set(filter.toString());
        } else {
            CommonAttributes.FILTER_SPEC.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName()), node, (XMLStreamReader)reader);
        }
    }

    private static void parseFilterChildren(StringBuilder filter, boolean useDelimiter, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        int delimiter = 44;
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPT: {
                    filter.append("accept");
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case ALL: {
                    filter.append("all").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case ANY: {
                    filter.append("any").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case CHANGE_LEVEL: {
                    filter.append("levelChange").append('(').append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.NEW_LEVEL.getName())).append(')');
                    break;
                }
                case DENY: {
                    filter.append("deny");
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case LEVEL: {
                    filter.append("levels").append('(').append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.NAME.getName())).append(')');
                    break;
                }
                case LEVEL_RANGE: {
                    filter.append("levelRange");
                    boolean minInclusive = Boolean.parseBoolean(reader.getAttributeValue(null, CommonAttributes.MIN_INCLUSIVE.getName()));
                    boolean maxInclusive = Boolean.parseBoolean(reader.getAttributeValue(null, CommonAttributes.MAX_INCLUSIVE.getName()));
                    if (minInclusive) {
                        filter.append('[');
                    } else {
                        filter.append('(');
                    }
                    filter.append(reader.getAttributeValue(null, CommonAttributes.MIN_LEVEL.getName())).append(',');
                    filter.append(reader.getAttributeValue(null, CommonAttributes.MAX_LEVEL.getName()));
                    if (maxInclusive) {
                        filter.append(']');
                    } else {
                        filter.append(')');
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    break;
                }
                case MATCH: {
                    filter.append("match").append("(\"").append(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.FILTER_PATTERN.getName())).append("\")");
                    break;
                }
                case NOT: {
                    filter.append("not").append('(');
                    LoggingSubsystemParser.parseFilterChildren(filter, true, reader);
                    int index = filter.length() - 1;
                    if (filter.charAt(index) == ',') {
                        filter.setCharAt(index, ')');
                        break;
                    }
                    filter.append(')');
                    break;
                }
                case REPLACE: {
                    boolean replaceAll = Boolean.valueOf(reader.getAttributeValue(null, CommonAttributes.REPLACE_ALL.getName()));
                    if (replaceAll) {
                        filter.append("substituteAll");
                    } else {
                        filter.append("substitute");
                    }
                    filter.append("(\"").append(reader.getAttributeValue(null, CommonAttributes.FILTER_PATTERN.getName())).append('\"').append(',').append('\"').append(reader.getAttributeValue(null, CommonAttributes.REPLACEMENT.getName())).append("\")");
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            if (!useDelimiter) continue;
            filter.append(',');
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        List profiles;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        LoggingResourceDefinition.ADD_LOGGING_API_DEPENDENCIES.marshallAsElement(node, false, (XMLStreamWriter)writer);
        this.writeContent(writer, node);
        if (node.hasDefined("logging-profile") && !(profiles = node.get("logging-profile").asPropertyList()).isEmpty()) {
            writer.writeStartElement("logging-profiles");
            for (Property profile : profiles) {
                String name = profile.getName();
                writer.writeStartElement("logging-profile");
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                this.writeContent(writer, profile.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void writeContent(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        ModelNode handler;
        String name;
        ModelNode handlers;
        if (node.hasDefined("async-handler")) {
            handlers = node.get("async-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeAsynchHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("console-handler")) {
            handlers = node.get("console-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeConsoleHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("file-handler")) {
            handlers = node.get("file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("custom-handler")) {
            handlers = node.get("custom-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeCustomHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("periodic-rotating-file-handler")) {
            handlers = node.get("periodic-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writePeriodicRotatingFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("periodic-size-rotating-file-handler")) {
            handlers = node.get("periodic-size-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writePeriodicSizeRotatingFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("size-rotating-file-handler")) {
            handlers = node.get("size-rotating-file-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSizeRotatingFileHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("syslog-handler")) {
            handlers = node.get("syslog-handler");
            for (Property handlerProp : handlers.asPropertyList()) {
                name = handlerProp.getName();
                handler = handlerProp.getValue();
                if (!handler.isDefined()) continue;
                this.writeSyslogHandler(writer, handler, name);
            }
        }
        if (node.hasDefined("logger")) {
            for (String name2 : node.get("logger").keys()) {
                this.writeLogger(writer, name2, node.get(new String[]{"logger", name2}));
            }
        }
        if (node.hasDefined("root-logger")) {
            this.writeRootLogger(writer, node.get(new String[]{"root-logger", "ROOT"}));
        }
        this.writeFormatters(writer, (AttributeDefinition)PatternFormatterResourceDefinition.PATTERN_FORMATTER, node);
        this.writeFormatters(writer, (AttributeDefinition)CustomFormatterResourceDefinition.CUSTOM_FORMATTER, node);
    }

    private void writeCommonLogger(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        CommonAttributes.LEVEL.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.HANDLERS.marshallAsElement(node, (XMLStreamWriter)writer);
    }

    private void writeCommonHandler(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        CommonAttributes.LEVEL.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.ENCODING.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(node, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.FORMATTER.marshallAsElement(node, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.NAMED_FORMATTER.marshallAsElement(node, (XMLStreamWriter)writer);
    }

    private void writeConsoleHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CONSOLE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, node);
        ConsoleHandlerResourceDefinition.TARGET.marshallAsElement(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.FILE_HANDLER.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, node);
        CommonAttributes.FILE.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeCustomHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.CUSTOM_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.CLASS.marshallAsAttribute(node, (XMLStreamWriter)writer);
        CommonAttributes.MODULE.marshallAsAttribute(node, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, node);
        CommonAttributes.PROPERTIES.marshallAsElement(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writePeriodicRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.PERIODIC_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, node);
        CommonAttributes.FILE.marshallAsElement(node, (XMLStreamWriter)writer);
        PeriodicHandlerResourceDefinition.SUFFIX.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writePeriodicSizeRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode model, String name) throws XMLStreamException {
        writer.writeStartElement(Element.PERIODIC_SIZE_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(model, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.marshallAsAttribute(model, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, model);
        CommonAttributes.FILE.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.marshallAsElement(model, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.marshallAsElement(model, (XMLStreamWriter)writer);
        PeriodicHandlerResourceDefinition.SUFFIX.marshallAsElement(model, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeSizeRotatingFileHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SIZE_ROTATING_FILE_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.AUTOFLUSH.marshallAsAttribute(node, (XMLStreamWriter)writer);
        CommonAttributes.ENABLED.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_ON_BOOT.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        this.writeCommonHandler(writer, node);
        CommonAttributes.FILE.marshallAsElement(node, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.marshallAsElement(node, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.APPEND.marshallAsElement(node, (XMLStreamWriter)writer);
        SizeRotatingHandlerResourceDefinition.SUFFIX.marshallAsElement(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeSyslogHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.SYSLOG_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.ENABLED.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        CommonAttributes.LEVEL.marshallAsElement(node, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.SERVER_ADDRESS.marshallAsElement(node, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.HOSTNAME.marshallAsElement(node, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.PORT.marshallAsElement(node, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.APP_NAME.marshallAsElement(node, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.SYSLOG_FORMATTER.marshallAsElement(node, (XMLStreamWriter)writer);
        SyslogHandlerResourceDefinition.FACILITY.marshallAsElement(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeAsynchHandler(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
        writer.writeStartElement(Element.ASYNC_HANDLER.getLocalName());
        writer.writeAttribute(CommonAttributes.HANDLER_NAME.getXmlName(), name);
        CommonAttributes.ENABLED.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        CommonAttributes.LEVEL.marshallAsElement(node, (XMLStreamWriter)writer);
        CommonAttributes.FILTER_SPEC.marshallAsElement(node, (XMLStreamWriter)writer);
        AbstractHandlerDefinition.FORMATTER.marshallAsElement(node, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.QUEUE_LENGTH.marshallAsElement(node, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.OVERFLOW_ACTION.marshallAsElement(node, (XMLStreamWriter)writer);
        AsyncHandlerResourceDefinition.SUBHANDLERS.marshallAsElement(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeLogger(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.LOGGER.getLocalName());
        writer.writeAttribute(LoggerResourceDefinition.CATEGORY.getXmlName(), name);
        LoggerResourceDefinition.USE_PARENT_HANDLERS.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeCommonLogger(writer, node);
        writer.writeEndElement();
    }

    private void writeRootLogger(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.ROOT_LOGGER.getLocalName());
        this.writeCommonLogger(writer, node);
        writer.writeEndElement();
    }

    private void writeFormatters(XMLExtendedStreamWriter writer, AttributeDefinition attribute, ModelNode model) throws XMLStreamException {
        if (model.hasDefined(attribute.getName())) {
            for (String name : model.get(attribute.getName()).keys()) {
                writer.writeStartElement(Element.FORMATTER.getLocalName());
                writer.writeAttribute(CommonAttributes.NAME.getXmlName(), name);
                ModelNode value = model.get(new String[]{attribute.getName(), name});
                attribute.marshallAsElement(value, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private static void addOperationAddress(ModelNode operation, PathAddress base, String key, String value) {
        operation.get("address").set(base.append(key, value).toModelNode());
    }

    private static String readNameAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
    }

    private static String readValueAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"value");
    }
}

