/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.component.interceptors;

import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.component.CmpEntityBeanComponentInstance;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.bridge.CMRMessage;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.logging.Logger;

public class CmpEntityBeanJdbcRelationshipInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(CmpEntityBeanJdbcRelationshipInterceptor.class);
    private static final CmpEntityBeanJdbcRelationshipInterceptor INSTANCE = new CmpEntityBeanJdbcRelationshipInterceptor();
    public static final InterceptorFactory FACTORY = new InterceptorFactory(){

        public Interceptor create(InterceptorFactoryContext context) {
            return INSTANCE;
        }
    };

    public Object processInvocation(InterceptorContext context) throws Exception {
        CMRMessage relationshipMessage = (CMRMessage)((Object)context.getPrivateData(CMRMessage.class));
        if (relationshipMessage == null) {
            return context.proceed();
        }
        CmpEntityBeanComponentInstance instance = (CmpEntityBeanComponentInstance)((Object)context.getPrivateData(ComponentInstance.class));
        CmpEntityBeanContext ctx = instance.getEjbContext();
        JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)context.getParameters()[0];
        if (CMRMessage.GET_RELATED_ID == relationshipMessage) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Getting related id: field=" + cmrField.getFieldName() + " id=" + ctx.getPrimaryKeyUnchecked()));
            }
            return cmrField.getRelatedId(ctx);
        }
        if (CMRMessage.ADD_RELATION == relationshipMessage) {
            Object relatedId = context.getParameters()[1];
            if (log.isTraceEnabled()) {
                log.trace((Object)("Add relation: field=" + cmrField.getFieldName() + " id=" + ctx.getPrimaryKeyUnchecked() + " relatedId=" + relatedId));
            }
            cmrField.addRelation(ctx, relatedId);
            return null;
        }
        if (CMRMessage.REMOVE_RELATION == relationshipMessage) {
            Object relatedId = context.getParameters()[1];
            if (log.isTraceEnabled()) {
                log.trace((Object)("Remove relation: field=" + cmrField.getFieldName() + " id=" + ctx.getPrimaryKeyUnchecked() + " relatedId=" + relatedId));
            }
            cmrField.removeRelation(ctx, relatedId);
            return null;
        }
        if (CMRMessage.SCHEDULE_FOR_CASCADE_DELETE == relationshipMessage) {
            JDBCEntityBridge entity = (JDBCEntityBridge)cmrField.getEntity();
            entity.scheduleForCascadeDelete(ctx);
            return null;
        }
        if (CMRMessage.SCHEDULE_FOR_BATCH_CASCADE_DELETE == relationshipMessage) {
            JDBCEntityBridge entity = (JDBCEntityBridge)cmrField.getEntity();
            entity.scheduleForBatchCascadeDelete(ctx);
            return null;
        }
        throw CmpMessages.MESSAGES.unknownCmpRelationshipMessage(relationshipMessage);
    }
}

