/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentUndeployHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "undeploy";
    private final AbstractVaultReader vaultReader;

    public DeploymentUndeployHandler(AbstractVaultReader vaultReader) {
        this.vaultReader = vaultReader;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        String deploymentUnitName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, model).asString();
        model.get(DeploymentAttributes.ENABLED.getName()).set(false);
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String managementName = address.getLastElement().getValue();
        DeploymentHandlerUtil.undeploy(context, managementName, deploymentUnitName, this.vaultReader);
        context.stepCompleted();
    }
}

