/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.util.Util;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplicationMap
extends BaseContextMap {
    private final ServletContext servletContext;

    ApplicationMap(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void clear() {
        Enumeration enumeration = this.servletContext.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.servletContext.removeAttribute((String)enumeration.nextElement());
        }
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.servletContext.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object get(Object object) {
        Util.notNull("key", object);
        return this.servletContext.getAttribute(object.toString());
    }

    @Override
    public Object put(Object object, Object object2) {
        Util.notNull("key", object);
        Object object3 = this.servletContext.getAttribute(object.toString());
        this.servletContext.setAttribute(object.toString(), object2);
        return object3;
    }

    @Override
    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        Object object2 = this.servletContext.getAttribute(string);
        this.servletContext.removeAttribute(string);
        return object2;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.servletContext.getAttribute(object.toString()) != null;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof ApplicationMap && super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 7 * this.servletContext.hashCode();
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += ((Object)iterator.next()).hashCode();
        }
        return n;
    }

    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this.servletContext.getAttributeNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this.servletContext.getAttributeNames());
    }

    protected Iterator<Object> getValueIterator() {
        return new BaseContextMap.ValueIterator(this.servletContext.getAttributeNames());
    }
}

