/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.NoRowAvailableException;

public class ScalarDataModel
extends DataModel {
    private int index;
    private Object scalar;

    public ScalarDataModel() {
        this(null);
    }

    public ScalarDataModel(Object object) {
        this.setWrappedData(object);
    }

    public boolean isRowAvailable() {
        if (this.scalar == null) {
            return false;
        }
        return this.index == 0;
    }

    public int getRowCount() {
        if (this.scalar == null) {
            return -1;
        }
        return 1;
    }

    public Object getRowData() {
        if (this.scalar == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return this.scalar;
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        int n2 = this.index;
        this.index = n;
        if (this.scalar == null) {
            return;
        }
        DataModelListener[] dataModelListenerArray = this.getDataModelListeners();
        if (n2 != this.index && dataModelListenerArray != null) {
            Object object = null;
            if (this.isRowAvailable()) {
                object = this.getRowData();
            }
            DataModelEvent dataModelEvent = new DataModelEvent(this, this.index, object);
            int n3 = dataModelListenerArray.length;
            for (int i = 0; i < n3; ++i) {
                if (null == dataModelListenerArray[i]) continue;
                dataModelListenerArray[i].rowSelected(dataModelEvent);
            }
        }
    }

    public Object getWrappedData() {
        return this.scalar;
    }

    public void setWrappedData(Object object) {
        if (object == null) {
            this.scalar = null;
            this.setRowIndex(-1);
        } else {
            this.scalar = object;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

