/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.modcluster.ContextHost;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterDefinition;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ModClusterStop
implements OperationStepHandler {
    static final ModClusterStop INSTANCE = new ModClusterStop();

    static OperationDefinition getDefinition(ResourceDescriptionResolver descriptionResolver) {
        return new SimpleOperationDefinitionBuilder("stop", descriptionResolver).addParameter((AttributeDefinition)ModClusterDefinition.WAIT_TIME).setRuntimeOnly().build();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ModClusterService.NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    final ModCluster modcluster = (ModCluster)controller.getValue();
                    ModelNode dummyOp = new ModelNode();
                    if (operation.hasDefined("waittime")) {
                        dummyOp.get("waittime").set(ContextHost.RemoveQuotes(operation.get("waittime").asString()));
                    }
                    int waittime = ModClusterDefinition.WAIT_TIME.resolveModelAttribute(context, dummyOp).asInt();
                    modcluster.stop(waittime);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            modcluster.enable();
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

