/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.metrics;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.metrics.PicketLinkSubsystemMetrics;
import org.wildfly.extension.picketlink.federation.service.PicketLinkFederationService;

public abstract class AbstractPicketLinkMetricsOperationHandler
implements OperationStepHandler {
    protected static final SimpleAttributeDefinition ERROR_RESPONSE_TO_SP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_ERROR_RESPONSE_TO_SP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition ERROR_SIGN_VALIDATION_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_ERROR_SIGN_VALIDATION_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition ERROR_TRUSTED_DOMAIN_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_ERROR_TRUSTED_DOMAIN_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition EXPIRED_ASSERTIONS_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_EXPIRED_ASSERTIONS_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition LOGIN_INIT_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_LOGIN_INIT_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition LOGIN_COMPLETE_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_LOGIN_COMPLETE_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition REQUEST_FROM_IDP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_REQUEST_FROM_IDP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition RESPONSE_FROM_IDP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_RESPONSE_FROM_IDP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition REQUEST_TO_IDP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_REQUEST_TO_IDP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition CREATED_ASSERTIONS_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_CREATED_ASSERTIONS_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();
    protected static final SimpleAttributeDefinition RESPONSE_TO_SP_COUNT = new SimpleAttributeDefinitionBuilder(ModelElement.METRICS_RESPONSE_TO_SP_COUNT.getName(), ModelType.INT, true).setStorageRuntime().build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                String name = address.getLastElement().getValue();
                String attributeName = operation.require("name").asString();
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(AbstractPicketLinkMetricsOperationHandler.this.createServiceName(name));
                try {
                    PicketLinkFederationService service = (PicketLinkFederationService)controller.getValue();
                    AbstractPicketLinkMetricsOperationHandler.this.doPopulateResult(service.getMetrics(), context.getResult(), attributeName);
                }
                catch (Exception e) {
                    throw new OperationFailedException(new ModelNode().set(PicketLinkMessages.MESSAGES.failedToGetMetrics(e.getMessage())));
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void doPopulateResult(PicketLinkSubsystemMetrics metrics, ModelNode result, String attributeName) {
    }

    protected abstract ServiceName createServiceName(String var1);
}

