/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.common.model.validator;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.PicketLinkMessages;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;

public class AlternativeAttributeValidationStepHandler
implements ModelValidationStepHandler {
    private final AttributeDefinition[] attributes;
    private final boolean required;

    public AlternativeAttributeValidationStepHandler(AttributeDefinition[] attributes) {
        this(attributes, true);
    }

    public AlternativeAttributeValidationStepHandler(AttributeDefinition[] attributes, boolean required) {
        this.attributes = attributes;
        this.required = required;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validateAlternatives(context, operation);
        context.stepCompleted();
    }

    protected void validateAlternatives(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode elementNode = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ModelNode definedAttribute = null;
        for (AttributeDefinition attribute : this.attributes) {
            if (!elementNode.hasDefined(attribute.getName())) continue;
            if (definedAttribute != null) {
                throw PicketLinkMessages.MESSAGES.invalidAlternativeAttributeOccurrence(attribute.getName(), address.getLastElement().toString(), this.getAttributeNames());
            }
            definedAttribute = attribute.resolveModelAttribute(context, elementNode);
        }
        if (this.required && definedAttribute == null) {
            throw PicketLinkMessages.MESSAGES.requiredAlternativeAttributes(address.getLastElement().toString(), this.getAttributeNames());
        }
    }

    private String getAttributeNames() {
        StringBuilder builder = new StringBuilder();
        for (AttributeDefinition alternativeAttribute : this.attributes) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(alternativeAttribute.getName());
        }
        return builder.toString();
    }
}

