/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.arguments;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.QuotesState;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.as.cli.parsing.arguments.ExpressionValueState;

public class NonObjectArgumentValueState
extends DefaultParsingState {
    public static final String ID = "ARG_VALUE";
    public static final NonObjectArgumentValueState INSTANCE = new NonObjectArgumentValueState();

    public NonObjectArgumentValueState() {
        super(ID);
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                char ch = ctx.getCharacter();
                switch (ch) {
                    case '\"': {
                        ctx.enterState(QuotesState.QUOTES_EXCLUDED);
                        break;
                    }
                    case '$': {
                        ctx.enterState(ExpressionValueState.INSTANCE);
                        break;
                    }
                    default: {
                        ctx.getCallbackHandler().character(ctx);
                    }
                }
            }
        });
        this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
        this.enterState('\"', QuotesState.QUOTES_INCLUDED);
        this.enterState('$', ExpressionValueState.INSTANCE);
    }
}

