/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.spatial.DistanceUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.MultiValueSource;
import org.apache.solr.search.function.ValueSource;

public class VectorDistanceFunction
extends ValueSource {
    protected MultiValueSource source1;
    protected MultiValueSource source2;
    protected float power;
    protected float oneOverPower;

    public VectorDistanceFunction(float power, MultiValueSource source1, MultiValueSource source2) {
        if (source1.dimension() != source2.dimension()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal number of sources");
        }
        this.power = power;
        this.oneOverPower = 1.0f / power;
        this.source1 = source1;
        this.source2 = source2;
    }

    protected String name() {
        return "dist";
    }

    protected double distance(int doc, DocValues dv1, DocValues dv2) {
        double[] vals1 = new double[this.source1.dimension()];
        double[] vals2 = new double[this.source1.dimension()];
        dv1.doubleVal(doc, vals1);
        dv2.doubleVal(doc, vals2);
        return DistanceUtils.vectorDistance((double[])vals1, (double[])vals2, (double)this.power, (double)this.oneOverPower);
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals1 = this.source1.getValues(context, reader);
        final DocValues vals2 = this.source2.getValues(context, reader);
        return new DocValues(){

            @Override
            public byte byteVal(int doc) {
                return (byte)this.doubleVal(doc);
            }

            @Override
            public short shortVal(int doc) {
                return (short)this.doubleVal(doc);
            }

            @Override
            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.doubleVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.doubleVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return VectorDistanceFunction.this.distance(doc, vals1, vals2);
            }

            @Override
            public String strVal(int doc) {
                return Double.toString(this.doubleVal(doc));
            }

            @Override
            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(VectorDistanceFunction.this.name()).append('(').append(VectorDistanceFunction.this.power).append(',');
                boolean firstTime = true;
                sb.append(vals1.toString(doc)).append(',');
                sb.append(vals2.toString(doc));
                sb.append(')');
                return sb.toString();
            }
        };
    }

    @Override
    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.source1.createWeight(context, searcher);
        this.source2.createWeight(context, searcher);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VectorDistanceFunction)) {
            return false;
        }
        VectorDistanceFunction that = (VectorDistanceFunction)o;
        if (Float.compare(that.power, this.power) != 0) {
            return false;
        }
        if (!this.source1.equals(that.source1)) {
            return false;
        }
        return this.source2.equals(that.source2);
    }

    @Override
    public int hashCode() {
        int result = this.source1.hashCode();
        result = 31 * result + this.source2.hashCode();
        result = 31 * result + Float.floatToRawIntBits(this.power);
        return result;
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(').append(this.power).append(',');
        sb.append(this.source1).append(',');
        sb.append(this.source2);
        sb.append(')');
        return sb.toString();
    }
}

