/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;

public class FloatFieldSource
extends FieldCacheSource {
    protected FieldCache.FloatParser parser;

    public FloatFieldSource(String field) {
        this(field, null);
    }

    public FloatFieldSource(String field, FieldCache.FloatParser parser) {
        super(field);
        this.parser = parser;
    }

    @Override
    public String description() {
        return "float(" + this.field + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final float[] arr = this.parser == null ? this.cache.getFloats(reader, this.field) : this.cache.getFloats(reader, this.field, this.parser);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return arr[doc];
            }

            @Override
            public int intVal(int doc) {
                return (int)arr[doc];
            }

            @Override
            public long longVal(int doc) {
                return (long)arr[doc];
            }

            @Override
            public double doubleVal(int doc) {
                return arr[doc];
            }

            @Override
            public String strVal(int doc) {
                return Float.toString(arr[doc]);
            }

            @Override
            public String toString(int doc) {
                return FloatFieldSource.this.description() + '=' + this.floatVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != FloatFieldSource.class) {
            return false;
        }
        FloatFieldSource other = (FloatFieldSource)o;
        return super.equals(other) && (this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass());
    }

    @Override
    public int hashCode() {
        int h = this.parser == null ? Float.class.hashCode() : this.parser.getClass().hashCode();
        return h += super.hashCode();
    }
}

