/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.ReaderUtil;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.request.UnInvertedField;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.DocSetDelegateCollector;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.FilterImpl;
import org.apache.solr.search.LuceneQueryOptimizer;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.QueryResultKey;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrSortField;
import org.apache.solr.search.SortedIntDocSet;
import org.apache.solr.search.WrappedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexSearcher
extends IndexSearcher
implements SolrInfoMBean {
    public static final AtomicLong numOpens = new AtomicLong();
    public static final AtomicLong numCloses = new AtomicLong();
    private static Logger log = LoggerFactory.getLogger(SolrIndexSearcher.class);
    private final SolrCore core;
    private final IndexSchema schema;
    private String indexDir;
    private final String name;
    private long openTime = System.currentTimeMillis();
    private long registerTime = 0L;
    private long warmupTime = 0L;
    private final SolrIndexReader reader = (SolrIndexReader)super.getIndexReader();
    private final boolean closeReader;
    private final int queryResultWindowSize;
    private final int queryResultMaxDocsCached;
    private final boolean useFilterForSortedQuery;
    public final boolean enableLazyFieldLoading;
    private final boolean cachingEnabled;
    private final SolrCache<Query, DocSet> filterCache;
    private final SolrCache<QueryResultKey, DocList> queryResultCache;
    private final SolrCache<Integer, Document> documentCache;
    private final SolrCache<String, Object> fieldValueCache;
    private final LuceneQueryOptimizer optimizer;
    private final HashMap<String, SolrCache> cacheMap;
    private static final HashMap<String, SolrCache> noGenericCaches = new HashMap(0);
    private final SolrCache[] cacheList;
    private static final SolrCache[] noCaches = new SolrCache[0];
    private final Collection<String> fieldNames;
    private Collection<String> storedHighlightFieldNames;
    private static Query matchAllDocsQuery = new MatchAllDocsQuery();
    private static Comparator<Query> sortByCost = new Comparator<Query>(){

        @Override
        public int compare(Query q1, Query q2) {
            return ((ExtendedQuery)q1).getCost() - ((ExtendedQuery)q2).getCost();
        }
    };
    private static final int NO_CHECK_QCACHE = Integer.MIN_VALUE;
    public static final int GET_DOCSET = 0x40000000;
    private static final int NO_CHECK_FILTERCACHE = 0x20000000;
    private static final int NO_SET_QCACHE = 0x10000000;
    public static final int GET_DOCLIST = 2;
    public static final int GET_SCORES = 1;

    @Deprecated
    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, String path, boolean enableCache) throws IOException {
        this(core, schema, name, core.getIndexReaderFactory().newReader(core.getDirectoryFactory().open(path), false), true, enableCache);
    }

    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, Directory directory, boolean enableCache) throws IOException {
        this(core, schema, name, core.getIndexReaderFactory().newReader(directory, false), true, enableCache);
    }

    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, Directory directory, boolean readOnly, boolean enableCache) throws IOException {
        this(core, schema, name, core.getIndexReaderFactory().newReader(directory, readOnly), true, enableCache);
    }

    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, IndexReader r, boolean enableCache) {
        this(core, schema, name, r, false, enableCache);
    }

    private static SolrIndexReader wrap(IndexReader r) {
        SolrIndexReader sir;
        if (!(r instanceof SolrIndexReader)) {
            sir = new SolrIndexReader(r, null, 0);
            sir.associateInfo(null);
        } else {
            sir = (SolrIndexReader)r;
        }
        return sir;
    }

    public SolrIndexSearcher(SolrCore core, IndexSchema schema, String name, IndexReader r, boolean closeReader, boolean enableCache) {
        super((IndexReader)SolrIndexSearcher.wrap(r));
        this.core = core;
        this.schema = schema;
        this.name = "Searcher@" + Integer.toHexString(this.hashCode()) + (name != null ? " " + name : "");
        log.info("Opening " + this.name);
        SolrIndexReader.setSearcher(this.reader, this);
        if (r.directory() instanceof FSDirectory) {
            FSDirectory fsDirectory = (FSDirectory)r.directory();
            this.indexDir = fsDirectory.getDirectory().getAbsolutePath();
        }
        this.closeReader = closeReader;
        this.setSimilarity(schema.getSimilarity());
        SolrConfig solrConfig = core.getSolrConfig();
        this.queryResultWindowSize = solrConfig.queryResultWindowSize;
        this.queryResultMaxDocsCached = solrConfig.queryResultMaxDocsCached;
        this.useFilterForSortedQuery = solrConfig.useFilterForSortedQuery;
        this.enableLazyFieldLoading = solrConfig.enableLazyFieldLoading;
        this.cachingEnabled = enableCache;
        if (this.cachingEnabled) {
            ArrayList<SolrCache> clist = new ArrayList<SolrCache>();
            SolrCache<String, Object> solrCache = this.fieldValueCache = solrConfig.fieldValueCacheConfig == null ? null : solrConfig.fieldValueCacheConfig.newInstance();
            if (this.fieldValueCache != null) {
                clist.add(this.fieldValueCache);
            }
            SolrCache<Query, DocSet> solrCache2 = this.filterCache = solrConfig.filterCacheConfig == null ? null : solrConfig.filterCacheConfig.newInstance();
            if (this.filterCache != null) {
                clist.add(this.filterCache);
            }
            SolrCache<QueryResultKey, DocList> solrCache3 = this.queryResultCache = solrConfig.queryResultCacheConfig == null ? null : solrConfig.queryResultCacheConfig.newInstance();
            if (this.queryResultCache != null) {
                clist.add(this.queryResultCache);
            }
            SolrCache<Integer, Document> solrCache4 = this.documentCache = solrConfig.documentCacheConfig == null ? null : solrConfig.documentCacheConfig.newInstance();
            if (this.documentCache != null) {
                clist.add(this.documentCache);
            }
            if (solrConfig.userCacheConfigs == null) {
                this.cacheMap = noGenericCaches;
            } else {
                this.cacheMap = new HashMap(solrConfig.userCacheConfigs.length);
                for (CacheConfig userCacheConfig : solrConfig.userCacheConfigs) {
                    SolrCache cache = null;
                    if (userCacheConfig != null) {
                        cache = userCacheConfig.newInstance();
                    }
                    if (cache == null) continue;
                    this.cacheMap.put(cache.name(), cache);
                    clist.add(cache);
                }
            }
            this.cacheList = clist.toArray(new SolrCache[clist.size()]);
        } else {
            this.filterCache = null;
            this.queryResultCache = null;
            this.documentCache = null;
            this.fieldValueCache = null;
            this.cacheMap = noGenericCaches;
            this.cacheList = noCaches;
        }
        this.optimizer = null;
        this.fieldNames = new HashSet<String>();
        for (FieldInfo fieldInfo : ReaderUtil.getMergedFieldInfos((IndexReader)r)) {
            this.fieldNames.add(fieldInfo.name);
        }
        numOpens.incrementAndGet();
    }

    public String toString() {
        return this.name;
    }

    public SolrCore getCore() {
        return this.core;
    }

    public void register() {
        this.core.getInfoRegistry().put("searcher", this);
        this.core.getInfoRegistry().put(this.name, this);
        for (SolrCache cache : this.cacheList) {
            cache.setState(SolrCache.State.LIVE);
            this.core.getInfoRegistry().put(cache.name(), cache);
        }
        this.registerTime = System.currentTimeMillis();
    }

    public void close() throws IOException {
        if (this.cachingEnabled) {
            StringBuilder sb = new StringBuilder();
            sb.append("Closing ").append(this.name);
            for (SolrCache cache : this.cacheList) {
                sb.append("\n\t");
                sb.append(cache);
            }
            log.info(sb.toString());
        } else {
            log.debug("Closing " + this.name);
        }
        this.core.getInfoRegistry().remove(this.name);
        if (this.closeReader) {
            this.reader.decRef();
        }
        for (SolrCache cache : this.cacheList) {
            cache.close();
        }
        numCloses.incrementAndGet();
    }

    public SolrIndexReader getReader() {
        return this.reader;
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public Collection<String> getFieldNames() {
        return this.fieldNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getStoredHighlightFieldNames() {
        SolrIndexSearcher solrIndexSearcher = this;
        synchronized (solrIndexSearcher) {
            if (this.storedHighlightFieldNames == null) {
                this.storedHighlightFieldNames = new LinkedList<String>();
                for (String fieldName : this.fieldNames) {
                    try {
                        SchemaField field = this.schema.getField(fieldName);
                        if (!field.stored() || !(field.getType() instanceof TextField) && !(field.getType() instanceof StrField)) continue;
                        this.storedHighlightFieldNames.add(fieldName);
                    }
                    catch (RuntimeException e) {
                        log.warn("Field \"" + fieldName + "\" found in index, but not defined in schema.");
                    }
                }
            }
            return this.storedHighlightFieldNames;
        }
    }

    public static void initRegenerators(SolrConfig solrConfig) {
        if (solrConfig.fieldValueCacheConfig != null && solrConfig.fieldValueCacheConfig.getRegenerator() == null) {
            solrConfig.fieldValueCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
                    if (oldVal instanceof UnInvertedField) {
                        UnInvertedField.getUnInvertedField((String)oldKey, newSearcher);
                    }
                    return true;
                }
            });
        }
        if (solrConfig.filterCacheConfig != null && solrConfig.filterCacheConfig.getRegenerator() == null) {
            solrConfig.filterCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
                    newSearcher.cacheDocSet((Query)oldKey, null, false);
                    return true;
                }
            });
        }
        if (solrConfig.queryResultCacheConfig != null && solrConfig.queryResultCacheConfig.getRegenerator() == null) {
            final int queryResultWindowSize = solrConfig.queryResultWindowSize;
            solrConfig.queryResultCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache newCache, SolrCache oldCache, Object oldKey, Object oldVal) throws IOException {
                    QueryResultKey key = (QueryResultKey)oldKey;
                    int nDocs = 1;
                    if (queryResultWindowSize <= 1) {
                        DocList oldList = (DocList)oldVal;
                        int oldnDocs = oldList.offset() + oldList.size();
                        nDocs = Math.min(oldnDocs, 40);
                    }
                    int flags = Integer.MIN_VALUE | key.nc_flags;
                    QueryCommand qc = new QueryCommand();
                    qc.setQuery(key.query).setFilterList(key.filters).setSort(key.sort).setLen(nDocs).setSupersetMaxDoc(nDocs).setFlags(flags);
                    QueryResult qr = new QueryResult();
                    newSearcher.getDocListC(qr, qc);
                    return true;
                }
            });
        }
    }

    public QueryResult search(QueryResult qr, QueryCommand cmd) throws IOException {
        this.getDocListC(qr, cmd);
        return qr;
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public Document doc(int i) throws IOException {
        return this.doc(i, (Set<String>)null);
    }

    public Document doc(int n, FieldSelector fieldSelector) throws IOException {
        return this.getIndexReader().document(n, fieldSelector);
    }

    public Document doc(int i, Set<String> fields) throws IOException {
        Document d;
        if (this.documentCache != null && (d = this.documentCache.get(i)) != null) {
            return d;
        }
        d = !this.enableLazyFieldLoading || fields == null ? this.getIndexReader().document(i) : this.getIndexReader().document(i, (FieldSelector)new SetNonLazyFieldSelector(fields));
        if (this.documentCache != null) {
            this.documentCache.put(i, d);
        }
        return d;
    }

    public void readDocs(Document[] docs, DocList ids) throws IOException {
        this.readDocs(docs, ids, null);
    }

    public void readDocs(Document[] docs, DocList ids, Set<String> fields) throws IOException {
        DocIterator iter = ids.iterator();
        for (int i = 0; i < docs.length; ++i) {
            docs[i] = this.doc(iter.nextDoc(), fields);
        }
    }

    public SolrCache getFieldValueCache() {
        return this.fieldValueCache;
    }

    public Sort weightSort(Sort sort) throws IOException {
        if (sort == null) {
            return null;
        }
        SortField[] sorts = sort.getSort();
        boolean needsWeighting = false;
        for (SortField sf : sorts) {
            if (!(sf instanceof SolrSortField)) continue;
            needsWeighting = true;
            break;
        }
        if (!needsWeighting) {
            return sort;
        }
        SortField[] newSorts = (SortField[])sorts.clone();
        for (int i = 0; i < newSorts.length; ++i) {
            if (!(newSorts[i] instanceof SolrSortField)) continue;
            newSorts[i] = ((SolrSortField)newSorts[i]).weight(this);
        }
        return new Sort(newSorts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstMatch(Term t) throws IOException {
        TermDocs tdocs = null;
        try {
            tdocs = this.reader.termDocs(t);
            if (!tdocs.next()) {
                int n = -1;
                return n;
            }
            int n = tdocs.doc();
            return n;
        }
        finally {
            if (tdocs != null) {
                tdocs.close();
            }
        }
    }

    public void cacheDocSet(Query query, DocSet optionalAnswer, boolean mustCache) throws IOException {
        if (optionalAnswer != null) {
            if (this.filterCache != null) {
                this.filterCache.put(query, optionalAnswer);
            }
            return;
        }
        this.getDocSet(query);
    }

    public DocSet getDocSet(Query query) throws IOException {
        DocSet answer;
        DocSet absAnswer;
        boolean positive;
        ExtendedQuery eq;
        if (query instanceof ExtendedQuery && !(eq = (ExtendedQuery)query).getCache()) {
            if (query instanceof WrappedQuery) {
                query = ((WrappedQuery)query).getWrappedQuery();
            }
            query = QueryUtils.makeQueryable(query);
            return this.getDocSetNC(query, null);
        }
        Query absQ = QueryUtils.getAbs(query);
        boolean bl = positive = query == absQ;
        if (this.filterCache != null && (absAnswer = this.filterCache.get(absQ)) != null) {
            if (positive) {
                return absAnswer;
            }
            return this.getPositiveDocSet(matchAllDocsQuery).andNot(absAnswer);
        }
        absAnswer = this.getDocSetNC(absQ, null);
        DocSet docSet = answer = positive ? absAnswer : this.getPositiveDocSet(matchAllDocsQuery).andNot(absAnswer);
        if (this.filterCache != null) {
            this.filterCache.put(absQ, absAnswer);
        }
        return answer;
    }

    DocSet getPositiveDocSet(Query q) throws IOException {
        DocSet answer;
        if (this.filterCache != null && (answer = this.filterCache.get(q)) != null) {
            return answer;
        }
        answer = this.getDocSetNC(q, null);
        if (this.filterCache != null) {
            this.filterCache.put(q, answer);
        }
        return answer;
    }

    public DocSet getPositiveDocSet(Query q, TermDocsState tdState) throws IOException {
        DocSet answer;
        if (this.filterCache != null && (answer = this.filterCache.get(q)) != null) {
            return answer;
        }
        answer = this.getDocSetNC(q, null, tdState);
        if (this.filterCache != null) {
            this.filterCache.put(q, answer);
        }
        return answer;
    }

    public DocSet getDocSet(List<Query> queries) throws IOException {
        ProcessedFilter pf = this.getProcessedFilter(null, queries);
        if (pf.answer != null) {
            return pf.answer;
        }
        DocSetCollector setCollector = new DocSetCollector(this.maxDoc() >> 6, this.maxDoc());
        Collector collector = setCollector;
        if (pf.postFilter != null) {
            pf.postFilter.setLastDelegate(collector);
            collector = pf.postFilter;
        }
        SolrIndexReader[] leaves = this.reader.getLeafReaders();
        int[] offsets = this.reader.getLeafOffsets();
        for (int i = 0; i < leaves.length; ++i) {
            SolrIndexReader subReader = leaves[i];
            int baseDoc = offsets[i];
            DocIdSet idSet = null;
            if (pf.filter != null && (idSet = pf.filter.getDocIdSet((IndexReader)subReader)) == null) continue;
            DocIdSetIterator idIter = null;
            if (idSet != null && (idIter = idSet.iterator()) == null) continue;
            collector.setNextReader((IndexReader)subReader, baseDoc);
            int max = subReader.maxDoc();
            if (idIter == null) {
                TermDocs tdocs = subReader.termDocs(null);
                while (tdocs.next()) {
                    int docid = tdocs.doc();
                    collector.collect(docid);
                }
                continue;
            }
            int docid = -1;
            while ((docid = idIter.advance(docid + 1)) < max) {
                if (subReader.isDeleted(docid)) continue;
                collector.collect(docid);
            }
        }
        return setCollector.getDocSet();
    }

    public ProcessedFilter getProcessedFilter(DocSet setFilter, List<Query> queries) throws IOException {
        int i;
        ProcessedFilter pf = new ProcessedFilter();
        if (queries == null || queries.size() == 0) {
            if (setFilter != null) {
                pf.filter = setFilter.getTopFilter();
            }
            return pf;
        }
        DocSet answer = null;
        boolean[] neg = new boolean[queries.size() + 1];
        DocSet[] sets = new DocSet[queries.size() + 1];
        ArrayList<Query> notCached = null;
        ArrayList<Query> postFilters = null;
        int end = 0;
        int smallestIndex = -1;
        if (setFilter != null) {
            int n = end++;
            DocSet docSet = setFilter;
            sets[n] = docSet;
            answer = docSet;
            smallestIndex = end;
        }
        int smallestCount = Integer.MAX_VALUE;
        for (Query q : queries) {
            ExtendedQuery eq;
            if (q instanceof ExtendedQuery && !(eq = (ExtendedQuery)q).getCache()) {
                if (eq.getCost() >= 100 && eq instanceof PostFilter) {
                    if (postFilters == null) {
                        postFilters = new ArrayList<Query>(sets.length - end);
                    }
                    postFilters.add(q);
                    continue;
                }
                if (notCached == null) {
                    notCached = new ArrayList<Query>(sets.length - end);
                }
                notCached.add(q);
                continue;
            }
            Query posQuery = QueryUtils.getAbs(q);
            sets[end] = this.getPositiveDocSet(posQuery);
            if (q == posQuery) {
                neg[end] = false;
                int sz = sets[end].size();
                if (sz < smallestCount) {
                    smallestCount = sz;
                    smallestIndex = end;
                    answer = sets[end];
                }
            } else {
                neg[end] = true;
            }
            ++end;
        }
        if (end > 0 && answer == null) {
            answer = this.getPositiveDocSet(matchAllDocsQuery);
        }
        for (i = 0; i < end; ++i) {
            if (!neg[i]) continue;
            answer = answer.andNot(sets[i]);
        }
        for (i = 0; i < end; ++i) {
            if (neg[i] || i == smallestIndex) continue;
            answer = answer.intersection(sets[i]);
        }
        if (notCached != null) {
            Collections.sort(notCached, sortByCost);
            ArrayList<Weight> weights = new ArrayList<Weight>(notCached.size());
            for (Query q : notCached) {
                Query qq = QueryUtils.makeQueryable(q);
                weights.add(this.createNormalizedWeight(qq));
            }
            pf.filter = new FilterImpl(answer, weights);
        } else {
            if (postFilters == null) {
                if (answer == null) {
                    answer = this.getPositiveDocSet(matchAllDocsQuery);
                }
                pf.answer = answer;
            }
            if (answer != null) {
                pf.filter = answer.getTopFilter();
            }
        }
        if (postFilters != null) {
            Collections.sort(postFilters, sortByCost);
            for (int i2 = postFilters.size() - 1; i2 >= 0; --i2) {
                DelegatingCollector prev = pf.postFilter;
                pf.postFilter = ((PostFilter)postFilters.get(i2)).getFilterCollector(this);
                if (prev == null) continue;
                pf.postFilter.setDelegate(prev);
            }
        }
        return pf;
    }

    protected DocSet getDocSetNC(Query query, DocSet filter) throws IOException {
        DocSetCollector collector = new DocSetCollector(this.maxDoc() >> 6, this.maxDoc());
        if (filter == null) {
            if (query instanceof TermQuery) {
                Term t = ((TermQuery)query).getTerm();
                SolrIndexReader[] readers = this.reader.getLeafReaders();
                int[] offsets = this.reader.getLeafOffsets();
                int[] arr = new int[256];
                int[] freq = new int[256];
                for (int i = 0; i < readers.length; ++i) {
                    int num;
                    SolrIndexReader sir = readers[i];
                    int offset = offsets[i];
                    collector.setNextReader((IndexReader)sir, offset);
                    TermDocs tdocs = sir.termDocs(t);
                    while ((num = tdocs.read(arr, freq)) != 0) {
                        for (int j = 0; j < num; ++j) {
                            collector.collect(arr[j]);
                        }
                    }
                    tdocs.close();
                }
            } else {
                super.search(query, null, (Collector)collector);
            }
            return collector.getDocSet();
        }
        Filter luceneFilter = filter.getTopFilter();
        super.search(query, luceneFilter, (Collector)collector);
        return collector.getDocSet();
    }

    protected DocSet getDocSetNC(Query query, DocSet filter, TermDocsState tdState) throws IOException {
        int num;
        int smallSetSize = this.maxDoc() >> 6;
        int largestPossible = tdState.tenum.docFreq();
        int[] docs = new int[Math.min(smallSetSize, largestPossible)];
        OpenBitSet obs = null;
        int upto = 0;
        int numBits = 0;
        if (tdState.tdocs == null) {
            tdState.tdocs = this.reader.termDocs();
        }
        tdState.tdocs.seek(tdState.tenum);
        int[] arr = new int[Math.min(largestPossible, 256)];
        int[] freq = new int[arr.length];
        while ((num = tdState.tdocs.read(arr, freq)) != 0) {
            if (upto + num > docs.length) {
                if (obs == null) {
                    obs = new OpenBitSet((long)this.maxDoc());
                }
                for (int i = 0; i < num; ++i) {
                    obs.fastSet(arr[i]);
                }
                numBits += num;
                continue;
            }
            System.arraycopy(arr, 0, docs, upto, num);
            upto += num;
        }
        if (obs != null) {
            for (int i = 0; i < upto; ++i) {
                obs.fastSet(docs[i]);
            }
            return new BitDocSet(obs, numBits += upto);
        }
        return new SortedIntDocSet(docs, upto);
    }

    public DocSet getDocSet(Query query, DocSet filter) throws IOException {
        boolean positive;
        ExtendedQuery eq;
        if (filter == null) {
            return this.getDocSet(query);
        }
        if (query instanceof ExtendedQuery && !(eq = (ExtendedQuery)query).getCache()) {
            if (query instanceof WrappedQuery) {
                query = ((WrappedQuery)query).getWrappedQuery();
            }
            query = QueryUtils.makeQueryable(query);
            return this.getDocSetNC(query, filter);
        }
        Query absQ = QueryUtils.getAbs(query);
        boolean bl = positive = absQ == query;
        if (this.filterCache != null) {
            DocSet first = this.filterCache.get(absQ);
            if (first == null) {
                first = this.getDocSetNC(absQ, null);
                this.filterCache.put(absQ, first);
            }
            return positive ? first.intersection(filter) : filter.andNot(first);
        }
        return positive ? this.getDocSetNC(absQ, filter) : filter.andNot(this.getPositiveDocSet(absQ));
    }

    public DocSet convertFilter(Filter lfilter) throws IOException {
        int doc;
        DocIdSet docSet = lfilter.getDocIdSet((IndexReader)this.reader);
        OpenBitSet obs = new OpenBitSet();
        DocIdSetIterator it = docSet.iterator();
        while ((doc = it.nextDoc()) != Integer.MAX_VALUE) {
            obs.fastSet(doc);
        }
        return new BitDocSet(obs);
    }

    public DocList getDocList(Query query, Query filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    public DocList getDocList(Query query, List<Query> filterList, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    private void getDocListC(QueryResult qr, QueryCommand cmd) throws IOException {
        ExtendedQuery eq;
        DocListAndSet out = new DocListAndSet();
        qr.setDocListAndSet(out);
        QueryResultKey key = null;
        int maxDocRequested = cmd.getOffset() + cmd.getLen();
        if (maxDocRequested < 0 || maxDocRequested > this.maxDoc()) {
            maxDocRequested = this.maxDoc();
        }
        int supersetMaxDoc = maxDocRequested;
        DocList superset = null;
        int flags = cmd.getFlags();
        Query q = cmd.getQuery();
        if (q instanceof ExtendedQuery && !(eq = (ExtendedQuery)q).getCache()) {
            flags |= 0xB0000000;
        }
        if (this.queryResultCache != null && cmd.getFilter() == null && (flags & 0x90000000) != -1879048192) {
            key = new QueryResultKey(q, cmd.getFilterList(), cmd.getSort(), flags);
            if ((flags & Integer.MIN_VALUE) == 0) {
                superset = this.queryResultCache.get(key);
                if (superset != null && ((flags & 1) == 0 || superset.hasScores())) {
                    out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
                }
                if (out.docList != null) {
                    if (out.docSet == null && (flags & 0x40000000) != 0) {
                        if (cmd.getFilterList() == null) {
                            out.docSet = this.getDocSet(cmd.getQuery());
                        } else {
                            ArrayList<Query> newList = new ArrayList<Query>(cmd.getFilterList().size() + 1);
                            newList.add(cmd.getQuery());
                            newList.addAll(cmd.getFilterList());
                            out.docSet = this.getDocSet(newList);
                        }
                    }
                    return;
                }
            }
            if ((flags & 0x10000000) == 0) {
                if (maxDocRequested < this.queryResultWindowSize) {
                    supersetMaxDoc = this.queryResultWindowSize;
                } else {
                    supersetMaxDoc = ((maxDocRequested - 1) / this.queryResultWindowSize + 1) * this.queryResultWindowSize;
                    if (supersetMaxDoc < 0) {
                        supersetMaxDoc = maxDocRequested;
                    }
                }
            } else {
                key = null;
            }
        }
        boolean useFilterCache = false;
        if ((flags & 0x20000001) == 0 && this.useFilterForSortedQuery && cmd.getSort() != null && this.filterCache != null) {
            SortField[] sfields;
            useFilterCache = true;
            for (SortField sf : sfields = cmd.getSort().getSort()) {
                if (sf.getType() != 0) continue;
                useFilterCache = false;
                break;
            }
        }
        if (useFilterCache) {
            if (out.docSet == null) {
                out.docSet = this.getDocSet(cmd.getQuery(), cmd.getFilter());
                DocSet bigFilt = this.getDocSet(cmd.getFilterList());
                if (bigFilt != null) {
                    out.docSet = out.docSet.intersection(bigFilt);
                }
            }
            superset = this.sortDocSet(out.docSet, cmd.getSort(), supersetMaxDoc);
            out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
        } else {
            cmd.setSupersetMaxDoc(supersetMaxDoc);
            if ((flags & 0x40000000) != 0) {
                DocSet qDocSet = this.getDocListAndSetNC(qr, cmd);
                if (qDocSet != null && this.filterCache != null && !qr.isPartialResults()) {
                    this.filterCache.put(cmd.getQuery(), qDocSet);
                }
            } else {
                this.getDocListNC(qr, cmd);
            }
            superset = out.docList;
            out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
        }
        if (key != null && superset.size() <= this.queryResultMaxDocsCached && !qr.isPartialResults()) {
            this.queryResultCache.put(key, superset);
        }
    }

    private void getDocListNC(QueryResult qr, QueryCommand cmd) throws IOException {
        float maxScore;
        int totalHits;
        float[] scores;
        int[] ids;
        int nDocsReturned;
        long timeAllowed = cmd.getTimeAllowed();
        int len = cmd.getSupersetMaxDoc();
        int last = len;
        if (last < 0 || last > this.maxDoc()) {
            last = this.maxDoc();
        }
        int lastDocRequested = last;
        boolean needScores = (cmd.getFlags() & 1) != 0;
        Query query = QueryUtils.makeQueryable(cmd.getQuery());
        ProcessedFilter pf = this.getProcessedFilter(cmd.getFilter(), cmd.getFilterList());
        Filter luceneFilter = pf.filter;
        if (lastDocRequested <= 0) {
            final float[] topscore = new float[]{Float.NEGATIVE_INFINITY};
            final int[] numHits = new int[1];
            Collector collector = !needScores ? new Collector(){

                public void setScorer(Scorer scorer) throws IOException {
                }

                public void collect(int doc) throws IOException {
                    numHits[0] = numHits[0] + 1;
                }

                public void setNextReader(IndexReader reader, int docBase) throws IOException {
                }

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }
            } : new Collector(){
                Scorer scorer;

                public void setScorer(Scorer scorer) throws IOException {
                    this.scorer = scorer;
                }

                public void collect(int doc) throws IOException {
                    numHits[0] = numHits[0] + 1;
                    float score = this.scorer.score();
                    if (score > topscore[0]) {
                        topscore[0] = score;
                    }
                }

                public void setNextReader(IndexReader reader, int docBase) throws IOException {
                }

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }
            };
            if (timeAllowed > 0L) {
                collector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), timeAllowed);
            }
            if (pf.postFilter != null) {
                pf.postFilter.setLastDelegate(collector);
                collector = pf.postFilter;
            }
            try {
                super.search(query, luceneFilter, collector);
            }
            catch (TimeLimitingCollector.TimeExceededException x) {
                log.warn("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            nDocsReturned = 0;
            ids = new int[nDocsReturned];
            scores = new float[nDocsReturned];
            totalHits = numHits[0];
            maxScore = totalHits > 0 ? topscore[0] : 0.0f;
        } else {
            Object topCollector = cmd.getSort() == null ? TopScoreDocCollector.create((int)len, (boolean)true) : TopFieldCollector.create((Sort)this.weightSort(cmd.getSort()), (int)len, (boolean)false, (boolean)needScores, (boolean)needScores, (boolean)true);
            Object collector = topCollector;
            if (timeAllowed > 0L) {
                collector = new TimeLimitingCollector((Collector)collector, TimeLimitingCollector.getGlobalCounter(), timeAllowed);
            }
            if (pf.postFilter != null) {
                pf.postFilter.setLastDelegate((Collector)collector);
                collector = pf.postFilter;
            }
            try {
                super.search(query, luceneFilter, (Collector)collector);
            }
            catch (TimeLimitingCollector.TimeExceededException x) {
                log.warn("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            totalHits = topCollector.getTotalHits();
            TopDocs topDocs = topCollector.topDocs(0, len);
            maxScore = totalHits > 0 ? topDocs.getMaxScore() : 0.0f;
            nDocsReturned = topDocs.scoreDocs.length;
            ids = new int[nDocsReturned];
            scores = (cmd.getFlags() & 1) != 0 ? new float[nDocsReturned] : null;
            for (int i = 0; i < nDocsReturned; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                ids[i] = scoreDoc.doc;
                if (scores == null) continue;
                scores[i] = scoreDoc.score;
            }
        }
        int sliceLen = Math.min(lastDocRequested, nDocsReturned);
        if (sliceLen < 0) {
            sliceLen = 0;
        }
        qr.setDocList(new DocSlice(0, sliceLen, ids, scores, totalHits, maxScore));
    }

    private DocSet getDocListAndSetNC(QueryResult qr, QueryCommand cmd) throws IOException {
        float maxScore;
        int totalHits;
        float[] scores;
        int[] ids;
        int nDocsReturned;
        DocSet set;
        int len = cmd.getSupersetMaxDoc();
        int last = len;
        if (last < 0 || last > this.maxDoc()) {
            last = this.maxDoc();
        }
        int lastDocRequested = last;
        boolean needScores = (cmd.getFlags() & 1) != 0;
        int maxDoc = this.maxDoc();
        int smallSetSize = maxDoc >> 6;
        ProcessedFilter pf = this.getProcessedFilter(cmd.getFilter(), cmd.getFilterList());
        Filter luceneFilter = pf.filter;
        Query query = QueryUtils.makeQueryable(cmd.getQuery());
        long timeAllowed = cmd.getTimeAllowed();
        if (lastDocRequested <= 0) {
            Collector collector;
            DocSetCollector setCollector;
            final float[] topscore = new float[]{Float.NEGATIVE_INFINITY};
            if (!needScores) {
                setCollector = new DocSetCollector(smallSetSize, maxDoc);
                collector = setCollector;
            } else {
                setCollector = new DocSetDelegateCollector(smallSetSize, maxDoc, new Collector(){
                    Scorer scorer;

                    public void setScorer(Scorer scorer) throws IOException {
                        this.scorer = scorer;
                    }

                    public void collect(int doc) throws IOException {
                        float score = this.scorer.score();
                        if (score > topscore[0]) {
                            topscore[0] = score;
                        }
                    }

                    public void setNextReader(IndexReader reader, int docBase) throws IOException {
                    }

                    public boolean acceptsDocsOutOfOrder() {
                        return false;
                    }
                });
                collector = setCollector;
            }
            if (timeAllowed > 0L) {
                collector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), timeAllowed);
            }
            if (pf.postFilter != null) {
                pf.postFilter.setLastDelegate(collector);
                collector = pf.postFilter;
            }
            try {
                super.search(query, luceneFilter, collector);
            }
            catch (TimeLimitingCollector.TimeExceededException x) {
                log.warn("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            set = setCollector.getDocSet();
            nDocsReturned = 0;
            ids = new int[nDocsReturned];
            scores = new float[nDocsReturned];
            totalHits = set.size();
            maxScore = totalHits > 0 ? topscore[0] : 0.0f;
        } else {
            Object topCollector = cmd.getSort() == null ? TopScoreDocCollector.create((int)len, (boolean)true) : TopFieldCollector.create((Sort)this.weightSort(cmd.getSort()), (int)len, (boolean)false, (boolean)needScores, (boolean)needScores, (boolean)true);
            DocSetDelegateCollector setCollector = new DocSetDelegateCollector(maxDoc >> 6, maxDoc, (Collector)topCollector);
            Collector collector = setCollector;
            if (timeAllowed > 0L) {
                collector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), timeAllowed);
            }
            if (pf.postFilter != null) {
                pf.postFilter.setLastDelegate(collector);
                collector = pf.postFilter;
            }
            try {
                super.search(query, luceneFilter, collector);
            }
            catch (TimeLimitingCollector.TimeExceededException x) {
                log.warn("Query: " + query + "; " + x.getMessage());
                qr.setPartialResults(true);
            }
            set = ((DocSetCollector)setCollector).getDocSet();
            totalHits = topCollector.getTotalHits();
            assert (totalHits == set.size());
            TopDocs topDocs = topCollector.topDocs(0, len);
            maxScore = totalHits > 0 ? topDocs.getMaxScore() : 0.0f;
            nDocsReturned = topDocs.scoreDocs.length;
            ids = new int[nDocsReturned];
            scores = (cmd.getFlags() & 1) != 0 ? new float[nDocsReturned] : null;
            for (int i = 0; i < nDocsReturned; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                ids[i] = scoreDoc.doc;
                if (scores == null) continue;
                scores[i] = scoreDoc.score;
            }
        }
        int sliceLen = Math.min(lastDocRequested, nDocsReturned);
        if (sliceLen < 0) {
            sliceLen = 0;
        }
        qr.setDocList(new DocSlice(0, sliceLen, ids, scores, totalHits, maxScore));
        qr.setDocSet(set);
        return pf.filter == null && pf.postFilter == null ? qr.getDocSet() : null;
    }

    public DocList getDocList(Query query, DocSet filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocList();
    }

    public DocListAndSet getDocListAndSet(Query query, Query filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, Query filter, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, List<Query> filterList, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, List<Query> filterList, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, DocSet filter, Sort lsort, int offset, int len) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    public DocListAndSet getDocListAndSet(Query query, DocSet filter, Sort lsort, int offset, int len, int flags) throws IOException {
        QueryCommand qc = new QueryCommand();
        qc.setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true);
        QueryResult qr = new QueryResult();
        this.search(qr, qc);
        return qr.getDocListAndSet();
    }

    protected DocList sortDocSet(DocSet set, Sort sort, int nDocs) throws IOException {
        boolean inOrder = set instanceof BitDocSet || set instanceof SortedIntDocSet;
        TopFieldCollector topCollector = TopFieldCollector.create((Sort)this.weightSort(sort), (int)nDocs, (boolean)false, (boolean)false, (boolean)false, (boolean)inOrder);
        DocIterator iter = set.iterator();
        int base = 0;
        int end = 0;
        int readerIndex = -1;
        SolrIndexReader r = null;
        while (iter.hasNext()) {
            int doc = iter.nextDoc();
            while (doc >= end) {
                r = this.reader.getLeafReaders()[++readerIndex];
                base = this.reader.getLeafOffsets()[readerIndex];
                end = base + r.maxDoc();
                topCollector.setNextReader((IndexReader)r, base);
            }
            topCollector.collect(doc - base);
        }
        TopDocs topDocs = topCollector.topDocs(0, nDocs);
        int nDocsReturned = topDocs.scoreDocs.length;
        int[] ids = new int[nDocsReturned];
        for (int i = 0; i < nDocsReturned; ++i) {
            ScoreDoc scoreDoc = topDocs.scoreDocs[i];
            ids[i] = scoreDoc.doc;
        }
        return new DocSlice(0, nDocsReturned, ids, null, topDocs.totalHits, 0.0f);
    }

    public int numDocs(Query a, DocSet b) throws IOException {
        Query absQ = QueryUtils.getAbs(a);
        DocSet positiveA = this.getPositiveDocSet(absQ);
        return a == absQ ? b.intersectionSize(positiveA) : b.andNotSize(positiveA);
    }

    public int numDocs(Query a, Query b) throws IOException {
        Query absA = QueryUtils.getAbs(a);
        Query absB = QueryUtils.getAbs(b);
        DocSet positiveA = this.getPositiveDocSet(absA);
        DocSet positiveB = this.getPositiveDocSet(absB);
        if (a == absA) {
            if (b == absB) {
                return positiveA.intersectionSize(positiveB);
            }
            return positiveA.andNotSize(positiveB);
        }
        if (b == absB) {
            return positiveB.andNotSize(positiveA);
        }
        DocSet all = this.getPositiveDocSet(matchAllDocsQuery);
        return all.andNotSize(positiveA.union(positiveB));
    }

    public Document[] readDocs(DocList ids) throws IOException {
        Document[] docs = new Document[ids.size()];
        this.readDocs(docs, ids);
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warm(SolrIndexSearcher old) throws IOException {
        boolean logme = log.isInfoEnabled();
        long warmingStartTime = System.currentTimeMillis();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("warming", new String[]{"true"});
        for (int i = 0; i < this.cacheList.length; ++i) {
            if (logme) {
                log.info("autowarming " + this + " from " + old + "\n\t" + old.cacheList[i]);
            }
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.core, (SolrParams)params){

                @Override
                public SolrIndexSearcher getSearcher() {
                    return SolrIndexSearcher.this;
                }

                @Override
                public void close() {
                }
            };
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
            try {
                this.cacheList[i].warm(this, old.cacheList[i]);
            }
            finally {
                try {
                    req.close();
                }
                finally {
                    SolrRequestInfo.clearRequestInfo();
                }
            }
            if (!logme) continue;
            log.info("autowarming result for " + this + "\n\t" + this.cacheList[i]);
        }
        this.warmupTime = System.currentTimeMillis() - warmingStartTime;
    }

    public SolrCache getCache(String cacheName) {
        return this.cacheMap.get(cacheName);
    }

    public Object cacheLookup(String cacheName, Object key) {
        SolrCache cache = this.cacheMap.get(cacheName);
        return cache == null ? null : cache.get(key);
    }

    public Object cacheInsert(String cacheName, Object key, Object val) {
        SolrCache cache = this.cacheMap.get(cacheName);
        return cache == null ? null : cache.put(key, val);
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return super.explain(QueryUtils.makeQueryable(query), doc);
    }

    @Override
    public String getName() {
        return SolrIndexSearcher.class.getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "index searcher";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CORE;
    }

    @Override
    public String getSourceId() {
        return "$Id$";
    }

    @Override
    public String getSource() {
        return "$URL$";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("searcherName", (Object)this.name);
        lst.add("caching", (Object)this.cachingEnabled);
        lst.add("numDocs", (Object)this.reader.numDocs());
        lst.add("maxDoc", (Object)this.reader.maxDoc());
        lst.add("reader", (Object)this.reader.toString());
        lst.add("readerDir", (Object)this.reader.directory());
        lst.add("indexVersion", (Object)this.reader.getVersion());
        lst.add("openedAt", (Object)new Date(this.openTime));
        if (this.registerTime != 0L) {
            lst.add("registeredAt", (Object)new Date(this.registerTime));
        }
        lst.add("warmupTime", (Object)this.warmupTime);
        return lst;
    }

    public static class QueryResult {
        private boolean partialResults;
        private DocListAndSet docListAndSet;
        public Object groupedResults;

        public DocList getDocList() {
            return this.docListAndSet.docList;
        }

        public void setDocList(DocList list) {
            if (this.docListAndSet == null) {
                this.docListAndSet = new DocListAndSet();
            }
            this.docListAndSet.docList = list;
        }

        public DocSet getDocSet() {
            return this.docListAndSet.docSet;
        }

        public void setDocSet(DocSet set) {
            if (this.docListAndSet == null) {
                this.docListAndSet = new DocListAndSet();
            }
            this.docListAndSet.docSet = set;
        }

        public boolean isPartialResults() {
            return this.partialResults;
        }

        public void setPartialResults(boolean partialResults) {
            this.partialResults = partialResults;
        }

        public void setDocListAndSet(DocListAndSet listSet) {
            this.docListAndSet = listSet;
        }

        public DocListAndSet getDocListAndSet() {
            return this.docListAndSet;
        }
    }

    public static class QueryCommand {
        private Query query;
        private List<Query> filterList;
        private DocSet filter;
        private Sort sort;
        private int offset;
        private int len;
        private int supersetMaxDoc;
        private int flags;
        private long timeAllowed = -1L;

        public Query getQuery() {
            return this.query;
        }

        public QueryCommand setQuery(Query query) {
            this.query = query;
            return this;
        }

        public List<Query> getFilterList() {
            return this.filterList;
        }

        public QueryCommand setFilterList(List<Query> filterList) {
            if (this.filter != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filterList = filterList;
            return this;
        }

        public QueryCommand setFilterList(Query f) {
            if (this.filter != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filterList = null;
            if (f != null) {
                this.filterList = new ArrayList<Query>(2);
                this.filterList.add(f);
            }
            return this;
        }

        public DocSet getFilter() {
            return this.filter;
        }

        public QueryCommand setFilter(DocSet filter) {
            if (this.filterList != null) {
                throw new IllegalArgumentException("Either filter or filterList may be set in the QueryCommand, but not both.");
            }
            this.filter = filter;
            return this;
        }

        public Sort getSort() {
            return this.sort;
        }

        public QueryCommand setSort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public int getOffset() {
            return this.offset;
        }

        public QueryCommand setOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public int getLen() {
            return this.len;
        }

        public QueryCommand setLen(int len) {
            this.len = len;
            return this;
        }

        public int getSupersetMaxDoc() {
            return this.supersetMaxDoc;
        }

        public QueryCommand setSupersetMaxDoc(int supersetMaxDoc) {
            this.supersetMaxDoc = supersetMaxDoc;
            return this;
        }

        public int getFlags() {
            return this.flags;
        }

        public QueryCommand replaceFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public QueryCommand setFlags(int flags) {
            this.flags |= flags;
            return this;
        }

        public QueryCommand clearFlags(int flags) {
            this.flags &= ~flags;
            return this;
        }

        public long getTimeAllowed() {
            return this.timeAllowed;
        }

        public QueryCommand setTimeAllowed(long timeAllowed) {
            this.timeAllowed = timeAllowed;
            return this;
        }

        public boolean isNeedDocSet() {
            return (this.flags & 0x40000000) != 0;
        }

        public QueryCommand setNeedDocSet(boolean needDocSet) {
            return needDocSet ? this.setFlags(0x40000000) : this.clearFlags(0x40000000);
        }
    }

    public static class TermDocsState {
        public TermEnum tenum;
        public TermDocs tdocs;
    }

    public static class ProcessedFilter {
        public DocSet answer;
        public Filter filter;
        public DelegatingCollector postFilter;
    }

    static class SetNonLazyFieldSelector
    implements FieldSelector {
        private Set<String> fieldsToLoad;

        SetNonLazyFieldSelector(Set<String> toLoad) {
            this.fieldsToLoad = toLoad;
        }

        public FieldSelectorResult accept(String fieldName) {
            if (this.fieldsToLoad.contains(fieldName)) {
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.LAZY_LOAD;
        }
    }
}

