/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.StringIndexDocValues;
import org.apache.solr.util.NumberUtils;

class SortableIntFieldSource
extends FieldCacheSource {
    protected int defVal;
    private static int hcode = SortableIntFieldSource.class.hashCode();

    public SortableIntFieldSource(String field) {
        this(field, 0);
    }

    public SortableIntFieldSource(String field, int defVal) {
        super(field);
        this.defVal = defVal;
    }

    @Override
    public String description() {
        return "sint(" + this.field + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final int def = this.defVal;
        return new StringIndexDocValues(this, reader, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return NumberUtils.int2sortableStr(readableValue);
            }

            @Override
            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public int intVal(int doc) {
                int ord = this.order[doc];
                return ord == 0 ? def : NumberUtils.SortableStr2int(this.lookup[ord], 0, 3);
            }

            @Override
            public long longVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Integer.toString(this.intVal(doc));
            }

            @Override
            public String toString(int doc) {
                return SortableIntFieldSource.this.description() + '=' + this.intVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SortableIntFieldSource && super.equals(o) && this.defVal == ((SortableIntFieldSource)o).defVal;
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode() + this.defVal;
    }
}

