/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BaseResponseWriter.class);
    private static final String SCORE_FIELD = "score";

    public void write(SingleResponseWriter responseWriter, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        responseWriter.start();
        NamedList nl = response.getValues();
        for (int i = 0; i < nl.size(); ++i) {
            String name = nl.getName(i);
            Object val = nl.getVal(i);
            if ("responseHeader".equals(name)) {
                Boolean omitHeader = request.getParams().getBool("omitHeader");
                if (omitHeader != null && omitHeader.booleanValue()) continue;
                responseWriter.writeResponseHeader((NamedList)val);
                continue;
            }
            if (val instanceof SolrDocumentList) {
                SolrDocumentList list = (SolrDocumentList)val;
                DocListInfo info = new DocListInfo((int)list.getNumFound(), list.size(), (int)list.getStart(), list.getMaxScore());
                if (responseWriter.isStreamingDocs()) {
                    responseWriter.startDocumentList(name, info);
                    for (SolrDocument solrDocument : list) {
                        responseWriter.writeDoc(solrDocument);
                    }
                    responseWriter.endDocumentList();
                    continue;
                }
                responseWriter.writeAllDocs(info, (List<SolrDocument>)list);
                continue;
            }
            if (val instanceof DocList) {
                DocList docList = (DocList)val;
                int sz = docList.size();
                IdxInfo idxInfo = new IdxInfo(request.getSchema(), request.getSearcher(), response.getReturnFields());
                DocListInfo info = new DocListInfo(docList.matches(), docList.size(), docList.offset(), Float.valueOf(docList.maxScore()));
                DocIterator iterator = docList.iterator();
                if (responseWriter.isStreamingDocs()) {
                    responseWriter.startDocumentList(name, info);
                    for (int j = 0; j < sz; ++j) {
                        SolrDocument sdoc = BaseResponseWriter.getDoc(iterator.nextDoc(), idxInfo);
                        if (idxInfo.includeScore && docList.hasScores()) {
                            sdoc.addField(SCORE_FIELD, (Object)Float.valueOf(iterator.score()));
                        }
                        responseWriter.writeDoc(sdoc);
                    }
                    continue;
                }
                ArrayList<SolrDocument> list = new ArrayList<SolrDocument>(docList.size());
                for (int j = 0; j < sz; ++j) {
                    SolrDocument sdoc = BaseResponseWriter.getDoc(iterator.nextDoc(), idxInfo);
                    if (idxInfo.includeScore && docList.hasScores()) {
                        sdoc.addField(SCORE_FIELD, (Object)Float.valueOf(iterator.score()));
                    }
                    list.add(sdoc);
                }
                responseWriter.writeAllDocs(info, list);
                continue;
            }
            responseWriter.writeOther(name, val);
        }
        responseWriter.end();
    }

    public void init(NamedList args) {
    }

    private static SolrDocument getDoc(int id, IdxInfo info) throws IOException {
        Document doc = info.searcher.doc(id);
        SolrDocument solrDoc = new SolrDocument();
        for (Fieldable f : doc.getFields()) {
            String fieldName = f.name();
            if (info.returnFields != null && !info.returnFields.contains(fieldName)) continue;
            SchemaField sf = info.schema.getFieldOrNull(fieldName);
            FieldType ft = null;
            if (sf != null) {
                ft = sf.getType();
            }
            Object val = null;
            if (ft == null) {
                val = f.isBinary() ? f.getBinaryValue() : (Object)f.stringValue();
            } else {
                try {
                    val = BinaryResponseWriter.KNOWN_TYPES.contains(ft.getClass()) ? (Object)ft.toObject(f) : (Object)ft.toExternal(f);
                }
                catch (Exception e) {
                    LOG.warn("Error reading a field from document : " + solrDoc, (Throwable)e);
                    continue;
                }
            }
            if (sf != null && sf.multiValued() && !solrDoc.containsKey((Object)fieldName)) {
                ArrayList<byte[]> l = new ArrayList<byte[]>();
                l.add((byte[])val);
                solrDoc.addField(fieldName, l);
                continue;
            }
            solrDoc.addField(fieldName, val);
        }
        return solrDoc;
    }

    public static abstract class SingleResponseWriter {
        public void start() throws IOException {
        }

        public void startDocumentList(String name, DocListInfo info) throws IOException {
        }

        public void writeDoc(SolrDocument solrDocument) throws IOException {
        }

        public void endDocumentList() throws IOException {
        }

        public void writeResponseHeader(NamedList responseHeader) throws IOException {
        }

        public void end() throws IOException {
        }

        public void writeOther(String name, Object other) throws IOException {
        }

        public boolean isStreamingDocs() {
            return true;
        }

        public void writeAllDocs(DocListInfo info, List<SolrDocument> allDocs) throws IOException {
        }
    }

    public static class DocListInfo {
        public final int numFound;
        public final int start;
        public Float maxScore = null;
        public final int size;

        public DocListInfo(int numFound, int sz, int start, Float maxScore) {
            this.numFound = numFound;
            this.size = sz;
            this.start = start;
            this.maxScore = maxScore;
        }
    }

    private static class IdxInfo {
        IndexSchema schema;
        SolrIndexSearcher searcher;
        Set<String> returnFields;
        boolean includeScore;

        private IdxInfo(IndexSchema schema, SolrIndexSearcher searcher, Set<String> returnFields) {
            this.schema = schema;
            this.searcher = searcher;
            boolean bl = this.includeScore = returnFields != null && returnFields.contains(BaseResponseWriter.SCORE_FIELD);
            if (returnFields != null && (returnFields.size() == 0 || returnFields.size() == 1 && this.includeScore || returnFields.contains("*"))) {
                returnFields = null;
            }
            this.returnFields = returnFields;
        }
    }
}

