/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class StemmerOverrideFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArrayMap<String> dictionary = null;
    private boolean ignoreCase;

    @Override
    public void inform(ResourceLoader loader) {
        String dictionaryFiles = (String)this.args.get("dictionary");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (dictionaryFiles != null) {
            this.assureMatchVersion();
            List files = StrUtils.splitFileNames((String)dictionaryFiles);
            try {
                if (files.size() > 0) {
                    this.dictionary = new CharArrayMap(this.luceneMatchVersion, files.size() * 10, this.ignoreCase);
                    for (String file : files) {
                        List list = loader.getLines(file.trim());
                        for (String line : list) {
                            String[] mapping = line.split("\t", 2);
                            this.dictionary.put(mapping[0], (Object)mapping[1]);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.dictionary == null ? input : new StemmerOverrideFilter(this.luceneMatchVersion, input, this.dictionary);
    }
}

