/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.HunspellDictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class HunspellStemFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private static final String PARAM_DICTIONARY = "dictionary";
    private static final String PARAM_AFFIX = "affix";
    private static final String PARAM_IGNORE_CASE = "ignoreCase";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private HunspellDictionary dictionary;
    private boolean ignoreCase = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void inform(ResourceLoader loader) {
        this.assureMatchVersion();
        String[] dictionaryFiles = ((String)this.args.get(PARAM_DICTIONARY)).split(",");
        String affixFile = (String)this.args.get(PARAM_AFFIX);
        String pic = (String)this.args.get(PARAM_IGNORE_CASE);
        if (pic != null) {
            if (pic.equalsIgnoreCase(TRUE)) {
                this.ignoreCase = true;
            } else {
                if (!pic.equalsIgnoreCase(FALSE)) throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Unknown value for ignoreCase: " + pic + ". Must be true or false");
                this.ignoreCase = false;
            }
        }
        InputStream affix = null;
        ArrayList<InputStream> dictionaries = new ArrayList<InputStream>();
        try {
            for (String file : dictionaryFiles) {
                dictionaries.add(loader.openResource(file));
            }
            affix = loader.openResource(affixFile);
            this.dictionary = new HunspellDictionary(affix, dictionaries, this.luceneMatchVersion, this.ignoreCase);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unable to load hunspell data! [dictionary=" + (String)this.args.get(PARAM_DICTIONARY) + ",affix=" + affixFile + "]", e);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affix});
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    IOUtils.closeWhileHandlingException(dictionaries);
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{affix});
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            IOUtils.closeWhileHandlingException(dictionaries);
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary);
    }
}

