/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

@Deprecated
final class FSTSynonymFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private SynonymMap map;
    private boolean ignoreCase;

    FSTSynonymFilterFactory() {
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.map.fst == null ? input : new SynonymFilter(input, this.map, this.ignoreCase);
    }

    @Override
    public void inform(ResourceLoader loader) {
        block5: {
            boolean ignoreCase;
            this.ignoreCase = ignoreCase = this.getBoolean("ignoreCase", false);
            String tf = (String)this.args.get("tokenizerFactory");
            final TokenizerFactory factory = tf == null ? null : FSTSynonymFilterFactory.loadTokenizerFactory(loader, tf, this.args);
            ReusableAnalyzerBase analyzer = new ReusableAnalyzerBase(){

                protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
                    WhitespaceTokenizer tokenizer = factory == null ? new WhitespaceTokenizer(Version.LUCENE_31, reader) : factory.create(reader);
                    WhitespaceTokenizer stream = ignoreCase ? new LowerCaseFilter(Version.LUCENE_31, (TokenStream)tokenizer) : tokenizer;
                    return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
                }
            };
            String format = (String)this.args.get("format");
            try {
                if (format == null || format.equals("solr")) {
                    this.map = this.loadSolrSynonyms(loader, true, (Analyzer)analyzer);
                    break block5;
                }
                if (format.equals("wordnet")) {
                    this.map = this.loadWordnetSynonyms(loader, true, (Analyzer)analyzer);
                    break block5;
                }
                throw new RuntimeException("Unrecognized synonyms format: " + format);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.map.fst == null) {
            log.warn("Synonyms loaded with " + this.args + " has empty rule set!");
        }
    }

    private SynonymMap loadSolrSynonyms(ResourceLoader loader, boolean dedup, Analyzer analyzer) throws IOException, ParseException {
        boolean expand = this.getBoolean("expand", true);
        String synonyms = (String)this.args.get("synonyms");
        if (synonyms == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required argument 'synonyms'.");
        }
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        SolrSynonymParser parser = new SolrSynonymParser(dedup, expand, analyzer);
        File synonymFile = new File(synonyms);
        if (synonymFile.exists()) {
            decoder.reset();
            parser.add((Reader)new InputStreamReader(loader.openResource(synonyms), decoder));
        } else {
            List files = StrUtils.splitFileNames((String)synonyms);
            for (String file : files) {
                decoder.reset();
                parser.add((Reader)new InputStreamReader(loader.openResource(file), decoder));
            }
        }
        return parser.build();
    }

    private SynonymMap loadWordnetSynonyms(ResourceLoader loader, boolean dedup, Analyzer analyzer) throws IOException, ParseException {
        boolean expand = this.getBoolean("expand", true);
        String synonyms = (String)this.args.get("synonyms");
        if (synonyms == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required argument 'synonyms'.");
        }
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        WordnetSynonymParser parser = new WordnetSynonymParser(dedup, expand, analyzer);
        File synonymFile = new File(synonyms);
        if (synonymFile.exists()) {
            decoder.reset();
            parser.add((Reader)new InputStreamReader(loader.openResource(synonyms), decoder));
        } else {
            List files = StrUtils.splitFileNames((String)synonyms);
            for (String file : files) {
                decoder.reset();
                parser.add((Reader)new InputStreamReader(loader.openResource(file), decoder));
            }
        }
        return parser.build();
    }

    private static TokenizerFactory loadTokenizerFactory(ResourceLoader loader, String cname, Map<String, String> args) {
        TokenizerFactory tokFactory = (TokenizerFactory)loader.newInstance(cname, new String[0]);
        tokFactory.init(args);
        if (tokFactory instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)((Object)tokFactory)).inform(loader);
        }
        return tokFactory;
    }
}

