/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.JGroupsLogger;
import org.jboss.as.clustering.jgroups.JGroupsMessages;
import org.jboss.as.clustering.jgroups.MuxChannel;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;

public class ChannelService
implements Service<Channel>,
ChannelListener {
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jgroups"}).append(new String[]{"channel"});
    private final Value<ChannelFactory> factory;
    private final String id;
    private volatile Channel channel;

    public static ServiceName getServiceName(String id) {
        return SERVICE_NAME.append(new String[]{id});
    }

    public ChannelService(String id, Value<ChannelFactory> factory) {
        this.id = id;
        this.factory = factory;
    }

    public Channel getValue() {
        return this.channel;
    }

    public void start(StartContext context) throws StartException {
        ChannelFactory factory = (ChannelFactory)this.factory.getValue();
        try {
            this.channel = factory.createChannel(this.id);
            this.channel.addChannelListener((ChannelListener)this);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        if (JGroupsLogger.ROOT_LOGGER.isTraceEnabled()) {
            String output = this.channel.getProtocolStack().printProtocolSpec(true);
            JGroupsLogger.ROOT_LOGGER.tracef("JGroups channel named %s created with configuration:\n %s", this.id, output);
        }
    }

    public void stop(StopContext context) {
        if (this.channel != null) {
            this.channel.removeChannelListener((ChannelListener)this);
            ((MuxChannel)this.channel).destroy();
        }
        this.channel = null;
    }

    public void channelClosed(Channel channel) {
    }

    public void channelConnected(Channel channel) {
        String localName = channel.getName();
        Address localAddress = channel.getAddress();
        for (Address address : channel.getView()) {
            String name = channel.getName(address);
            if (name == null || !name.equals(localName) || address.equals(localAddress)) continue;
            channel.close();
            throw JGroupsMessages.MESSAGES.duplicateNodeName(((ChannelFactory)this.factory.getValue()).getProtocolStackConfiguration().getEnvironment().getNodeName());
        }
    }

    public void channelDisconnected(Channel channel) {
    }
}

