/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MappedSuperclassType;
import javax.persistence.metamodel.Metamodel;
import org.hibernate.ejb.metamodel.EmbeddableTypeImpl;
import org.hibernate.ejb.metamodel.EntityTypeImpl;
import org.hibernate.ejb.metamodel.MappedSuperclassTypeImpl;
import org.hibernate.ejb.metamodel.MetadataContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;

public class MetamodelImpl
implements Metamodel,
Serializable {
    private final Map<Class<?>, EntityTypeImpl<?>> entities;
    private final Map<Class<?>, EmbeddableTypeImpl<?>> embeddables;
    private final Map<Class<?>, MappedSuperclassType<?>> mappedSuperclassTypeMap;
    private final Map<String, EntityTypeImpl<?>> entityTypesByEntityName;

    @Deprecated
    public static MetamodelImpl buildMetamodel(Iterator<PersistentClass> persistentClasses, SessionFactoryImplementor sessionFactory) {
        return MetamodelImpl.buildMetamodel(persistentClasses, sessionFactory, false);
    }

    public static MetamodelImpl buildMetamodel(Iterator<PersistentClass> persistentClasses, SessionFactoryImplementor sessionFactory, boolean ignoreUnsupported) {
        MetadataContext context = new MetadataContext(sessionFactory, ignoreUnsupported);
        while (persistentClasses.hasNext()) {
            PersistentClass pc = persistentClasses.next();
            MetamodelImpl.locateOrBuildEntityType(pc, context);
        }
        context.wrapUp();
        return new MetamodelImpl(context.getEntityTypeMap(), context.getEmbeddableTypeMap(), context.getMappedSuperclassTypeMap(), context.getEntityTypesByEntityName());
    }

    private static EntityTypeImpl<?> locateOrBuildEntityType(PersistentClass persistentClass, MetadataContext context) {
        EntityTypeImpl<?> entityType = context.locateEntityType(persistentClass);
        if (entityType == null) {
            entityType = MetamodelImpl.buildEntityType(persistentClass, context);
        }
        return entityType;
    }

    private static EntityTypeImpl<?> buildEntityType(PersistentClass persistentClass, MetadataContext context) {
        MappedSuperclassTypeImpl<?> superType;
        Class javaType = persistentClass.getMappedClass();
        context.pushEntityWorkedOn(persistentClass);
        MappedSuperclass superMappedSuperclass = persistentClass.getSuperMappedSuperclass();
        MappedSuperclassTypeImpl<?> mappedSuperclassTypeImpl = superType = superMappedSuperclass == null ? null : MetamodelImpl.locateOrBuildMappedsuperclassType(superMappedSuperclass, context);
        if (superType == null) {
            PersistentClass superPersistentClass = persistentClass.getSuperclass();
            superType = superPersistentClass == null ? null : MetamodelImpl.locateOrBuildEntityType(superPersistentClass, context);
        }
        EntityTypeImpl entityType = new EntityTypeImpl(javaType, superType, persistentClass.getJpaEntityName(), persistentClass.hasIdentifierProperty(), persistentClass.isVersioned());
        entityType.setTypeName(persistentClass.getEntityName());
        context.registerEntityType(persistentClass, entityType);
        context.popEntityWorkedOn(persistentClass);
        return entityType;
    }

    private static MappedSuperclassTypeImpl<?> locateOrBuildMappedsuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context) {
        MappedSuperclassTypeImpl<?> mappedSuperclassType = context.locateMappedSuperclassType(mappedSuperclass);
        if (mappedSuperclassType == null) {
            mappedSuperclassType = MetamodelImpl.buildMappedSuperclassType(mappedSuperclass, context);
        }
        return mappedSuperclassType;
    }

    private static MappedSuperclassTypeImpl<?> buildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context) {
        MappedSuperclassTypeImpl<?> superType;
        MappedSuperclass superMappedSuperclass = mappedSuperclass.getSuperMappedSuperclass();
        MappedSuperclassTypeImpl<?> mappedSuperclassTypeImpl = superType = superMappedSuperclass == null ? null : MetamodelImpl.locateOrBuildMappedsuperclassType(superMappedSuperclass, context);
        if (superType == null) {
            PersistentClass superPersistentClass = mappedSuperclass.getSuperPersistentClass();
            superType = superPersistentClass == null ? null : MetamodelImpl.locateOrBuildEntityType(superPersistentClass, context);
        }
        Class javaType = mappedSuperclass.getMappedClass();
        MappedSuperclassTypeImpl mappedSuperclassType = new MappedSuperclassTypeImpl(javaType, superType, mappedSuperclass.hasIdentifierProperty(), mappedSuperclass.isVersioned());
        context.registerMappedSuperclassType(mappedSuperclass, mappedSuperclassType);
        return mappedSuperclassType;
    }

    private MetamodelImpl(Map<Class<?>, EntityTypeImpl<?>> entities, Map<Class<?>, EmbeddableTypeImpl<?>> embeddables, Map<Class<?>, MappedSuperclassType<?>> mappedSuperclassTypeMap, Map<String, EntityTypeImpl<?>> entityTypesByEntityName) {
        this.entities = entities;
        this.embeddables = embeddables;
        this.mappedSuperclassTypeMap = mappedSuperclassTypeMap;
        this.entityTypesByEntityName = entityTypesByEntityName;
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        EntityType entityType = this.entities.get(cls);
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls);
        }
        return entityType;
    }

    public <X> ManagedType<X> managedType(Class<X> cls) {
        ManagedType type = this.entities.get(cls);
        if (type == null) {
            type = (ManagedType)this.mappedSuperclassTypeMap.get(cls);
        }
        if (type == null) {
            type = this.embeddables.get(cls);
        }
        if (type == null) {
            throw new IllegalArgumentException("Not an managed type: " + cls);
        }
        return type;
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        EmbeddableType embeddableType = this.embeddables.get(cls);
        if (embeddableType == null) {
            throw new IllegalArgumentException("Not an embeddable: " + cls);
        }
        return embeddableType;
    }

    public Set<ManagedType<?>> getManagedTypes() {
        int setSize = CollectionHelper.determineProperSizing((int)(this.entities.size() + this.mappedSuperclassTypeMap.size() + this.embeddables.size()));
        HashSet managedTypes = new HashSet(setSize);
        managedTypes.addAll(this.entities.values());
        managedTypes.addAll(this.mappedSuperclassTypeMap.values());
        managedTypes.addAll(this.embeddables.values());
        return managedTypes;
    }

    public Set<EntityType<?>> getEntities() {
        return new HashSet(this.entityTypesByEntityName.values());
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return new HashSet(this.embeddables.values());
    }
}

