/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.result.SimpleRowValue;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.TableView;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class Table
extends SchemaObjectBase {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_MEMORY = 1;
    public static final String TABLE_LINK = "TABLE LINK";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String EXTERNAL_TABLE_ENGINE = "EXTERNAL";
    protected Column[] columns;
    protected CompareMode compareMode;
    protected boolean isHidden;
    private final HashMap<String, Column> columnMap;
    private boolean persistIndexes;
    private boolean persistData;
    private ArrayList<TriggerObject> triggers;
    private ArrayList<Constraint> constraints;
    private ArrayList<Sequence> sequences;
    private ArrayList<TableView> views;
    private boolean checkForeignKeyConstraints = true;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Row nullRow;

    public Table(Schema schema, int id, String name, boolean persistIndexes, boolean persistData) {
        this.columnMap = schema.getDatabase().newStringMap();
        this.initSchemaObjectBase(schema, id, name, "table");
        this.persistIndexes = persistIndexes;
        this.persistData = persistData;
        this.compareMode = schema.getDatabase().getCompareMode();
    }

    @Override
    public void rename(String newName) {
        super.rename(newName);
        if (this.constraints != null) {
            int size = this.constraints.size();
            for (int i = 0; i < size; ++i) {
                Constraint constraint = this.constraints.get(i);
                constraint.rebuild();
            }
        }
    }

    public abstract void lock(Session var1, boolean var2, boolean var3);

    public abstract void close(Session var1);

    public abstract void unlock(Session var1);

    public abstract Index addIndex(Session var1, String var2, int var3, IndexColumn[] var4, IndexType var5, boolean var6, String var7);

    public abstract void removeRow(Session var1, Row var2);

    public abstract void truncate(Session var1);

    public abstract void addRow(Session var1, Row var2);

    public void commit(short operation, Row row) {
    }

    public abstract void checkSupportAlter();

    public abstract String getTableType();

    public abstract Index getScanIndex(Session var1);

    public abstract Index getUniqueIndex();

    public abstract ArrayList<Index> getIndexes();

    public abstract boolean isLockedExclusively();

    public abstract long getMaxDataModificationId();

    public abstract boolean isDeterministic();

    public abstract boolean canGetRowCount();

    public boolean canReference() {
        return true;
    }

    public abstract boolean canDrop();

    public abstract long getRowCount(Session var1);

    public abstract long getRowCountApproximation();

    public Column getRowIdColumn() {
        return null;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError();
    }

    public void addDependencies(HashSet<DbObject> dependencies) {
        if (dependencies.contains(this)) {
            return;
        }
        if (this.sequences != null) {
            for (Sequence s : this.sequences) {
                dependencies.add(s);
            }
        }
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        for (Column col : this.columns) {
            col.isEverything(visitor);
        }
        if (this.constraints != null) {
            for (Constraint c : this.constraints) {
                c.isEverything(visitor);
            }
        }
        dependencies.add(this);
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> children = New.arrayList();
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            children.addAll(indexes);
        }
        if (this.constraints != null) {
            children.addAll(this.constraints);
        }
        if (this.triggers != null) {
            children.addAll(this.triggers);
        }
        if (this.sequences != null) {
            children.addAll(this.sequences);
        }
        if (this.views != null) {
            children.addAll(this.views);
        }
        ArrayList<Right> rights = this.database.getAllRights();
        for (Right right : rights) {
            if (right.getGrantedTable() != this) continue;
            children.add(right);
        }
        return children;
    }

    protected void setColumns(Column[] columns) {
        this.columns = columns;
        if (this.columnMap.size() > 0) {
            this.columnMap.clear();
        }
        for (int i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            int dataType = col.getType();
            if (dataType == -1) {
                throw DbException.get(50004, col.getSQL());
            }
            col.setTable(this, i);
            String columnName = col.getName();
            if (this.columnMap.get(columnName) != null) {
                throw DbException.get(42121, columnName);
            }
            this.columnMap.put(columnName, col);
        }
    }

    public void renameColumn(Column column, String newName) {
        for (Column c : this.columns) {
            if (c == column || !c.getName().equals(newName)) continue;
            throw DbException.get(42121, newName);
        }
        this.columnMap.remove(column.getName());
        column.rename(newName);
        this.columnMap.put(newName, column);
    }

    public boolean isLockedExclusivelyBy(Session session) {
        return false;
    }

    public void updateRows(Prepared prepared, Session session, RowList rows) {
        int rollback = session.getUndoLogPos();
        int rowScanCount = 0;
        rows.reset();
        while (rows.hasNext()) {
            if ((++rowScanCount & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            Row o = rows.next();
            rows.next();
            this.removeRow(session, o);
            session.log(this, (short)1, o);
        }
        rows.reset();
        while (rows.hasNext()) {
            if ((++rowScanCount & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            rows.next();
            Row n = rows.next();
            try {
                this.addRow(session, n);
            }
            catch (DbException e) {
                if (e.getErrorCode() == 90131) {
                    session.rollbackTo(rollback, false);
                }
                throw e;
            }
            session.log(this, (short)0, n);
        }
    }

    public ArrayList<TableView> getViews() {
        return this.views;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        while (this.views != null && this.views.size() > 0) {
            TableView view = this.views.get(0);
            this.views.remove(0);
            this.database.removeSchemaObject(session, view);
        }
        while (this.triggers != null && this.triggers.size() > 0) {
            TriggerObject trigger = this.triggers.get(0);
            this.triggers.remove(0);
            this.database.removeSchemaObject(session, trigger);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            Constraint constraint = this.constraints.get(0);
            this.constraints.remove(0);
            this.database.removeSchemaObject(session, constraint);
        }
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedTable() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        while (this.sequences != null && this.sequences.size() > 0) {
            Sequence sequence = this.sequences.get(0);
            this.sequences.remove(0);
            if (this.isTemporary() || this.database.getDependentTable(sequence, this) != null) continue;
            this.database.removeSchemaObject(session, sequence);
        }
    }

    public void dropSingleColumnConstraintsAndIndexes(Session session, Column col) {
        ArrayList<Constraint> constraintsToDrop = New.arrayList();
        if (this.constraints != null) {
            int size = this.constraints.size();
            for (int i = 0; i < size; ++i) {
                Constraint constraint = this.constraints.get(i);
                HashSet<Column> columns = constraint.getReferencedColumns(this);
                if (!columns.contains(col)) continue;
                if (columns.size() == 1) {
                    constraintsToDrop.add(constraint);
                    continue;
                }
                throw DbException.get(90083, constraint.getSQL());
            }
        }
        ArrayList<Index> indexesToDrop = New.arrayList();
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            int size = indexes.size();
            for (int i = 0; i < size; ++i) {
                Index index = indexes.get(i);
                if (index.getCreateSQL() == null || index.getColumnIndex(col) < 0) continue;
                if (index.getColumns().length == 1) {
                    indexesToDrop.add(index);
                    continue;
                }
                throw DbException.get(90083, index.getSQL());
            }
        }
        for (Constraint c : constraintsToDrop) {
            session.getDatabase().removeSchemaObject(session, c);
        }
        for (Index i : indexesToDrop) {
            if (!this.getIndexes().contains(i)) continue;
            session.getDatabase().removeSchemaObject(session, i);
        }
    }

    public Row getTemplateRow() {
        return new Row(new Value[this.columns.length], -1);
    }

    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        if (singleColumn) {
            return new SimpleRowValue(this.columns.length);
        }
        return new SimpleRow(new Value[this.columns.length]);
    }

    synchronized Row getNullRow() {
        if (this.nullRow == null) {
            this.nullRow = new Row(new Value[this.columns.length], 1);
            for (int i = 0; i < this.columns.length; ++i) {
                this.nullRow.setValue(i, ValueNull.INSTANCE);
            }
        }
        return this.nullRow;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public int getType() {
        return 0;
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public Column getColumn(String columnName) {
        Column column = this.columnMap.get(columnName);
        if (column == null) {
            throw DbException.get(42122, columnName);
        }
        return column;
    }

    public boolean doesColumnExist(String columnName) {
        return this.columnMap.containsKey(columnName);
    }

    public PlanItem getBestPlanItem(Session session, int[] masks) {
        PlanItem item = new PlanItem();
        item.setIndex(this.getScanIndex(session));
        item.cost = item.getIndex().getCost(session, null);
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null && masks != null) {
            int size = indexes.size();
            for (int i = 1; i < size; ++i) {
                Index index = indexes.get(i);
                double cost = index.getCost(session, masks);
                if (!(cost < item.cost)) continue;
                item.cost = cost;
                item.setIndex(index);
            }
        }
        return item;
    }

    public Index findPrimaryKey() {
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            int size = indexes.size();
            for (int i = 0; i < size; ++i) {
                Index idx = indexes.get(i);
                if (!idx.getIndexType().isPrimaryKey()) continue;
                return idx;
            }
        }
        return null;
    }

    public Index getPrimaryKey() {
        Index index = this.findPrimaryKey();
        if (index != null) {
            return index;
        }
        throw DbException.get(42112, "PRIMARY_KEY_");
    }

    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i = 0; i < this.columns.length; ++i) {
            Value v2;
            Value value = row.getValue(i);
            Column column = this.columns[i];
            if (column.getComputed()) {
                value = null;
                Value value2 = column.computeValue(session, row);
            }
            if ((v2 = column.validateConvertUpdateSequence(session, value)) == value) continue;
            row.setValue(i, v2);
        }
    }

    private static void remove(ArrayList<? extends DbObject> list, DbObject obj) {
        int i;
        if (list != null && (i = list.indexOf(obj)) >= 0) {
            list.remove(i);
        }
    }

    public void removeIndex(Index index) {
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            Table.remove(indexes, index);
            if (index.getIndexType().isPrimaryKey()) {
                for (Column col : index.getColumns()) {
                    col.setPrimaryKey(false);
                }
            }
        }
    }

    public void removeView(TableView view) {
        Table.remove(this.views, view);
    }

    public void removeConstraint(Constraint constraint) {
        Table.remove(this.constraints, constraint);
    }

    public void removeSequence(Session session, Sequence sequence) {
        Table.remove(this.sequences, sequence);
    }

    public void removeTrigger(TriggerObject trigger) {
        Table.remove(this.triggers, trigger);
    }

    public void addView(TableView view) {
        this.views = Table.add(this.views, view);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == null || this.constraints.indexOf(constraint) < 0) {
            this.constraints = Table.add(this.constraints, constraint);
        }
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addSequence(Sequence sequence) {
        this.sequences = Table.add(this.sequences, sequence);
    }

    public void addTrigger(TriggerObject trigger) {
        this.triggers = Table.add(this.triggers, trigger);
    }

    private static <T> ArrayList<T> add(ArrayList<T> list, T obj) {
        if (list == null) {
            list = New.arrayList();
        }
        list.add(obj);
        return list;
    }

    public void fire(Session session, int type, boolean beforeAction) {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                trigger.fire(session, type, beforeAction);
            }
        }
    }

    public boolean hasSelectTrigger() {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                if (!trigger.isSelectTrigger()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean fireRow() {
        return this.constraints != null && this.constraints.size() > 0 || this.triggers != null && this.triggers.size() > 0;
    }

    public boolean fireBeforeRow(Session session, Row oldRow, Row newRow) {
        boolean done = this.fireRow(session, oldRow, newRow, true, false);
        this.fireConstraints(session, oldRow, newRow, true);
        return done;
    }

    private void fireConstraints(Session session, Row oldRow, Row newRow, boolean before) {
        if (this.constraints != null) {
            int size = this.constraints.size();
            for (int i = 0; i < size; ++i) {
                Constraint constraint = this.constraints.get(i);
                if (constraint.isBefore() != before) continue;
                constraint.checkRow(session, this, oldRow, newRow);
            }
        }
    }

    public void fireAfterRow(Session session, Row oldRow, Row newRow, boolean rollback) {
        this.fireRow(session, oldRow, newRow, false, rollback);
        if (!rollback) {
            this.fireConstraints(session, oldRow, newRow, false);
        }
    }

    private boolean fireRow(Session session, Row oldRow, Row newRow, boolean beforeAction, boolean rollback) {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                boolean done = trigger.fireRow(session, oldRow, newRow, beforeAction, rollback);
                if (!done) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalTemporary() {
        return false;
    }

    public boolean canTruncate() {
        return false;
    }

    public void setCheckForeignKeyConstraints(Session session, boolean enabled, boolean checkExisting) {
        if (enabled && checkExisting && this.constraints != null) {
            for (Constraint c : this.constraints) {
                c.checkExistingData(session);
            }
        }
        this.checkForeignKeyConstraints = enabled;
    }

    public boolean getCheckForeignKeyConstraints() {
        return this.checkForeignKeyConstraints;
    }

    public Index getIndexForColumn(Column column, boolean first) {
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            int size = indexes.size();
            for (int i = 1; i < size; ++i) {
                int idx;
                Index index = indexes.get(i);
                if (!index.canGetFirstOrLast() || (idx = index.getColumnIndex(column)) != 0) continue;
                return index;
            }
        }
        return null;
    }

    public boolean getOnCommitDrop() {
        return this.onCommitDrop;
    }

    public void setOnCommitDrop(boolean onCommitDrop) {
        this.onCommitDrop = onCommitDrop;
    }

    public boolean getOnCommitTruncate() {
        return this.onCommitTruncate;
    }

    public void setOnCommitTruncate(boolean onCommitTruncate) {
        this.onCommitTruncate = onCommitTruncate;
    }

    public void removeIndexOrTransferOwnership(Session session, Index index) {
        boolean stillNeeded = false;
        if (this.constraints != null) {
            for (Constraint cons : this.constraints) {
                if (!cons.usesIndex(index)) continue;
                cons.setIndexOwner(index);
                this.database.update(session, cons);
                stillNeeded = true;
            }
        }
        if (!stillNeeded) {
            this.database.removeSchemaObject(session, index);
        }
    }

    public ArrayList<Session> checkDeadlock(Session session, Session clash, Set<Session> visited) {
        return null;
    }

    public boolean isPersistIndexes() {
        return this.persistIndexes;
    }

    public boolean isPersistData() {
        return this.persistData;
    }

    public int compareTypeSave(Value a, Value b) {
        if (a == b) {
            return 0;
        }
        int dataType = Value.getHigherOrder(a.getType(), b.getType());
        a = a.convertTo(dataType);
        b = b.convertTo(dataType);
        return a.compareTypeSave(b, this.compareMode);
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public void checkWritingAllowed() {
        this.database.checkWritingAllowed();
    }

    public Value getDefaultValue(Session session, Column column) {
        Expression defaultExpr = column.getDefaultExpression();
        Value v = defaultExpr == null ? column.validateConvertUpdateSequence(session, null) : defaultExpr.getValue(session);
        return column.convert(v);
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }
}

