/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.util.net.Constants;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioServerSocketChannelFactory;

public class DefaultNioServerSocketChannelFactory
extends NioServerSocketChannelFactory {
    public DefaultNioServerSocketChannelFactory() {
    }

    public DefaultNioServerSocketChannelFactory(AsynchronousChannelGroup threadGroup) {
        super(threadGroup);
    }

    @Override
    public void init() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws IOException {
        try {
            if (this.threadGroup != null && this.internalExecutor) {
                this.threadGroup.shutdownNow();
                long timeout = Constants.SHUTDOWN_TIMEOUT;
                if (timeout > 0L) {
                    try {
                        this.threadGroup.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.threadGroup = null;
            this.attributes.clear();
            this.attributes = null;
        }
    }

    @Override
    public void initChannel(NioChannel channel) throws Exception {
    }

    @Override
    public void handshake(NioChannel channel) throws IOException {
    }

    @Override
    public AsynchronousServerSocketChannel createServerChannel(int port, int backlog, InetAddress ifAddress, boolean reuseAddress, boolean internalExecutor) throws IOException {
        this.internalExecutor = internalExecutor;
        return ((AsynchronousServerSocketChannel)this.open().setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddress)).bind(new InetSocketAddress(ifAddress, port), backlog);
    }

    @Override
    public NioChannel acceptChannel(AsynchronousServerSocketChannel listener) throws IOException {
        try {
            return new NioChannel(listener.accept().get());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

