/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleLifecycle;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.BundleException;
import org.osgi.service.resolver.ResolutionException;

public class BundleLifecyclePlugin
extends AbstractIntegrationService<BundleLifecycle> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();

    public BundleLifecyclePlugin() {
        super(IntegrationServices.BUNDLE_LIFECYCLE_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<BundleLifecycle> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected BundleLifecycle createServiceValue(StartContext startContext) throws StartException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        XResolver resolver = (XResolver)this.injectedResolver.getValue();
        XEnvironment environment = (XEnvironment)this.injectedEnvironment.getValue();
        return new BundleLifecycleImpl(bundleManager, environment, resolver);
    }

    static class BundleLifecycleImpl
    implements BundleLifecycle {
        private final BundleManager bundleManager;
        private final XEnvironment environment;
        private final XResolver resolver;

        BundleLifecycleImpl(BundleManager bundleManager, XEnvironment environment, XResolver resolver) {
            this.bundleManager = bundleManager;
            this.environment = environment;
            this.resolver = resolver;
        }

        @Override
        public void install(Deployment dep) throws BundleException {
            this.bundleManager.installBundle(dep, null, null);
        }

        @Override
        public void resolve(XBundle bundle2) throws ResolutionException {
            Set<XBundleRevision> mandatory = Collections.singleton(bundle2.getBundleRevision());
            XResolveContext context = this.resolver.createResolveContext(this.environment, mandatory, null);
            this.resolver.resolveAndApply(context);
        }

        @Override
        public void start(XBundle bundle2, int options) throws BundleException {
            this.bundleManager.startBundle(bundle2, options);
        }

        @Override
        public void stop(XBundle bundle2, int options) throws BundleException {
            this.bundleManager.stopBundle(bundle2, options);
        }

        @Override
        public void update(XBundle bundle2, InputStream input) throws BundleException {
            this.bundleManager.updateBundle(bundle2, input);
        }

        @Override
        public void uninstall(XBundle bundle2, int options) throws BundleException {
            this.bundleManager.uninstallBundle(bundle2, options);
        }
    }
}

