/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleContext;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.LazyActivationTracker;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.ServiceState;
import org.jboss.osgi.framework.spi.StartLevelSupport;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;

final class HostBundleState
extends UserBundleState<HostBundleRevision> {
    private final AtomicBoolean alreadyStarting = new AtomicBoolean();
    private final AtomicBoolean awaitLazyActivation = new AtomicBoolean();
    BundleActivator bundleActivator;

    HostBundleState(FrameworkState frameworkState, HostBundleRevision brev, ServiceName serviceName, ServiceTarget serviceTarget) {
        super(frameworkState, brev, serviceName, serviceTarget);
    }

    static HostBundleState assertBundleState(Bundle bundle2) {
        AbstractBundleState<?> bundleState = AbstractBundleState.assertBundleState(bundle2);
        assert (bundleState instanceof HostBundleState) : "Not a HostBundleState: " + bundleState;
        return (HostBundleState)bundleState;
    }

    @Override
    public BundleContext getBundleContext() {
        return super.getBundleContext();
    }

    public boolean isFragment() {
        return false;
    }

    @Override
    public HostBundleRevision getBundleRevision() {
        return (HostBundleRevision)super.getBundleRevision();
    }

    @Override
    void addBundleRevision(HostBundleRevision brev) {
        super.addBundleRevision(brev);
        this.assignModuleIdentifier(brev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        LazyActivationTracker.startTracking(this, className);
        try {
            Class<?> loadedClass = super.loadClass(className);
            LazyActivationTracker.processLoadedClass(loadedClass);
            Class<?> clazz = loadedClass;
            return clazz;
        }
        finally {
            LazyActivationTracker.stopTracking(this, className);
        }
    }

    @Override
    void initLazyActivation() {
        this.awaitLazyActivation.set(this.isActivationLazy());
    }

    HostBundleContext createContextInternal() {
        return new HostBundleContext(this);
    }

    @Override
    HostBundleRevision createUpdateRevision(Deployment dep, OSGiMetaData metadata, StorageState storageState) throws BundleException {
        return new HostBundleRevision(this.getFrameworkState(), dep, metadata, storageState);
    }

    boolean isActivationLazy() {
        ActivationPolicyMetaData activationPolicy = this.getActivationPolicy();
        String policyType = activationPolicy != null ? activationPolicy.getType() : null;
        return "lazy".equals(policyType);
    }

    ActivationPolicyMetaData getActivationPolicy() {
        return this.getOSGiMetaData().getBundleActivationPolicy();
    }

    boolean awaitLazyActivation() {
        return this.awaitLazyActivation.get();
    }

    void activateLazily() throws BundleException {
        if (this.awaitLazyActivation.getAndSet(false) && this.startLevelValidForStart()) {
            int options = 1;
            if (this.isBundleActivationPolicyUsed()) {
                options |= 2;
            }
            FrameworkLogger.LOGGER.debugf("Lazy activation of: %s", this);
            this.startInternal(options);
        }
    }

    void setBundleActivationPolicyUsed(boolean usePolicy) {
        StorageState storageState = this.getStorageState();
        storageState.setBundleActivationPolicyUsed(usePolicy);
    }

    boolean isAlreadyStarting() {
        return this.alreadyStarting.get();
    }

    Set<HostBundleState> getDependentBundles() {
        HashSet<HostBundleState> result = new HashSet<HostBundleState>();
        if (this.isResolved()) {
            BundleWiring wiring = this.getBundleRevision().getWiring();
            List wires = wiring.getRequiredResourceWires(null);
            for (Wire wire : wires) {
                BundleRevision brev = (BundleRevision)wire.getProvider();
                Bundle bundle2 = brev.getBundle();
                if (!(bundle2 instanceof UserBundleState)) continue;
                result.add((HostBundleState)bundle2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startInternal(int options) throws BundleException {
        LockManager.LockContext lockContext = null;
        LockManager lockManager = this.getFrameworkState().getLockManager();
        try {
            lockContext = lockManager.lockItems(LockManager.Method.START, this);
            try {
                this.alreadyStarting.set(true);
                this.startInternalNow(options);
            }
            finally {
                this.alreadyStarting.set(false);
            }
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    private void startInternalNow(int options) throws BundleException {
        boolean useActivationPolicy;
        if (this.getState() == 32) {
            return;
        }
        this.persistAutoStartSettings(options);
        if (!this.startLevelValidForStart()) {
            StartLevelSupport plugin = this.getCoreServices().getStartLevelSupport();
            int frameworkState = this.getBundleManager().getSystemBundle().getState();
            Logger.Level level = plugin.isChangingStartLevel() || frameworkState != 32 ? Logger.Level.DEBUG : Logger.Level.INFO;
            FrameworkLogger.LOGGER.log(level, FrameworkMessages.MESSAGES.bundleStartLevelNotValid(this.getBundleStartLevel(), plugin.getStartLevel(), (Bundle)this));
            return;
        }
        FrameworkLogger.LOGGER.debugf("Starting bundle: %s", this);
        if (!this.ensureResolved(true)) {
            ResolutionException resex = this.getLastResolutionException();
            throw FrameworkMessages.MESSAGES.cannotResolveBundle(resex, (Bundle)this);
        }
        if (this.getBundleContextInternal() == null) {
            this.createBundleContext();
        }
        boolean bl = useActivationPolicy = (options & 2) != 0;
        if (this.awaitLazyActivation.get() && useActivationPolicy) {
            if (this.getState() == 8) {
                return;
            }
            this.changeState(8, 512);
            return;
        }
        try {
            this.changeState(8);
        }
        catch (LifecycleInterceptorException ex) {
            throw FrameworkMessages.MESSAGES.cannotTransitionToStarting(ex, (Bundle)this);
        }
        String className = this.getOSGiMetaData().getBundleActivator();
        if (className != null) {
            try {
                this.bundleActivator = (BundleActivator)this.getDeployment().getAttachment(BundleActivator.class);
                if (this.bundleActivator == null) {
                    Object result = this.loadClass(className).newInstance();
                    if (result instanceof BundleActivator) {
                        this.bundleActivator = (BundleActivator)result;
                    } else {
                        throw FrameworkMessages.MESSAGES.invalidBundleActivator(className);
                    }
                }
                if (this.bundleActivator != null) {
                    this.bundleActivator.start(this.getBundleContext());
                }
            }
            catch (Throwable th) {
                this.changeState(16);
                this.removeServicesAndListeners(this);
                this.destroyBundleContext();
                this.changeState(4);
                if (th instanceof BundleException) {
                    throw (BundleException)th;
                }
                throw FrameworkMessages.MESSAGES.cannotStartBundle(th, (Bundle)this);
            }
        }
        if (this.getState() == 1) {
            throw FrameworkMessages.MESSAGES.uninstalledDuringActivatorStart((Bundle)this);
        }
        this.changeState(32);
        this.getBundleManagerPlugin().setServiceMode(this.getServiceName(32), ServiceController.Mode.ACTIVE);
        FrameworkLogger.LOGGER.infoBundleStarted((Bundle)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopInternal(int options) throws BundleException {
        LockManager.LockContext lockContext = null;
        LockManager lockManager = this.getFrameworkState().getLockManager();
        try {
            lockContext = lockManager.lockItems(LockManager.Method.STOP, this);
            this.stopInternalNow(options);
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInternalNow(int options) throws BundleException {
        LockManager lockManager;
        LockManager.LockContext lockContext;
        int priorState;
        block9: {
            priorState = this.getState();
            lockContext = null;
            lockManager = this.getFrameworkState().getLockManager();
            try {
                LockManager.LockableItem[] lockItems = new LockManager.LockableItem[]{this};
                lockContext = lockManager.lockItems(LockManager.Method.STOP, lockItems);
                if ((options & 1) == 0) {
                    this.setPersistentlyStarted(false);
                    this.setBundleActivationPolicyUsed(false);
                }
                if (priorState == 8 || priorState == 32) break block9;
                lockManager.unlockItems(lockContext);
                return;
            }
            catch (Throwable throwable) {
                lockManager.unlockItems(lockContext);
                throw throwable;
            }
        }
        this.changeState(16);
        lockManager.unlockItems(lockContext);
        Throwable rethrow = null;
        if (priorState == 32 && this.bundleActivator != null) {
            try {
                this.bundleActivator.stop(this.getBundleContext());
            }
            catch (Throwable t) {
                rethrow = t;
            }
        }
        this.removeServicesAndListeners(this);
        if (this.getState() == 1) {
            throw FrameworkMessages.MESSAGES.uninstalledDuringActivatorStop((Bundle)this);
        }
        this.destroyBundleContext();
        this.changeState(4, 4);
        this.getBundleManagerPlugin().setServiceMode(this.getServiceName(32), ServiceController.Mode.NEVER);
        if (rethrow != null) {
            throw FrameworkMessages.MESSAGES.cannotStopBundle(rethrow, (Bundle)this);
        }
        FrameworkLogger.LOGGER.infoBundleStopped((Bundle)this);
    }

    @Override
    void assertStartConditions(int options) throws BundleException {
        super.assertStartConditions(options);
        List requiredEnvs = this.getOSGiMetaData().getRequiredExecutionEnvironment();
        if (requiredEnvs != null) {
            boolean foundSupportedEnv = false;
            String frameworkEnvProp = (String)this.getBundleManager().getProperty("org.osgi.framework.executionenvironment");
            List<String> availableEnvs = Arrays.asList(frameworkEnvProp.split("[,\\s]+"));
            for (String aux : requiredEnvs) {
                if (!availableEnvs.contains(aux)) continue;
                foundSupportedEnv = true;
                break;
            }
            if (!foundSupportedEnv) {
                throw FrameworkMessages.MESSAGES.unsupportedExecutionEnvironment(requiredEnvs, availableEnvs);
            }
        }
        if (!this.startLevelValidForStart()) {
            if ((options & 1) != 0) {
                throw FrameworkMessages.MESSAGES.cannotStartBundleDueToStartLevel();
            }
            this.persistAutoStartSettings(options);
        }
    }

    private void persistAutoStartSettings(int options) {
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(true);
            boolean activationPolicyUsed = (options & 2) != 0;
            this.setBundleActivationPolicyUsed(activationPolicyUsed);
        }
    }

    private int getBundleStartLevel() {
        StartLevelSupport startLevelPlugin = this.getCoreServices().getStartLevelSupport();
        return startLevelPlugin.getBundleStartLevel((Bundle)this);
    }

    void setPersistentlyStarted(boolean started) {
        StartLevelSupport startLevelPlugin = this.getCoreServices().getStartLevelSupport();
        startLevelPlugin.setBundlePersistentlyStarted(this, started);
    }

    private void assignModuleIdentifier(HostBundleRevision brev) {
        ModuleManager moduleManager = this.getFrameworkState().getModuleManager();
        ModuleIdentifier moduleIdentifier = moduleManager.getModuleIdentifier((XBundleRevision)brev);
        brev.addAttachment(ModuleIdentifier.class, moduleIdentifier);
    }

    private boolean startLevelValidForStart() {
        StartLevelSupport startLevelPlugin = this.getCoreServices().getStartLevelSupport();
        return startLevelPlugin.getBundleStartLevel((Bundle)this) <= startLevelPlugin.getStartLevel();
    }

    private boolean isBundleActivationPolicyUsed() {
        StorageState storageState = this.getStorageState();
        return storageState.isBundleActivationPolicyUsed();
    }

    private void removeServicesAndListeners(HostBundleState hostState) {
        for (ServiceState serviceState : hostState.getRegisteredServicesInternal()) {
            serviceState.unregisterInternal();
        }
        FrameworkEvents eventsPlugin = hostState.getFrameworkState().getFrameworkEvents();
        eventsPlugin.removeBundleListeners(hostState);
    }
}

