/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.ObjectLocalMarshaller;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.sunday.unmarshalling.AbstractPosition;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementPosition;
import org.jboss.xb.binding.sunday.unmarshalling.NonElementPosition;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class WildcardBinding
extends TermBinding {
    private static final short PC_LAX = 3;
    private static final short PC_SKIP = 2;
    private static final short PC_STRICT = 1;
    private SchemaBindingResolver schemaResolver;
    private short pc = 1;
    private ParticleHandler unresolvedElementHandler;
    private CharactersHandler unresolvedCharactersHandler;
    private ObjectLocalMarshaller unresolvedMarshaller;

    public WildcardBinding(SchemaBinding schema) {
        super(schema);
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public short getProcessContents() {
        return this.pc;
    }

    public void setProcessContents(short pc) {
        this.pc = pc;
        if (pc != 3 && pc != 2 && pc != 1) {
            throw new JBossXBRuntimeException("Unexpected value for process contents: " + pc);
        }
    }

    public boolean isProcessContentsLax() {
        return this.pc == 3;
    }

    public boolean isProcessContentsSkip() {
        return this.pc == 2;
    }

    public boolean isProcessContentsStrict() {
        return this.pc == 1;
    }

    @Deprecated
    public void setWildcardHandler(ParticleHandler wildcardHandler) {
        this.handler = wildcardHandler;
    }

    public ParticleHandler getWildcardHandler() {
        return this.handler;
    }

    public ParticleHandler getUnresolvedElementHandler() {
        return this.unresolvedElementHandler;
    }

    public void setUnresolvedElementHandler(ParticleHandler unresolvedElementHandler) {
        this.unresolvedElementHandler = unresolvedElementHandler;
    }

    public CharactersHandler getUnresolvedCharactersHandler() {
        return this.unresolvedCharactersHandler;
    }

    public void setUnresolvedCharactersHandler(CharactersHandler unresolvedCharactersHandler) {
        this.unresolvedCharactersHandler = unresolvedCharactersHandler;
    }

    public ObjectLocalMarshaller getUnresolvedMarshaller() {
        return this.unresolvedMarshaller;
    }

    public void setUnresolvedMarshaller(ObjectLocalMarshaller marshaller) {
        this.unresolvedMarshaller = marshaller;
    }

    public ElementBinding getElement(QName qName, Attributes attrs) {
        if (this.pc == 2) {
            return this.getUnresolvedElement(qName, false);
        }
        ElementBinding element = null;
        if (this.schema != null) {
            element = this.schema.getElement(qName);
        }
        if (element == null) {
            SchemaBindingResolver resolver = this.schemaResolver;
            if (resolver == null && this.schema != null) {
                resolver = this.schema.getSchemaResolver();
            }
            if (resolver != null) {
                String schemaLocation = attrs == null ? null : Util.getSchemaLocation(attrs, qName.getNamespaceURI());
                SchemaBinding schema = resolver.resolve(qName.getNamespaceURI(), qName.getLocalPart(), schemaLocation);
                if (schema != null) {
                    element = schema.getElement(qName);
                }
            }
        }
        if (element == null && this.pc == 3) {
            element = this.getUnresolvedElement(qName, false);
        }
        return element;
    }

    private ElementBinding getUnresolvedElement(QName qName, boolean required) {
        if (this.unresolvedElementHandler == null) {
            if (required) {
                throw new JBossXBRuntimeException("Schema could not be resolved for wildcard content element " + qName + " and particle handler for unresolved wildcard content elements is not initialized.");
            }
            ParticleBinding particle = new ParticleBinding(this);
            SequenceBinding sequence = new SequenceBinding(this.schema);
            sequence.addParticle(particle);
            TypeBinding type = new TypeBinding();
            type.setParticle(new ParticleBinding(sequence));
            ElementBinding element = new ElementBinding(this.schema, qName, type);
            element.setSkip(true);
            return element;
        }
        WildcardBinding unresolvedWildcard = new WildcardBinding(this.schema);
        unresolvedWildcard.pc = (short)3;
        unresolvedWildcard.schemaResolver = this.schemaResolver;
        unresolvedWildcard.unresolvedCharactersHandler = this.unresolvedCharactersHandler;
        unresolvedWildcard.unresolvedElementHandler = this.unresolvedElementHandler;
        ParticleBinding particle = new ParticleBinding(unresolvedWildcard);
        SequenceBinding sequence = new SequenceBinding(this.schema);
        sequence.addParticle(particle);
        TypeBinding type = new TypeBinding();
        type.setHandler(this.unresolvedElementHandler);
        type.setSimpleType(this.unresolvedCharactersHandler);
        type.setParticle(new ParticleBinding(sequence, 1, 0, true));
        ElementBinding element = new ElementBinding(this.schema, qName, type);
        element.setRepeatableHandler(this.repeatableHandler);
        return element;
    }

    @Override
    public AbstractPosition newPosition(QName qName, Attributes attrs, ParticleBinding wildcardParticle) {
        ElementBinding wildcardContent = this.getElement(qName, attrs);
        if (wildcardContent != null) {
            ParticleBinding particle = new ParticleBinding(wildcardContent);
            ElementPosition next = wildcardContent.newPosition(qName, attrs, particle);
            return new WildcardPosition(qName, wildcardParticle, next);
        }
        return null;
    }

    @Override
    public boolean isSkip() {
        return this.skip != 1;
    }

    @Override
    public boolean isModelGroup() {
        return false;
    }

    @Override
    public boolean isWildcard() {
        return true;
    }

    @Override
    public boolean isElement() {
        return false;
    }

    public String toString() {
        String processContent;
        switch (this.pc) {
            case 3: {
                processContent = "lax";
                break;
            }
            case 2: {
                processContent = "skip";
                break;
            }
            case 1: {
                processContent = "strict";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected processContents value: " + this.pc);
            }
        }
        return "wildcard processContents=" + processContent;
    }

    private final class WildcardPosition
    extends NonElementPosition {
        protected WildcardPosition(QName name, ParticleBinding particle, AbstractPosition next) {
            super(name, particle, next);
        }

        @Override
        public AbstractPosition nextPosition(QName name, Attributes atts) {
            ElementBinding wildcardContent;
            if (this.particle.isOccurrenceAllowed(this.occurrence + 1) && (wildcardContent = WildcardBinding.this.getElement(name, atts)) != null) {
                ParticleBinding wildcardParticle = new ParticleBinding(wildcardContent);
                this.next = wildcardContent.newPosition(name, atts, wildcardParticle);
                this.next.previous = this;
                ++this.occurrence;
                if (!this.skip) {
                    this.o = this.handler.endParticle(this.o, this.qName, this.particle);
                    if (this.previous.o != null) {
                        this.setParent(this.previous, this.handler);
                    }
                }
                return this;
            }
            this.nextNotFound();
            return null;
        }

        @Override
        protected AbstractPosition getLastNotSkipped() {
            return !this.skip || this.repeatableParticleValue != null || this.previous != this.notSkippedParent ? this : this.notSkippedParent;
        }

        @Override
        protected void initHandler() {
            this.handler = DefaultHandlers.NOOP_PARTICLE_HANDLER;
        }
    }
}

