/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.RepeatableParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.util.CollectionFactory;

public class CollectionRepeatableParticleHandler
implements RepeatableParticleHandler {
    private AbstractPropertyHandler propertyHandler;
    private CollectionFactory colFactory;
    private ValueAdapter valueAdapter;
    private TypeInfo componentType;

    public CollectionRepeatableParticleHandler(AbstractPropertyHandler propertyHandler, ClassInfo collectionType, ValueAdapter valueAdapter) {
        if (propertyHandler == null) {
            throw new IllegalArgumentException("Null property handler.");
        }
        this.colFactory = CollectionFactory.getFactory(collectionType);
        this.componentType = collectionType.getComponentType();
        this.valueAdapter = valueAdapter;
        this.propertyHandler = propertyHandler;
    }

    @Override
    public Object startRepeatableParticle(Object parent, QName startName, ParticleBinding particle) {
        try {
            return this.colFactory.createCollection();
        }
        catch (Throwable e) {
            throw new JBossXBRuntimeException("Failed to create collection for " + startName, e);
        }
    }

    @Override
    public void endRepeatableParticle(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
        if (o == null) {
            return;
        }
        if (this.valueAdapter != null) {
            o = this.valueAdapter.cast(o, null);
        }
        this.propertyHandler.doHandle(parent, o, elementName);
    }

    @Override
    public void addTermValue(Object particleValue, Object termValue, QName elementName, ParticleBinding particle, ParticleBinding parentParticle, ParticleHandler handler) {
        if (this.componentType != null && termValue != null && !this.componentType.isInstance(termValue)) {
            throw new IllegalArgumentException("Child is not an instance of " + this.componentType + ", child: " + termValue);
        }
        ((Collection)particleValue).add(termValue);
    }
}

