/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.felix;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.resolver.ResolverImpl;
import org.jboss.osgi.resolver.ResolverLogger;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.felix.LoggerDelegate;
import org.jboss.osgi.resolver.spi.AbstractResolveContext;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

public class StatelessResolver
implements XResolver {
    private ResolverImpl delegate = new ResolverImpl(new LoggerDelegate());

    public Map<Resource, List<Wire>> resolve(ResolveContext context) throws ResolutionException {
        Collection mandatory = context.getMandatoryResources();
        Collection optional = context.getOptionalResources();
        ResolverLogger.LOGGER.debugf("Resolve: %s, %s", (Object)mandatory, (Object)optional);
        Map<Resource, List<Wire>> result = this.delegate.resolve(context);
        if (ResolverLogger.LOGGER.isDebugEnabled()) {
            ResolverLogger.LOGGER.debugf("Resolution result: %d", (Object)result.size());
            for (Map.Entry<Resource, List<Wire>> entry : result.entrySet()) {
                Resource res = entry.getKey();
                List<Wire> wires = entry.getValue();
                ResolverLogger.LOGGER.debugf("   %s: %d wires", (Object)res, (Object)wires.size());
                for (Wire wire : wires) {
                    ResolverLogger.LOGGER.debugf("      %s", (Object)wire);
                }
            }
        }
        return result;
    }

    public synchronized Map<Resource, Wiring> resolveAndApply(XResolveContext context) throws ResolutionException {
        Map<Resource, List<Wire>> wiremap = this.resolve((ResolveContext)context);
        return context.getEnvironment().updateWiring(wiremap);
    }

    public XResolveContext createResolveContext(XEnvironment environment, final Collection<? extends Resource> mandatory, final Collection<? extends Resource> optional) {
        return new AbstractResolveContext(environment){

            public Collection<Resource> getMandatoryResources() {
                return mandatory != null ? Collections.unmodifiableCollection(mandatory) : super.getMandatoryResources();
            }

            public Collection<Resource> getOptionalResources() {
                return optional != null ? Collections.unmodifiableCollection(optional) : super.getOptionalResources();
            }
        };
    }
}

